package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.vo.PlanDetailRefVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.PlanMapper;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.service.IPlanService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 使用计划实体
 * 
 * @author generator
 * 
 */
@Service("planService")
public class PlanServiceImpl extends BaseServiceImpl<PlanMapper, PlanEntity> implements IPlanService{
    private static final String WZXT_PLAN_BILL_CODE = "CSCEC5BHN_WZXT_PLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IOrgApi orgApi;
    @Override
    public CommonResponse<PlanVO> saveOrUpdate(PlanVO planVO) {


        //查询项目部上级组织的的来源id
        CommonResponse<OrgVO> orgParentVo = orgApi.getOneById(planVO.getParentOrgId());
        if(!orgParentVo.isSuccess()) {
            return CommonResponse.success("查询组织详情失败！");
        }

        planVO.setParentOrgSourceId(orgParentVo.getData().getSourceId());
        planVO.setPlanFlag("1");
        planVO.setHistoryFlag(false);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(planVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_PLAN_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                planVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        PlanEntity entity = BeanMapper.map(planVO, PlanEntity.class);
        //汇总物资明细名称
        List<PlanDetailEntity> planDetail = entity.getPlanDetail();
        String materialName = "";
        if(planDetail != null && planDetail.size() > 0){
            for(PlanDetailEntity applyDetailEntity : planDetail){
                materialName = materialName + applyDetailEntity.getMaterialName() + ",";
                if (applyDetailEntity.getNums() != null){
                    BigDecimal nums = applyDetailEntity.getNums() == null ? BigDecimal.ZERO : applyDetailEntity.getNums();
                    BigDecimal occupyNums = applyDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : applyDetailEntity.getOccupyNums();
                    BigDecimal surplusNums = nums.subtract(occupyNums);
                    applyDetailEntity.setSurplusNums(surplusNums);
                    applyDetailEntity.setOccupyNums(occupyNums);
                    applyDetailEntity.setNums(nums);
                }
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        planService.saveOrUpdate(entity, false);
        PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public List<PlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId,QueryWrapper queryWrapper) {
        List<PlanDetailRefVO> planVOList = baseMapper.getPlanByMaterialId(materialListId,queryWrapper);
        return planVOList;
    }
}
