/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.ejianc.business.storecloud.api.IWarehouseFlowApi;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.enums.InOutFlagEnum;
import com.ejianc.business.wzxt.enums.InOutTypeEnum;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="check")
public class CheckBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IWarehouseFlowApi iWarehouseFlowApi;
    @Autowired
    private IOrgApi orgApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        if (entity.getSaveState() == 0) {
            entity.setSaveState(1);
            this.checkService.saveOrUpdate((Object)entity, false);
            this.logger.info("\u5355\u636e----" + billId + "----\u5df2\u4fdd\u5b58");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("======================================\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03====================================== state:" + state);
        if (state == 0 || state == 2) {
            this.logger.info("======================================\u7ec8\u5ba1\u8fdb\u5165\u5224\u65ad====================================== state:" + state);
            CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
            ArrayList<WarehouseFlowVO> warehouseFlowVOList = new ArrayList<WarehouseFlowVO>();
            WarehouseFlowVO warehouseFlowVO = new WarehouseFlowVO();
            for (CheckDetailEntity checkDetailEntity : checkEntity.getDetailList()) {
                warehouseFlowVO.setInOutFlag(InOutFlagEnum.\u5165\u5e93.getCode());
                warehouseFlowVO.setInOutType(InOutTypeEnum.\u9a8c\u6536\u5165\u5e93_\u6cb3\u5357.getCode());
                warehouseFlowVO.setBillCode(checkEntity.getBillCode());
                warehouseFlowVO.setBillDate(checkEntity.getCreateTime());
                warehouseFlowVO.setProjectId(checkEntity.getProjectId());
                warehouseFlowVO.setProjectName(checkEntity.getProjectName());
                warehouseFlowVO.setParentOrgId(checkEntity.getParentOrgId());
                CommonResponse orgVO = this.orgApi.getOneById(checkEntity.getParentOrgId());
                warehouseFlowVO.setParentOrgCode(((OrgVO)orgVO.getData()).getCode());
                warehouseFlowVO.setParentOrgName(((OrgVO)orgVO.getData()).getName());
                warehouseFlowVO.setOrgId(checkEntity.getOrgId());
                warehouseFlowVO.setOrgName(checkEntity.getOrgName());
                warehouseFlowVO.setStoreId(checkEntity.getWarehouseId());
                warehouseFlowVO.setStoreName(checkEntity.getWarehouseName());
                warehouseFlowVO.setEmployeeId(checkEntity.getEmployeeId());
                warehouseFlowVO.setEmployeeName(checkEntity.getEmployeeName());
                warehouseFlowVO.setInOutTypeName("\u9a8c\u6536\u5165\u5e93\uff08\u6cb3\u5357\uff09");
                warehouseFlowVO.setMaterialCategoryId(checkDetailEntity.getMaterialTypeId());
                warehouseFlowVO.setMaterialCategoryName(checkDetailEntity.getMaterialTypeName());
                warehouseFlowVO.setSourceBillDate(checkDetailEntity.getCreateTime());
                warehouseFlowVO.setSourceBillTypeCode("BT210816000000002");
                warehouseFlowVO.setSourceBillTypeName("\u7269\u8d44\u9a8c\u6536");
                warehouseFlowVO.setSourceId(checkEntity.getId());
                warehouseFlowVO.setSourceDetailId(checkDetailEntity.getId());
                warehouseFlowVO.setSourceBillCode(checkEntity.getBillCode());
                warehouseFlowVO.setMaterialId(checkDetailEntity.getMaterialId());
                warehouseFlowVO.setMaterialName(checkDetailEntity.getMaterialName());
                warehouseFlowVO.setMaterialCode(checkDetailEntity.getMaterialCode());
                warehouseFlowVO.setMaterialTypeName(checkDetailEntity.getMaterialTypeName());
                warehouseFlowVO.setMaterialSpec(checkDetailEntity.getSpec());
                warehouseFlowVO.setMaterialUnitName(checkDetailEntity.getUnit());
                warehouseFlowVO.setNum(checkDetailEntity.getInstoreNum());
                BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)checkDetailEntity.getInstoreNum(), (BigDecimal)checkDetailEntity.getNtaxprice());
                BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)checkDetailEntity.getInstoreNum(), (BigDecimal)checkDetailEntity.getNprice());
                warehouseFlowVO.setTaxMny(taxMny);
                warehouseFlowVO.setMny(mny);
                warehouseFlowVO.setTaxPrice(checkDetailEntity.getNtaxprice());
                warehouseFlowVO.setPrice(checkDetailEntity.getNprice());
                warehouseFlowVO.setTax(checkDetailEntity.getTax());
                warehouseFlowVO.setTaxRate(checkDetailEntity.getTaxrate());
                warehouseFlowVOList.add(warehouseFlowVO);
                this.logger.info("======\u6253\u5370\u91d1\u989d===== warehouseFlowVO.getTaxMny():" + warehouseFlowVO.getTaxMny() + "///warehouseFlowVO.getMny():" + warehouseFlowVO.getMny() + "///warehouseFlowVO.getTaxPrice():" + warehouseFlowVO.getTaxPrice() + "///warehouseFlowVO.getPrice():" + warehouseFlowVO.getPrice() + "///warehouseFlowVO.getTax():" + warehouseFlowVO.getTax() + "///warehouseFlowVO.getTaxRate():" + warehouseFlowVO.getTaxRate() + "///");
            }
            WarehouseManageVO manageVO = new WarehouseManageVO();
            manageVO.setProjectId(checkEntity.getProjectId());
            manageVO.setStoreId(checkEntity.getWarehouseId());
            manageVO.setInOutFlag(InOutFlagEnum.\u5165\u5e93.getCode());
            manageVO.setType(Integer.valueOf(2));
            manageVO.setFlowVOList(warehouseFlowVOList);
            CommonResponse flag = this.iWarehouseFlowApi.push(manageVO);
            this.logger.info("======================================\u7ec8\u5ba1\u63a8\u9001\u5b8c\u6210====================================== flag:" + flag);
            return flag;
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        if (entity.getUseState() == 1) {
            this.logger.info("\u5355\u636e----" + billId + "----\u5df2\u63a8\u9001NC");
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u63a8\u9001NC\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
        }
        if (null != entity.getMroState() && entity.getMroState() == 1) {
            this.logger.info("\u5355\u636e----" + billId + "----\u5df2\u63a8\u9001MRO");
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u63a8\u9001MRO\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

