/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.ExitApplyEntity;
import com.ejianc.business.wzxt.bean.ExitEntity;
import com.ejianc.business.wzxt.mapper.ExitMapper;
import com.ejianc.business.wzxt.service.IExitApplyService;
import com.ejianc.business.wzxt.service.IExitService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.ExitDetailGFVO;
import com.ejianc.business.wzxt.vo.ExitGFVO;
import com.ejianc.business.wzxt.vo.ExitReportVO;
import com.ejianc.business.wzxt.vo.ExitVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="exitService")
public class ExitServiceImpl
extends BaseServiceImpl<ExitMapper, ExitEntity>
implements IExitService {
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${wjy.path}")
    private String wjyPath;
    @Value(value="${wjy.appid}")
    private String appid;
    @Value(value="${openApi.wjExitUrl}")
    private String wjExitUrl;
    private static final String WJ_WZXT_EXIT = "WJHN_WZXT_EXIT";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IExitApplyService exitApplyService;

    @Override
    public ExitVO saveOrUpdate(ExitVO saveorUpdateVO) {
        StringBuffer materialName = new StringBuffer();
        if (CollectionUtils.isNotEmpty((Collection)saveorUpdateVO.getExitDetail())) {
            saveorUpdateVO.getExitDetail().forEach(vo -> materialName.append(vo.getMaterialName() + ","));
            String materialNames = materialName.substring(0, materialName.length() - 1);
            saveorUpdateVO.setMaterialName(materialNames);
        }
        ExitEntity entity = (ExitEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ExitEntity.class));
        entity.setConfirmFlag(0);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WJ_WZXT_EXIT, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        ExitApplyEntity exitApplyEntity = (ExitApplyEntity)((Object)this.exitApplyService.selectById(entity.getApplyId()));
        ExitVO resVo = (ExitVO)BeanMapper.map((Object)((Object)entity), ExitVO.class);
        resVo.setApplyState(exitApplyEntity.getApplyState());
        return resVo;
    }

    @Override
    public CommonResponse<ExitVO> updateConfirmFlag(ExitVO exitVO) {
        ExitEntity entity = (ExitEntity)((Object)super.getById((Serializable)exitVO.getId()));
        entity.setConfirmFlag(exitVO.getConfirmFlag());
        entity.setConfirmDate(DateFormater.getCurrentDate());
        entity.setConfirmerId(exitVO.getConfirmerId());
        entity.setConfirmerName(exitVO.getConfirmerName());
        entity.setConfirmNote(exitVO.getConfirmNote());
        String msg = "\u786e\u8ba4";
        if (2 == exitVO.getConfirmFlag()) {
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            msg = "\u62d2\u7edd";
        }
        super.saveOrUpdate((Object)entity, false);
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjy");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(String.valueOf(entity.getCommitId()));
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
        String formurl = this.baseHost + "cscec5bhn-wzxt-frontend/#/exit/card?id=" + entity.getId();
        String subject = "\u60a8\u7684\u9000\u573a\u5355\u3010" + entity.getProjectName() + "--" + entity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011" + msg + "\u3002";
        String content = "\u60a8\u7684\u9000\u573a\u5355\u3010" + entity.getProjectName() + "--" + entity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011" + msg + "\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.sendMsg(messageType, sender, "notice", subject, content, String.valueOf(entity.getTenantId()), entity);
        return CommonResponse.success();
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String tenantId, ExitEntity entity) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("wjy")) {
            channel.add("wjy");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", (Object)this.appid);
            wjyMsgParams.put("from", (Object)"\u4f9b\u65b9\u5e73\u53f0");
            wjyMsgParams.put("msg", (Object)subject);
            wjyMsgParams.put("url", (Object)(this.wjyPath + "cscec5bhn-wzxt-mobile/#/walkoffIndex/details?id=" + entity.getId() + "&userid={userid}"));
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }

    @Override
    public CommonResponse<String> pushConfirmEntity(Map<String, String> headers, ExitEntity exitEntity) {
        String url = this.wjExitUrl;
        ExitGFVO purchase = new ExitGFVO();
        purchase.setId(String.valueOf(exitEntity.getId()));
        purchase.setApplyId(String.valueOf(exitEntity.getApplyId()));
        purchase.setOrgId(exitEntity.getParentOrgSourceId());
        purchase.setOrgName(exitEntity.getOrgName());
        purchase.setConfirmFlag(Integer.valueOf(0));
        purchase.setProjectId(exitEntity.getProjectSourceId());
        purchase.setProjectName(exitEntity.getProjectName());
        purchase.setBillCode(exitEntity.getBillCode());
        purchase.setSupplierId(exitEntity.getSupplierSourceId());
        purchase.setSupplierName(exitEntity.getSupplierName());
        purchase.setContractId(exitEntity.getContractId());
        purchase.setContractName(exitEntity.getContractName());
        purchase.setContractCode(exitEntity.getContractCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        purchase.setExitDate(formatter.format(exitEntity.getExitDate()));
        purchase.setExitNote(exitEntity.getExitNote());
        purchase.setLinkName(exitEntity.getLinkName());
        purchase.setLinkTelephone(exitEntity.getLinkTelephone());
        purchase.setPkCreator("hnxpt");
        purchase.setSysmark("hnxpt");
        purchase.setCreatorName("\u4e94\u5c40\u65b0\u5e73\u53f0");
        purchase.setCreatorDate(DateFormater.getInstance().format("yyyy-MM-dd HH:mm:ss"));
        CommonResponse sceneurRes = this.attachmentApi.queryListBySourceId(exitEntity.getId(), "BT210816000000006", "imgUpload2", null);
        if (sceneurRes.isSuccess()) {
            ArrayList sceneurlList = new ArrayList();
            sceneurlList.addAll(((List)sceneurRes.getData()).stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(sceneurlList)) {
                purchase.setSceneurl(String.join((CharSequence)",", sceneurlList));
            }
        }
        CommonResponse czsignurlRes = this.attachmentApi.queryListBySourceId(exitEntity.getId(), "BT210816000000006", "imgUpload3", null);
        ArrayList czsignurllList = new ArrayList();
        if (czsignurlRes.isSuccess()) {
            czsignurllList.addAll(((List)czsignurlRes.getData()).stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(czsignurllList)) {
                purchase.setCzsignurl(String.join((CharSequence)",", czsignurllList));
            }
        }
        CommonResponse jlsingurlRes = this.attachmentApi.queryListBySourceId(exitEntity.getId(), "BT210816000000006", "imgUpload4", null);
        ArrayList jlsingurlList = new ArrayList();
        if (jlsingurlRes.isSuccess()) {
            jlsingurlList.addAll(((List)jlsingurlRes.getData()).stream().map(AttachmentVO::getFilePath).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(jlsingurlList)) {
                purchase.setJlsingurl(String.join((CharSequence)",", jlsingurlList));
            }
        }
        if (CollectionUtils.isNotEmpty(exitEntity.getExitDetail())) {
            ArrayList list = new ArrayList();
            exitEntity.getExitDetail().forEach(e -> {
                ExitDetailGFVO vo = new ExitDetailGFVO();
                vo.setId(String.valueOf(e.getId()));
                vo.setExitId(String.valueOf(exitEntity.getId()));
                vo.setMaterialId(e.getMaterialSourceId());
                vo.setMaterialCode(e.getMaterialCode());
                vo.setMaterialTypeName(e.getMaterialTypeName());
                vo.setMaterialName(e.getMaterialName());
                vo.setSpec(e.getSpec());
                vo.setUnit(e.getUnit());
                vo.setStopDate(formatter.format(e.getStopDate()));
                vo.setDef1(e.getDef1());
                vo.setDef2(e.getDef2());
                vo.setDef3(e.getDef3());
                vo.setDef4(e.getDef4());
                vo.setDef5(e.getDef5());
                vo.setMemo(e.getMemo());
                vo.setApplyNums(e.getApplyNums() == null ? BigDecimal.ZERO : e.getApplyNums());
                vo.setExitNums(e.getExitNums() == null ? BigDecimal.ZERO : e.getExitNums());
                vo.setExitNumsSum(e.getExitNumsSum() == null ? BigDecimal.ZERO : e.getExitNumsSum());
                list.add(vo);
            });
            purchase.setExitDetailList(list);
        }
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)purchase).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e2) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u8ba2\u5355\u5f02\u5e38!");
        }
    }

    @Override
    public List<ExitReportVO> queryExitReport(QueryWrapper queryWrapper) {
        return ((ExitMapper)this.baseMapper).queryExitReport(queryWrapper);
    }

    @Override
    public List<ExitReportVO> queryZlReports(QueryWrapper queryWrapper, Long projectId, Long supplierId) {
        return ((ExitMapper)this.baseMapper).queryZlReport(queryWrapper, projectId, supplierId);
    }

    @Override
    public List<ExitReportVO> queryCgReports(QueryWrapper queryWrapper, Long projectId) {
        return ((ExitMapper)this.baseMapper).queryCgReports(queryWrapper, projectId);
    }
}

