package com.ejianc.business.wzxt.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.wzxt.bean.ControlPlanEntity;
import com.ejianc.business.wzxt.service.IControlPlanService;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 总控计划实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("controlPlan")
public class ControlPlanController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IControlPlanService service;
    @Autowired
    private IOrgApi orgApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ControlPlanVO> saveOrUpdate(@RequestBody ControlPlanVO saveorUpdateVO) {
    	ControlPlanEntity entity = BeanMapper.map(saveorUpdateVO, ControlPlanEntity.class);
    	service.saveOrUpdate(entity, false);
    	ControlPlanVO vo = BeanMapper.map(entity, ControlPlanVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ControlPlanVO> queryDetail(Long id) {
    	ControlPlanEntity entity = service.selectById(id);
    	ControlPlanVO vo = BeanMapper.map(entity, ControlPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlPlanVO> vos) {
        service.removeByIds(vos.stream().map(ControlPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * @Description 根据项目主键和物料主键查询总控数量和累计进场量
     * @Param [ids]
     */
    @RequestMapping(value = "/getNumByProjectId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ConCheckVO>> getNumByProjectId(@RequestBody ConCheckVO conCheckVO) {
        List<ConCheckVO> list = service.getNumByProjectId(conCheckVO);
        return CommonResponse.success("成功！",list);
    }
    /**
     * @Description 根据项目主键和物料主键查询总控数量和累计进场量(不包含周转材)
     * @Param [ids]
     */
    @RequestMapping(value = "/getCGNumByProjectId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ConCheckVO>> getCGNumByProjectId(@RequestBody ConCheckVO conCheckVO) {
        List<ConCheckVO> list = service.getCGNumByProjectId(conCheckVO);
        return CommonResponse.success("成功！",list);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ControlPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if(null!=orgId&&orgId>0){
            List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                return CommonResponse.success("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
        }else{
            //移动端没有当前组织，按照当前登录人权限取组织
            CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if(!childOrgResp.isSuccess()) {
                throw new BusinessException("查询组织信息失败！");
            }
            List<Long> childIds = new ArrayList<>();
            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
            }
        }
        IPage<ControlPlanEntity> page = service.queryPage(param,false);
        IPage<ControlPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ControlPlanVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 总控计划参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/controlPlanRef")
    @ResponseBody
    public CommonResponse<JSONObject> controlPlanRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                              @RequestParam(defaultValue = "10") Integer pageSize,
                                              @RequestParam(value = "condition", required = false) String condition,
                                              @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        Page<ControlPlanRefVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<ControlPlanRefVO> list = service.getControlPlan(page,wrapper,projectId,InvocationInfoProxy.getTenantid());
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

}
