package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.CountDetailEntity;
import com.ejianc.business.wzxt.service.ICountDetailService;
import com.ejianc.business.wzxt.vo.CountDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 智能点数实体明细表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("countDetail")
public class CountDetailController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ICountDetailService countDetailService;
    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CountDetailVO> saveOrUpdate(@RequestBody CountDetailVO saveorUpdateVO) {
    	CountDetailEntity entity = BeanMapper.map(saveorUpdateVO, CountDetailEntity.class);
        countDetailService.saveOrUpdate(entity, false);
    	CountDetailVO vo = BeanMapper.map(entity, CountDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /*
     * @Description saveOrUpdate 判断物料是否符合智能点数
     */
    @RequestMapping(value = "/isSmartCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CountDetailVO> isSmartCount(Long materialId) {
        return countDetailService.isSmartCount(materialId);
    }

    /**
     * @Description saveOrUpdate
     */
    @RequestMapping(value = "/MaterialBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<CountDetailVO>> MaterialBatch(@RequestBody List<CountDetailVO> saveorUpdateBatchVO) {

        Long orgId = InvocationInfoProxy.getOrgId();
        LambdaQueryWrapper<CountDetailEntity> queryWrapperDetailOld = Wrappers.<CountDetailEntity>lambdaQuery();
        queryWrapperDetailOld.eq(CountDetailEntity::getOrgId, orgId);
        List<CountDetailEntity> countDetailEntityListOld = countDetailService.list(queryWrapperDetailOld);
        List<CountDetailVO> removeList =  new ArrayList<>();
        if (ListUtil.isNotEmpty(countDetailEntityListOld)) {

            // 过滤重复的物料，如果新引入与已引入物料，删除新引入的重复物料，保留已引入的物料及设置
            for (CountDetailVO countDetailVO : saveorUpdateBatchVO){
                for (CountDetailEntity countDetailEntity : countDetailEntityListOld){
                    if (countDetailVO.getMaterialId().equals(countDetailEntity.getMaterialId())){
                        removeList.add(countDetailVO);
                    }

                }
            }
        }
        if (ListUtil.isNotEmpty(removeList)){
            saveorUpdateBatchVO.removeAll(removeList);
        }

        for (CountDetailVO countDetailVO : saveorUpdateBatchVO){
            countDetailVO.setOrgId(orgId);
        }
        List<CountDetailEntity> listEntity = BeanMapper.mapList(saveorUpdateBatchVO, CountDetailEntity.class);
        countDetailService.saveOrUpdateBatch(listEntity);
    	List<CountDetailVO> vo = BeanMapper.mapList(listEntity, CountDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CountDetailVO> queryDetail(Long id) {
    	CountDetailEntity entity = countDetailService.selectById(id);
    	CountDetailVO vo = BeanMapper.map(entity, CountDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CountDetailVO> vos) {
        countDetailService.removeByIds(vos.stream().map(CountDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CountDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //模糊搜索：材料名称、材料编码
        //高级搜索：智能点数
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));

        IPage<CountDetailEntity> page = countDetailService.queryPage(param,false);
        IPage<CountDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CountDetailVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
     /**
      * * @Description queryDetail 根据项目部主键+物料主键查询信息
     * @param
     */
    @RequestMapping(value = "/getdetailByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CountDetailVO> getdetailByOrgId(Long projectDepartmentId,Long materialId) {
        return countDetailService.getdetailByOrgId(projectDepartmentId,materialId);
    }
}
