package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.ExitApplyEntity;
import com.ejianc.business.wzxt.service.CommonSupportService;
import com.ejianc.business.wzxt.service.IExitApplyService;
import com.ejianc.business.wzxt.vo.ExitApplyDetailVO;
import com.ejianc.business.wzxt.vo.ExitApplyVO;
import com.ejianc.business.wzxt.vo.OrderProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 退场申请单
 *
 * @author generator
 */
@Controller
@RequestMapping("exitApply")
public class ExitApplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IExitApplyService service;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;


    @Autowired
    private CommonSupportService commonSupportService;

    private static final String billCodeRule = "CSCEC5BHN_WZXT_EXIT_APPLY";


    /**
     * 修改确认结果信息
     *
     * @Param exitApplyVOS: 确认结果集合
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Boolean>
     * @Author songlx
     * @Date 2021-03-18
     **/
    @RequestMapping(value = "/updateConfirmFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitApplyVO> updateConfirmFlag(@RequestBody ExitApplyVO exitApplyVO) {

        if (null != exitApplyVO.getId()) {
            ExitApplyEntity entity = service.getById(exitApplyVO.getId());
            if (entity == null) {
                return CommonResponse.error("修改失败！【" + exitApplyVO.getId() + "】单据不存在！");
            }
        }
        return service.updateConfirmFlag(exitApplyVO);
    }

    /**
     * 查询组织
     *
     * @Param orgId: orgId
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.OrderProjectVO>
     * @Author songlx
     * @Date 2021-03-23
     **/
    @RequestMapping(value = "/queryOrgSource", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderProjectVO> queryOrgSource(Long orgId) {
        OrderProjectVO res = new OrderProjectVO();
        CommonResponse<OrgVO> orgVo = orgApi.getOneById(orgId);
        if (!orgVo.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        if (null != orgVo.getData()) {
            res.setOrgId(orgId);
            res.setOrgSourceId(orgVo.getData().getSourceId());
            res.setParentOrgId(orgVo.getData().getParentId());
            //查询上级
            CommonResponse<OrgVO> parentOrgVo = orgApi.getOneById(orgVo.getData().getParentId());
            if (!parentOrgVo.isSuccess()) {
                return CommonResponse.success("列表查询失败, 查询组织信息失败！");
            }
            if (null != parentOrgVo.getData()) {
                res.setParentOrgSourceId(parentOrgVo.getData().getSourceId());
            }
        }

        return CommonResponse.success("查询详情数据成功！", res);
    }


    /**
     * 查询最近联系人
     *
     * @Param projectId:
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     * @Author songlx
     * @Date 2021-03-24
     **/
    @RequestMapping(value = "/queryLinkDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitApplyVO> queryLinkDetail(Long projectId) {
        LambdaQueryWrapper<ExitApplyEntity> lambda = Wrappers.<ExitApplyEntity>lambdaQuery();
        lambda.eq(ExitApplyEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambda.eq(ExitApplyEntity::getProjectId, projectId);
        lambda.eq(ExitApplyEntity::getEmployeeId, InvocationInfoProxy.getEmployeeId());
        lambda.orderByDesc(ExitApplyEntity::getCreateTime);
        List<ExitApplyEntity> details = service.list(lambda);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(details)) {
            return CommonResponse.success("查询详情数据成功！", BeanMapper.map(details.get(0), ExitApplyVO.class));
        } else {
            return CommonResponse.success("查询详情数据成功！", null);
        }
    }

    /**
     * 关闭/取消申请
     *
     * @Param saveorUpdateVO:
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     * @Author songlx
     * @Date 2021-03-19
     **/
    @RequestMapping(value = "/upateApplyState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitApplyVO> upateApplyState(@RequestBody ExitApplyVO saveorUpdateVO) {
        LambdaUpdateWrapper<ExitApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ExitApplyEntity::getId, saveorUpdateVO.getId());
        updateWrapper.set(ExitApplyEntity::getApplyState, saveorUpdateVO.getApplyState() == 1 ? 0 : 1);
        service.update(updateWrapper);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitApplyVO> saveOrUpdate(@RequestBody ExitApplyVO saveorUpdateVO) {
        CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(billCodeRule, InvocationInfoProxy.getTenantid());
        if (null == saveorUpdateVO.getId() && codeBatchByRuleCode.isSuccess()) {
            saveorUpdateVO.setBillCode(codeBatchByRuleCode.getData());
            saveorUpdateVO.setConfirmFlag(0);
            saveorUpdateVO.setApplyState(0);
        }
        StringBuffer materialName = new StringBuffer();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saveorUpdateVO.getExitApplyDetail())) {
            saveorUpdateVO.getExitApplyDetail().forEach(vo -> {
                materialName.append(vo.getMaterialName() + ",");
            });
            String materialNames = materialName.substring(0, materialName.length() - 1);
            saveorUpdateVO.setMaterialName(materialNames);
        }
        ExitApplyEntity entity = BeanMapper.map(saveorUpdateVO, ExitApplyEntity.class);
        service.saveOrUpdate(entity, false);
        ExitApplyVO vo = BeanMapper.map(entity, ExitApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitApplyVO> queryDetail(Long id) {
        ExitApplyEntity entity = service.selectById(id);
        ExitApplyVO vo = BeanMapper.map(entity, ExitApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExitApplyVO> vos) {
        service.removeByIds(vos.stream().map(ExitApplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExitApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例
         * 模糊搜索：单据编号、项目名称、合同名称、出资单位、编制人
         * 高级筛选：退场日期（时间区间）；单据状态（标准筛选）；*/
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "contractName", "supplierName", "employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if (!mobile) {
            /*List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }*/
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        IPage<ExitApplyEntity> page = service.queryPage(param, false);
        IPage<ExitApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitApplyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * 导出
     *
     * @Param param: 参数
     * @Param response: 文件流
     * @Return void
     * @Author songlx
     * @Date 2021-03-20
     **/
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /*Long orgId = InvocationInfoProxy.getOrgId();
        List<Long> commonOrgIds = new ArrayList<>();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }*/
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        service.excelExport(param, response);
    }


    /**
     * 新增,参照材料库,查询并补录材料库在场和退场数据信息
     *
     * @Param exitApplyVO: 合同id 表体材料库信息
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.wzxt.vo.ExitApplyVO>
     * @Author songlx
     * @Date 2021-03-22
     **/
    @RequestMapping(value = "/queryForAddDeatil", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ExitApplyDetailVO>> queryForAddDeatil(@RequestBody ExitApplyVO exitApplyVO) {
        String contractId = exitApplyVO.getContractId();
        List<ExitApplyDetailVO> exitApplyDetail = exitApplyVO.getExitApplyDetail();
        if (StringUtils.isNotEmpty(contractId) && !CollectionUtils.isEmpty(exitApplyDetail)) {
            //List<Long> materialIds = exitApplyDetail.stream().map(ExitApplyDetailVO::getMaterialId).collect(Collectors.toList());
            List<ExitApplyDetailVO> exitApplyDetailVOList = service.queryForAddDeatil(contractId, null, InvocationInfoProxy.getTenantid());
            Map<Long, ExitApplyDetailVO> detailVOMap = null;
            if (!CollectionUtils.isEmpty(exitApplyDetailVOList)) {
                detailVOMap = exitApplyDetailVOList.stream().collect(Collectors.toMap(ExitApplyDetailVO::getMaterialId, exitApplyDetailVO -> exitApplyDetailVO));
            }
            for (ExitApplyDetailVO item : exitApplyDetail) {
                Long materialId = item.getMaterialId();
                if (null != detailVOMap && detailVOMap.get(materialId) != null) {
                    ExitApplyDetailVO vo = detailVOMap.get(materialId);
                    item.setExitedNum(vo.getExitedNum());
                    item.setOnRentNum(vo.getOnRentNum());
                } else {
                    item.setExitedNum(item.getExitedNum() == null ? BigDecimal.ZERO : item.getExitedNum());
                    item.setOnRentNum(item.getOnRentNum() == null ? BigDecimal.ZERO : item.getOnRentNum());
                }
            }

        }
        return CommonResponse.success("查询成功！", exitApplyDetail);
    }
}