package com.ejianc.business.wzxt.service.impl;

import com.ejianc.business.storecloud.api.IWarehouseFlowApi;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.enums.InOutFlagEnum;
import com.ejianc.business.wzxt.enums.InOutTypeEnum;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.vo.CheckDetailVO;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service("check")
public class CheckBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ICheckService checkService;

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IWarehouseFlowApi iWarehouseFlowApi;

	@Autowired
	private IOrgApi orgApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		CheckEntity entity = checkService.selectById(billId);
		// 暂存态改为保存态
		if(entity.getSaveState() == 0){
			entity.setSaveState(1);
			checkService.saveOrUpdate(entity,false);
			logger.info("单据----"+billId+"----已保存");
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("======================================终审审核前回调====================================== state:"+state);
		if(state == 0 || state == 2){
			CheckEntity checkEntity = checkService.selectById(billId);
			List<CheckDetailEntity> checkDetailEntities = new ArrayList<>();
			for (CheckDetailEntity checkDetailEntity:checkEntity.getDetailList()){
				if (checkDetailEntity.getSurplusFlag()==0){// 非云库房材料不推
					checkDetailEntities.add(checkDetailEntity);
				}
			}
			checkEntity.setDetailList(checkDetailEntities);
			List<WarehouseFlowVO> warehouseFlowVOList= new ArrayList<>();
			CommonResponse<String> flag = null;
			if (CollectionUtils.isNotEmpty(checkEntity.getDetailList())){
				for (CheckDetailEntity checkDetailEntity : checkEntity.getDetailList()){
					WarehouseFlowVO warehouseFlowVO = new WarehouseFlowVO();
					warehouseFlowVO.setInOutFlag(InOutFlagEnum.入库.getCode());// 入库
					warehouseFlowVO.setInOutType(InOutTypeEnum.验收入库_河南.getCode());// 验收入库（河南）
					warehouseFlowVO.setBillCode(checkEntity.getBillCode());
					warehouseFlowVO.setBillDate(checkEntity.getCreateTime());
					warehouseFlowVO.setProjectId(checkEntity.getProjectId());
					warehouseFlowVO.setProjectName(checkEntity.getProjectName());
					warehouseFlowVO.setParentOrgId(checkEntity.getParentOrgId());
					CommonResponse<OrgVO> orgVO = orgApi.getOneById(checkEntity.getParentOrgId());
					warehouseFlowVO.setParentOrgCode(orgVO.getData().getCode());
					warehouseFlowVO.setParentOrgName(orgVO.getData().getName());
					warehouseFlowVO.setOrgId(checkEntity.getOrgId());
					warehouseFlowVO.setOrgName(checkEntity.getOrgName());
					warehouseFlowVO.setStoreId(checkEntity.getWarehouseId());
					warehouseFlowVO.setStoreName(checkEntity.getWarehouseName());
					warehouseFlowVO.setEmployeeId(checkEntity.getEmployeeId());
					warehouseFlowVO.setEmployeeName(checkEntity.getEmployeeName());
					warehouseFlowVO.setInOutTypeName("验收入库（河南）");
					warehouseFlowVO.setMaterialCategoryId(checkDetailEntity.getMaterialTypeId());
					warehouseFlowVO.setMaterialCategoryName(checkDetailEntity.getMaterialTypeName());
					warehouseFlowVO.setSourceBillDate(checkDetailEntity.getCreateTime());
					warehouseFlowVO.setSourceBillTypeCode("BT210816000000002");
					warehouseFlowVO.setSourceBillTypeName("物资验收");
					warehouseFlowVO.setSourceId(checkEntity.getId());
					warehouseFlowVO.setSourceDetailId(checkDetailEntity.getId());
					warehouseFlowVO.setSourceBillCode(checkEntity.getBillCode());
					warehouseFlowVO.setMaterialId(checkDetailEntity.getMaterialId());
					warehouseFlowVO.setMaterialName(checkDetailEntity.getMaterialName());
					warehouseFlowVO.setMaterialCode(checkDetailEntity.getMaterialCode());
					warehouseFlowVO.setMaterialTypeName(checkDetailEntity.getMaterialTypeName());
					warehouseFlowVO.setMaterialSpec(checkDetailEntity.getSpec());
					warehouseFlowVO.setMaterialUnitName(checkDetailEntity.getUnit());
					warehouseFlowVO.setNum(checkDetailEntity.getInstoreNum());
					BigDecimal taxMny = ComputeUtil.safeMultiply(checkDetailEntity.getInstoreNum(),checkDetailEntity.getNtaxprice());
					BigDecimal mny = ComputeUtil.safeMultiply(checkDetailEntity.getInstoreNum(), checkDetailEntity.getNprice());
					warehouseFlowVO.setTaxMny(taxMny);
					warehouseFlowVO.setMny(mny);
					warehouseFlowVO.setTaxPrice(checkDetailEntity.getNtaxprice());
					warehouseFlowVO.setPrice(checkDetailEntity.getNprice());
					warehouseFlowVO.setTax(checkDetailEntity.getTax());
					warehouseFlowVO.setTaxRate(checkDetailEntity.getTaxrate());
					warehouseFlowVOList.add(warehouseFlowVO);
					logger.info("======打印金额===== "+"warehouseFlowVO.getTaxMny():"+warehouseFlowVO.getTaxMny()+"///"+"warehouseFlowVO.getMny():"+warehouseFlowVO.getMny()+"///"+"warehouseFlowVO.getTaxPrice():"+warehouseFlowVO.getTaxPrice()+"///"
							+"warehouseFlowVO.getPrice():"+warehouseFlowVO.getPrice()+"///"+"warehouseFlowVO.getTax():"+warehouseFlowVO.getTax()+"///"+"warehouseFlowVO.getTaxRate():"+warehouseFlowVO.getTaxRate()+"///");
				}
				WarehouseManageVO manageVO = new WarehouseManageVO();
				manageVO.setProjectId(checkEntity.getProjectId());
				manageVO.setStoreId(checkEntity.getWarehouseId());
				manageVO.setInOutFlag(InOutFlagEnum.入库.getCode());// 入库
				manageVO.setType(2);//1-移动端物资验收保存（只更新数量） 2-PC端物资验收提交（只更新金额）
				manageVO.setFlowVOList(warehouseFlowVOList);
				if (CollectionUtils.isNotEmpty(manageVO.getFlowVOList())){
					flag = iWarehouseFlowApi.push(manageVO);
				}
				logger.info("======================================终审推送完成====================================== flag:"+flag);
				return flag;
			}
		}
			return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CheckEntity entity = checkService.selectById(billId);
		// 已推送NC不允许弃审
		if(entity.getUseState() == 1) {
			logger.info("单据----"+billId+"----已推送NC");
			return CommonResponse.error("该单据已推送NC，不允许弃审！");
		}else if(null != entity.getMroState() && entity.getMroState() == 1){
			logger.info("单据----"+billId+"----已推送MRO");
			return CommonResponse.error("该单据已推送MRO，不允许弃审！");
		}
		//是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.success();
		}else{
			return CommonResponse.error(res.getMsg());
		}
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		CheckEntity checkEntity = checkService.selectById(billId);
		CheckVO checkVO = BeanMapper.map(checkEntity, CheckVO.class);
		// 删除回写云库房流水
		WarehouseManageVO manageVO = new WarehouseManageVO();
		manageVO.setProjectId(checkVO.getProjectId());
		manageVO.setStoreId(checkVO.getWarehouseId());
		manageVO.setInOutFlag(InOutFlagEnum.入库.getCode());
		manageVO.setType(2);
		List<Long> detailIds = new ArrayList<>();
		for (CheckDetailEntity checkDetailEntity : checkEntity.getDetailList()){
			detailIds.add(checkDetailEntity.getId());
		}
		manageVO.setDelDetailIdList(detailIds);
		iWarehouseFlowApi.rollBack(manageVO);
		return CommonResponse.success();
	}

}
