package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.CountDetailEntity;
import com.ejianc.business.wzxt.mapper.CountDetailMapper;
import com.ejianc.business.wzxt.service.ICountDetailService;
import com.ejianc.business.wzxt.vo.CountDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 智能点数实体明细表
 * 
 * @author generator
 * 
 */
@Service("countDetailService")
public class CountDetailServiceImpl extends BaseServiceImpl<CountDetailMapper, CountDetailEntity> implements ICountDetailService{

    @Override
    public CommonResponse<CountDetailVO> getdetailByOrgId(Long projectDepartmentId, Long materialId) {
        //查询此项目是否开启智能称重
        LambdaQueryWrapper<CountDetailEntity> queryWrapper = Wrappers.<CountDetailEntity>lambdaQuery();
        queryWrapper.eq(CountDetailEntity::getOrgId, projectDepartmentId);
        queryWrapper.eq(CountDetailEntity::getMaterialId, materialId);
        CountDetailEntity countDetailEntity = super.getOne(queryWrapper);
        if (countDetailEntity != null) {
            CountDetailVO vo = BeanMapper.map(countDetailEntity, CountDetailVO.class);
            return CommonResponse.success("查询详情数据成功！",vo);
        }else {
            return CommonResponse.success("查询详情数据成功！",null);
        }
    }

    @Override
    public CommonResponse<CountDetailVO> isSmartCount(Long materialId) {
        //查询此物料是否开启智能点数
        LambdaQueryWrapper<CountDetailEntity> queryWrapper = Wrappers.<CountDetailEntity>lambdaQuery();
//        queryWrapper.eq(CountDetailEntity::getOrgId, projectDepartmentId);
        queryWrapper.eq(CountDetailEntity::getMaterialId, materialId);
        CountDetailEntity countDetailEntity = super.getOne(queryWrapper);
        if (countDetailEntity != null) {
            CountDetailVO vo = BeanMapper.map(countDetailEntity, CountDetailVO.class);
            return CommonResponse.success("查询详情数据成功！",vo);
        }else {
            return CommonResponse.success("查询详情数据成功！",null);
        }
    }
}
