package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.bean.ProjectConfigureEntity;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.service.IProjectConfigureService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanDetailVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanMaterialVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroPlanVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("plan")
public class PlanBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${mro.addr}")
	private String addr;

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IPlanService planService;

	@Autowired
	private IProjectConfigureService projectConfigureService;

	@Autowired
	private ThirdSystemUtils thirdSystemUtils;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PlanEntity planEntity = planService.selectById(billId);
		if(MaterialTypeEnum.MRO.getCode() == planEntity.getMaterialType()){
			LambdaQueryWrapper<ProjectConfigureEntity> queryWrapper = new LambdaQueryWrapper<>();
			queryWrapper.eq(ProjectConfigureEntity::getProjectId, planEntity.getProjectId());
			ProjectConfigureEntity configureEntity = projectConfigureService.getOne(queryWrapper, false);
			if (null == configureEntity) {
				throw new BusinessException("该项目未关联MRO项目");
			}else{
				SyncMroPlanVO syncMroPlanVO = changePlanToMro(planEntity, configureEntity);
				Map<String, String> headers = new HashMap<>();
				thirdSystemUtils.getMroSign(headers);
				String mroUrl = addr + "/iec/v1/purchase_plan/save";
				try {
					String responseStr = HttpTookit.postByJson(mroUrl, JSONObject.toJSON(syncMroPlanVO).toString(), headers);
					JSONObject json = JSONObject.parseObject(responseStr);
					if(200 == json.getInteger("code") && true == json.getBoolean("success")){
						logger.info("推送MRO成功" + json.toJSONString());
						String mroId = json.getString("data");
						planEntity.setHistoryId(mroId);
						planEntity.setHistorySystem("MRO");
						planService.saveOrUpdate(planEntity);
					}else{
						logger.info(json.toJSONString());
						throw new BusinessException("推送MRO失败，" + json.get("message"));
					}
				} catch (Exception e) {
					logger.info("异常"+ e.getMessage());
					throw new BusinessException(e.getMessage());
				}
			}
		}
		return CommonResponse.success();
	}

	private SyncMroPlanVO changePlanToMro(PlanEntity planEntity, ProjectConfigureEntity configureEntity){
		SyncMroPlanVO syncMroPlanVO = new SyncMroPlanVO();
		syncMroPlanVO.setCode(planEntity.getBillCode());
		syncMroPlanVO.setProjectId(Long.valueOf(configureEntity.getMroProjectSourceId()));
		syncMroPlanVO.setStatus("ON");//string 需用计划状态 ON-开启，OFF-关闭，DELETED-删除
		syncMroPlanVO.setThirdId(planEntity.getId().toString());
		syncMroPlanVO.setDescription(planEntity.getMemo());
		if(CollectionUtils.isNotEmpty(planEntity.getPlanDetail())){
			List<SyncMroPlanDetailVO> syncMroPlanDetailVOS = new ArrayList<>();
			planEntity.getPlanDetail().forEach(detail -> {
				SyncMroPlanMaterialVO syncMaterialVO = new SyncMroPlanMaterialVO();
				syncMaterialVO.setCode(detail.getMaterialCode());
				syncMaterialVO.setName(detail.getMaterialName());
				syncMaterialVO.setSpecification(detail.getSpec());
				syncMaterialVO.setUnit(detail.getUnit());
				syncMaterialVO.setThirdId(detail.getMaterialId().toString());

				SyncMroPlanDetailVO syncDetailVO = new SyncMroPlanDetailVO();
				syncDetailVO.setTotalCount(detail.getNums());
				syncDetailVO.setDescription(detail.getMemo());
				syncDetailVO.setThirdId(detail.getId().toString());
				syncDetailVO.setMaterial(syncMaterialVO);

				syncMroPlanDetailVOS.add(syncDetailVO);
			});
			syncMroPlanVO.setDetails(syncMroPlanDetailVOS);
		}
		return  syncMroPlanVO;
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//合同是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.success();
		}else{
			return CommonResponse.error(res.getMsg());
		}
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PlanEntity planEntity = planService.selectById(billId);
		if(MaterialTypeEnum.MRO.getCode() == planEntity.getMaterialType()){
			Map<String, String> headers = new HashMap<>();

			thirdSystemUtils.getMroSign(headers);

			if(StringUtils.isBlank(planEntity.getHistoryId())){
				throw new BusinessException("该计划MRO主键为空");
			}
			String mroUrl = addr + "/iec/v1/purchase_plan/update/status";
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("id", planEntity.getHistoryId());
			jsonObject.put("originStatus", "0".equals(planEntity.getPlanFlag()) ? "OFF" : "ON");
			jsonObject.put("targetStatus", "DELETED");
			try {
				String responseStr = HttpTookit.postByJson(mroUrl, jsonObject.toJSONString(), headers);
				logger.info("afterAbstainingProcessor " + responseStr);
				JSONObject json = JSONObject.parseObject(responseStr);
				if(200 == json.getInteger("code") && true == json.getBoolean("success")){
					logger.info("删除MRO计划成功");
				}else{
					throw new BusinessException(json.getString("message"));
				}
			} catch (Exception e) {
				throw new BusinessException(e.getMessage());
			}
		}
		return CommonResponse.success();
	}

}
