package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.wzxt.bean.*;
import com.ejianc.business.wzxt.mapper.WeighReportMapper;
import com.ejianc.business.wzxt.service.*;
import com.ejianc.business.wzxt.vo.WeighDetailVO;
import com.ejianc.business.wzxt.vo.WeighInfoVO;
import com.ejianc.business.wzxt.vo.WeighReportSaveVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 智能称重台账实体
 *
 * @author generator
 *
 */
@Service("weighReportService")
public class WeighReportServiceImpl extends BaseServiceImpl<WeighReportMapper, WeighReportEntity> implements IWeighReportService{

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IDeliveryService deliveryService;

    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private ICheckService checkService;

    @Autowired
    private IWeighService weighService;

    @Override
    public CommonResponse<Boolean> push(WeighReportSaveVO weighReportVO) {
        logger.debug(JSONObject.toJSONString(weighReportVO));
        if(StringUtils.isNotEmpty(weighReportVO.getOldpk())){
            QueryWrapper<WeighReportEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("pk_weigh_bill", weighReportVO.getOldpk());
            super.remove(wrapper, false);
        }

        WeighReportEntity weighReport = new WeighReportEntity();
        BeanUtils.copyProperties(weighReportVO, weighReport);
        QueryWrapper<DeliveryEntity> deliveryWrapper = new QueryWrapper<>();
        deliveryWrapper.eq("history_id", weighReportVO.getPkSrcDelivery());
        DeliveryEntity delivery = deliveryService.getOne(deliveryWrapper);
        weighReport.setPkDelivery(delivery.getId());
        weighReport.setDeliveryCode(delivery.getBillCode());
        QueryWrapper<DeliveryDetailEntity> deliveryInfoWrapper = new QueryWrapper<>();
        deliveryInfoWrapper.eq("history_id", weighReportVO.getPkSrcDeliveryB());
        DeliveryDetailEntity deliveryInfo = deliveryDetailService.getOne(deliveryInfoWrapper);
        weighReport.setPkDeliveryB(deliveryInfo.getId());
        if(isFirstDeliveryInfo(deliveryInfo.getId())){
            weighReport.setDeliveryNum(deliveryInfo.getDeliverNumsSum());
        }

        OrderEntity purchase = orderService.selectById(delivery.getOrderId());
        weighReport.setProjOrgId(purchase.getOrgId());
        weighReport.setConsigneeUnit(purchase.getProjectName());
        weighReport.setPlanBody(purchase.getConstruction());
        weighReport.setOrderCode(purchase.getBillCode());
        weighReport.setPkProject(purchase.getProjectId());
        weighReport.setConsigneeUnit(purchase.getProjectName());
        weighReport.setPkSupplier(purchase.getSupplierId());
        weighReport.setForwardingUnit(purchase.getSupplierName());
        weighReport.setPkContractPurchase(purchase.getContractId());
        weighReport.setContractPurchaseName(purchase.getContractName());
        weighReport.setContractPurchaseCode(purchase.getContractCode());
        OrderDetailEntity purchaseInfo = orderDetailService.selectById(deliveryInfo.getOrderDetailId());
        weighReport.setPkPurchaseB(purchaseInfo.getId());
        weighReport.setPkMaterial(purchaseInfo.getMaterialId());
        weighReport.setPkMatclass(purchaseInfo.getMaterialTypeId());
        weighReport.setMatclassName(purchaseInfo.getMaterialTypeName());
        weighReport.setMaterialName(purchaseInfo.getMaterialName());
        weighReport.setMaterialSpec(purchaseInfo.getSpec());
        weighReport.setMaterialCode(purchaseInfo.getMaterialCode());
        weighReport.setParentOrgId(purchase.getParentOrgId());
        if(isFirstOrderInfo(purchaseInfo.getId())){
            weighReport.setOrderNum(purchaseInfo.getReceiveNumsSum());
        }

        if(null != weighReport.getPkCheck()){
            CheckEntity check = checkService.selectById(weighReport.getPkCheck());
            weighReport.setCheckCode(check.getBillCode());
        }

        convertUnit(weighReport);

        dealMaterialInfo(weighReport, purchase.getParentOrgId());

        return CommonResponse.success(super.save(weighReport));
    }

    private boolean isFirstDeliveryInfo(Long pkDeliveryB){
        QueryWrapper<WeighReportEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("pk_delivery_b", pkDeliveryB);
        List<WeighReportEntity> list = super.list(wrapper);
        return CollectionUtils.isEmpty(list);
    }

    private boolean isFirstOrderInfo(Long pkOrderB){
        QueryWrapper<WeighReportEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("pk_purchase_b", pkOrderB);
        List<WeighReportEntity> list = super.list(wrapper);
        return CollectionUtils.isEmpty(list);
    }

    /**
     * 处理单位，统一转为kg
     * @param weighReport
     */
    private void convertUnit(WeighReportEntity weighReport){
        String weightUnit = weighReport.getWeightUnit();
        if("千克".equals(weightUnit) || "公斤".equals(weightUnit)
                || "KG".equals(weightUnit) || "Kg".equals(weightUnit) || "kg".equals(weightUnit)){
            weighReport.setWeightUnit("千克");
        }else if("吨".equals(weightUnit) || "T".equals(weightUnit) || "t".equals(weightUnit)){
            weighReport.setWeightUnit("千克");
            weighReport.setNetWeight(weighReport.getNetWeight() == null ? BigDecimal.ZERO : weighReport.getNetWeight().multiply(new BigDecimal(1000)));
            weighReport.setGrossWeight(weighReport.getGrossWeight() == null ? BigDecimal.ZERO : weighReport.getGrossWeight().multiply(new BigDecimal(1000)));
            weighReport.setTareWeight(weighReport.getTareWeight() == null ? BigDecimal.ZERO : weighReport.getTareWeight().multiply(new BigDecimal(1000)));
        }else{
            weighReport.setWeightUnit("千克");
        }
    }

    private void dealMaterialInfo(WeighReportEntity weighReport, Long parentOrgId){
        WeighInfoVO weighInfoVO = new WeighInfoVO();
        weighInfoVO.setOrgId(parentOrgId);
        weighInfoVO.setProjectDepartmentId(weighReport.getProjOrgId());
        List<Long> list = new ArrayList<>();
        list.add(weighReport.getPkMaterial());
        weighInfoVO.setMaterialIds(list);

        List<WeighDetailVO> weighDetailVOS = weighService.getMaterialByOrgId(weighInfoVO);
        BigDecimal rate = new BigDecimal(2400);
        if(CollectionUtils.isNotEmpty(weighDetailVOS) && null != weighDetailVOS.get(0).getTransformRate()){
            rate = weighDetailVOS.get(0).getTransformRate();
        }
        weighReport.setUnitRatio(rate);
        weighReport.setResultNum(weighReport.getNetWeight().divide(rate,2, BigDecimal.ROUND_HALF_UP));
    }
}
