package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.WeighDetailEntity;
import com.ejianc.business.wzxt.service.IWeighDetailService;
import com.ejianc.business.wzxt.vo.WeighDetailVO;
import com.ejianc.business.wzxt.vo.WeighInfoVO;
import com.ejianc.business.wzxt.vo.WeighVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.WeighMapper;
import com.ejianc.business.wzxt.bean.WeighEntity;
import com.ejianc.business.wzxt.service.IWeighService;

import java.util.ArrayList;
import java.util.List;

/**
 * 智能称重实体
 *
 * @author generator
 *
 */
@Service("weighService")
public class WeighServiceImpl extends BaseServiceImpl<WeighMapper, WeighEntity> implements IWeighService{

    @Autowired
    private IWeighDetailService weighDetailService;

    @Override
    public CommonResponse<WeighVO> getWeighByProjectDepartmentId(Long projectDepartmentId) {
        //查询此项目是否开启智能称重
        LambdaQueryWrapper<WeighEntity> queryWrapperWeigh = Wrappers.<WeighEntity>lambdaQuery();
        queryWrapperWeigh.eq(WeighEntity::getOrgId, projectDepartmentId);
        WeighEntity weigh = super.getOne(queryWrapperWeigh);
        if (weigh != null) {
            WeighVO vo = BeanMapper.map(weigh, WeighVO.class);
            return CommonResponse.success("查询详情数据成功！",vo);
        }else {
            return CommonResponse.success("查询详情数据成功！",null);
        }
    }

    @Override
    public List<WeighDetailVO> getMaterialByOrgId(WeighInfoVO weighInfoVO) {
        //物资主键
        List<Long> materialIds = weighInfoVO.getMaterialIds();
        List<Long> materialIdProjectOpen = new ArrayList<Long>();
        List<Long> materialIdOrgOpen = new ArrayList<Long>();
        List<WeighDetailVO> weighDetailVOList = new ArrayList<WeighDetailVO>();

        //查询此项目是否开启智能称重
        LambdaQueryWrapper<WeighEntity> queryWrapperWeigh = Wrappers.<WeighEntity>lambdaQuery();
        queryWrapperWeigh.eq(WeighEntity::getOrgId, weighInfoVO.getProjectDepartmentId());
        queryWrapperWeigh.eq(WeighEntity::getWeighFlag, "1");
        WeighEntity weigh = super.getOne(queryWrapperWeigh);
        //是否开启智能称重(1:是，0：否)
        if (weigh != null){
            //查询项目目设置的智能称重物资
            LambdaQueryWrapper<WeighDetailEntity> queryWrapperWeighDetail = Wrappers.<WeighDetailEntity>lambdaQuery();
            queryWrapperWeighDetail.eq(WeighDetailEntity::getOrgId, weighInfoVO.getProjectDepartmentId());
//            queryWrapperWeighDetail.eq(WeighDetailEntity::getWeighFlag, "1");
            List<WeighDetailEntity> weighDetailEntityList = weighDetailService.list(queryWrapperWeighDetail);
            if (weighDetailEntityList != null && weighDetailEntityList.size() > 0){
                //匹配物资
                for (Long materialId : materialIds){
                    for (WeighDetailEntity weighDetailEntity : weighDetailEntityList){
                        if (weighDetailEntity.getMaterialId().equals(materialId)){
                            WeighDetailVO weighDetailVO = new WeighDetailVO();
                            weighDetailVO.setWeighFlag(weighDetailEntity.getWeighFlag());
                            weighDetailVO.setTransformRate(weighDetailEntity.getTransformRate());
                            weighDetailVO.setMaterialId(weighDetailEntity.getMaterialId());
                            weighDetailVOList.add(weighDetailVO);
                            materialIdProjectOpen.add(materialId);
                        }
                    }
                }
            }
            //删除已查到项目开启智能称重的物料主键
            materialIds.removeAll(materialIdProjectOpen);
        }
        //查询组织级的物料智能称重设置
        LambdaQueryWrapper<WeighDetailEntity> queryWrapperWeighDetailOrg = Wrappers.<WeighDetailEntity>lambdaQuery();
        queryWrapperWeighDetailOrg.eq(WeighDetailEntity::getOrgId, weighInfoVO.getOrgId());
//          queryWrapperWeighDetailOrg.eq(WeighDetailEntity::getWeighFlag, "1");
        List<WeighDetailEntity> weighDetailEntityOrgList = weighDetailService.list(queryWrapperWeighDetailOrg);
        if (weighDetailEntityOrgList != null && weighDetailEntityOrgList .size() > 0){
            //匹配物资
            for (Long materialId : materialIds){
                for (WeighDetailEntity weighDetailEntity : weighDetailEntityOrgList){
                    if (weighDetailEntity.getMaterialId().equals(materialId)){
                        WeighDetailVO weighDetailVO = new WeighDetailVO();
                        weighDetailVO.setWeighFlag(weighDetailEntity.getWeighFlag());
                        weighDetailVO.setTransformRate(weighDetailEntity.getTransformRate());
                        weighDetailVO.setMaterialId(weighDetailEntity.getMaterialId());
                        weighDetailVOList.add(weighDetailVO);
                        materialIdOrgOpen.add(materialId);
                    }
                }
            }
        }
        //删除已查到项目开启智能称重的物料主键
        materialIds.removeAll(materialIdOrgOpen);
        if (materialIds != null && materialIds.size() > 0){
            for (Long materialId : materialIds) {
                WeighDetailVO weighDetailVO = new WeighDetailVO();
                weighDetailVO.setWeighFlag("0");
                weighDetailVO.setMaterialId(materialId);
                weighDetailVOList.add(weighDetailVO);
            }
        }
        return weighDetailVOList;
    }
}
