/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.api.IPriceFlowApi;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.FlowTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.vo.PriceFlowApiVO;
import com.ejianc.business.rmat.vo.PriceFlowVO;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceFlowService")
public class PriceFlowServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements IPriceFlowService {
    @Autowired
    private IPriceFlowApi flowApi;

    @Override
    public Boolean insertCheckFlow(CheckEntity entity, String billTypeCode) {
        ArrayList<PriceFlowVO> flowList = new ArrayList<PriceFlowVO>();
        List<CheckDetailEntity> detailList = entity.getDetailList();
        for (CheckDetailEntity detail : detailList) {
            PriceFlowVO vo = new PriceFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractName(entity.getContractName());
            vo.setBillDate(entity.getCheckDate());
            vo.setEffectiveDate(new Date());
            vo.setFlowType(String.valueOf(FlowTypeEnum.\u9a8c\u6536.getFlowType()));
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));
            vo.setDetailDate(detail.getRentDate());
            vo.setInfoId(detail.getNcDetailId());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setPrice(detail.getNprice());
            vo.setTaxPrice(detail.getNtaxprice());
            vo.setTaxRate(detail.getTaxrate());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        PriceFlowApiVO vo = new PriceFlowApiVO();
        vo.setFlowList(flowList);
        CommonResponse resp = this.flowApi.insertFlow(vo);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (Boolean)resp.getData();
    }

    @Override
    public Boolean delCheckFlow(List<CheckVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        PriceFlowApiVO vo = new PriceFlowApiVO();
        vo.setSourceIds(ids);
        vo.setBillTypeCode(BillTypeEnum.\u9a8c\u6536\u5355.getCode());
        CommonResponse resp = this.flowApi.insertFlow(vo);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        if (!((Boolean)resp.getData()).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u5220\u9664\u6d41\u6c34\u5931\u8d25\uff01");
        }
        return true;
    }
}

