/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.api.IRmatFlowApi;
import com.ejianc.business.rmat.api.ITransfFlowApi;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.FlowTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.RmatFlowApiVO;
import com.ejianc.business.rmat.vo.RmatFlowVO;
import com.ejianc.business.rmat.vo.TransferFlowVO;
import com.ejianc.business.wzxt.bean.CheckAllotEntity;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rmatFlowService")
public class RmatFlowServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements IRmatFlowService {
    @Autowired
    private IRmatFlowApi flowApi;
    @Autowired
    private ITransfFlowApi transfFlowApi;

    @Override
    public Boolean insertCheckFlow(CheckEntity entity, String billTypeCode, Integer effectiveState) {
        ArrayList<RmatFlowVO> flowList = new ArrayList<RmatFlowVO>();
        List<CheckDetailEntity> detailList = entity.getDetailList();
        for (CheckDetailEntity detail : detailList) {
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getCheckDate());
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
            vo.setEffectiveState(effectiveState);
            vo.setFlowType(String.valueOf(FlowTypeEnum.\u9a8c\u6536.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));
            vo.setDetailDate(detail.getRentDate());
            vo.setInfoId(detail.getNcDetailId());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setUnitId(detail.getUnitId());
            vo.setNum(detail.getCheckNumsSum());
            vo.setRealUnitId(detail.getRealUnitId());
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());
            vo.setRealTransScale(detail.getRealTransScale());
            vo.setRentUnitId(detail.getRentUnitId());
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());
            vo.setRentTransScale(detail.getRentTransScale());
            vo.setSignRowType(detail.getSignRowType());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        RmatFlowApiVO vo = new RmatFlowApiVO();
        vo.setFlowList(flowList);
        CommonResponse resp = this.flowApi.insertFlow(vo);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (Boolean)resp.getData();
    }

    @Override
    public Boolean delCheckFlow(List<CheckVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        RmatFlowApiVO vo = new RmatFlowApiVO();
        vo.setSourceIds(ids);
        vo.setBillTypeCode(BillTypeEnum.\u9a8c\u6536\u5355.getCode());
        CommonResponse resp = this.flowApi.insertFlow(vo);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        if (!((Boolean)resp.getData()).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u5220\u9664\u6d41\u6c34\u5931\u8d25\uff01");
        }
        return true;
    }

    @Override
    public Boolean insertCheckTransfFlow(CheckEntity entity, String billTypeCode, Integer effectiveState) {
        ArrayList<TransferFlowVO> flowList = new ArrayList<TransferFlowVO>();
        List<CheckDetailEntity> detailList = entity.getDetailList();
        for (CheckDetailEntity detail : detailList) {
            List<CheckAllotEntity> allotList = detail.getAllotList();
            if (!CollectionUtils.isNotEmpty(allotList)) continue;
            for (CheckAllotEntity allot : allotList) {
                TransferFlowVO vo = new TransferFlowVO();
                vo.setCreateTime(allot.getCreateTime());
                vo.setCreateUserCode(allot.getCreateUserCode());
                vo.setTenantId(allot.getTenantId());
                vo.setBillTypeCode(billTypeCode);
                vo.setSourceId(entity.getId());
                vo.setSourceDetailId(allot.getId());
                vo.setBillCode(entity.getBillCode());
                vo.setProjectId(entity.getProjectId());
                vo.setProjectName(entity.getProjectName());
                vo.setOrgId(entity.getOrgId());
                vo.setOrgName(entity.getOrgName());
                vo.setContractId(allot.getContractId());
                vo.setContractCode(entity.getContractCode());
                vo.setContractName(entity.getContractName());
                vo.setSupplierId(allot.getSupplierId());
                vo.setEmployeeId(entity.getEmployeeId());
                vo.setEmployeeName(entity.getEmployeeName());
                vo.setBillDate(entity.getCheckDate());
                vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
                vo.setEffectiveState(effectiveState);
                vo.setFlowType(String.valueOf(TransFlowTypeEnum.\u9a8c\u6536.getFlowType()));
                vo.setInOutFlag(RmatCommonConsts.IN);
                vo.setUseStatus(String.valueOf(RmatCommonConsts.NO));
                vo.setMaterialTypeId(detail.getMaterialTypeId());
                vo.setMaterialTypeName(detail.getMaterialTypeName());
                vo.setMaterialId(detail.getMaterialId());
                vo.setMaterialCode(detail.getMaterialCode());
                vo.setMaterialName(detail.getMaterialName());
                vo.setMaterialSourceId(detail.getMaterialSourceId());
                vo.setSpec(detail.getSpec());
                vo.setUseStatus("0");
                vo.setQueryId(vo.getProjectId() + "_" + vo.getSupplierId());
                vo.setUnitId(allot.getUnitId());
                vo.setUnitName(allot.getUnitName());
                vo.setNum(allot.getNum());
                vo.setRealUnitId(allot.getRealUnitId());
                vo.setRealUnitName(allot.getRealUnitName());
                vo.setRealNum(allot.getRealNum());
                vo.setRealTransScale(allot.getRealTransScale());
                vo.setRentUnitId(allot.getRentUnitId());
                vo.setRentUnitName(allot.getRentUnitName());
                vo.setRentNum(allot.getRentNum());
                vo.setRentTransScale(allot.getRentTransScale());
                vo.setAmount(allot.getRealNum());
                vo.setRowState(allot.getRowState());
                flowList.add(vo);
            }
        }
        CommonResponse resp = this.transfFlowApi.insertFlow(flowList);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return true;
    }

    @Override
    public Boolean delCheckTransfFlow(List<CheckVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        CommonResponse resp = this.transfFlowApi.delFlow(ids, TransFlowTypeEnum.\u9a8c\u6536.getFlowType());
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return true;
    }
}

