/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dataexchange.api.ICmContractApi;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContract;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.storecloud.api.ICloudMeterialApi;
import com.ejianc.business.storecloud.api.ICloudProjectApi;
import com.ejianc.business.storecloud.api.IWarehouseFlowApi;
import com.ejianc.business.storecloud.vo.ConfigProjectVO;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.business.wzxt.bean.CheckAllotEntity;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.WeighReportEntity;
import com.ejianc.business.wzxt.enums.InOutFlagEnum;
import com.ejianc.business.wzxt.enums.InOutTypeEnum;
import com.ejianc.business.wzxt.enums.MaterialTypeEnum;
import com.ejianc.business.wzxt.enums.SignTypeEnum;
import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.service.ICheckAllotService;
import com.ejianc.business.wzxt.service.ICheckDetailService;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPurchaseOrderService;
import com.ejianc.business.wzxt.service.IPurchaseOrderServicePortType;
import com.ejianc.business.wzxt.service.IWeighReportService;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.util.ThirdSystemUtils;
import com.ejianc.business.wzxt.vo.CheckAnalysisVO;
import com.ejianc.business.wzxt.vo.CheckDetailVO;
import com.ejianc.business.wzxt.vo.CheckDetailsVO;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.business.wzxt.vo.MaterialInRefVO;
import com.ejianc.business.wzxt.vo.PurchaseOrderBodyVO;
import com.ejianc.business.wzxt.vo.PurchaseOrderHeadVO;
import com.ejianc.business.wzxt.vo.PurchaseOrderVO;
import com.ejianc.business.wzxt.vo.WeighCheckVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroCheckDetailVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private static final String WZXT_CHECK = "CSCEC5BHN_CWZXT_CHECK";
    @Value(value="${smartWeigh.addr}")
    private String SUPPLIER_HTTP;
    @Value(value="${mro.addr}")
    private String addr;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IWarehouseFlowApi iWarehouseFlowApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IWeighReportService weighReportService;
    @Autowired
    private ThirdSystemUtils thirdSystemUtils;
    @Autowired
    private ICmContractApi cmContractApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ICloudMeterialApi cloudMeterialApi;
    @Autowired
    private ICloudProjectApi cloudProjectApi;
    @Autowired
    private ICmContractInfoApi cmContractInfoApi;
    @Autowired
    private ICheckAllotService checkAllotService;
    @Autowired
    private IRmatFlowService rmatFlowService;

    @Override
    public CheckVO saveOrUpdate(CheckVO saveorUpdateVO) {
        saveorUpdateVO.setProjectCloudFlag(Integer.valueOf(null == saveorUpdateVO.getProjectCloudFlag() ? 0 : saveorUpdateVO.getProjectCloudFlag()));
        if (saveorUpdateVO.getId() == null) {
            for (CheckDetailVO checkDetailVO : saveorUpdateVO.getDetailList()) {
                checkDetailVO.setId(null);
            }
        }
        for (CheckDetailVO checkDetailVO : saveorUpdateVO.getDetailList()) {
            if (checkDetailVO.getSurplusFlag() != 1) continue;
            checkDetailVO.setInstoreNum(null);
        }
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CheckEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getParentOrgId() != null) {
            CommonResponse orgParentVo = this.orgApi.getOneById(entity.getParentOrgId());
            if (!orgParentVo.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u8be6\u60c5\u5931\u8d25\uff01");
            }
            entity.setParentOrgSourceId(((OrgVO)orgParentVo.getData()).getSourceId());
            CommonResponse project = this.projectApi.queryProjectBySourceId(entity.getProjectSourceId());
            if (project.isSuccess()) {
                entity.setRealCorpId(((ProjectRegisterVO)project.getData()).getId());
                entity.setRealNcCorp(((ProjectRegisterVO)project.getData()).getSourceId());
                entity.setRealCorpName(((ProjectRegisterVO)project.getData()).getName());
            } else {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u8be6\u60c5\u5931\u8d25\uff01");
            }
        }
        if (entity.getId() == null) {
            entity.setUseState(0);
            entity.setCheckState(1);
            if (entity.getCreateUserId() == null) {
                entity.setCreateUserId(InvocationInfoProxy.getUserid());
                entity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                entity.setCreateUserSourceId(this.getUserSourceId());
            }
        }
        boolean isDetailContainCloud = false;
        List<CheckDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            StringBuffer materialName = new StringBuffer();
            BigDecimal sumMny = null;
            BigDecimal sumTax = null;
            BigDecimal sumTaxMny = null;
            for (CheckDetailEntity detail : detailList) {
                if ("3".equals(entity.getIsPurchase()) && 1 == entity.getSaveState() && (null == detail.getMroCheckNum() || detail.getMroCheckNum().compareTo(detail.getMroDeliverNumsSum()) > 0)) {
                    throw new BusinessException("\u8868\u4f53\u7269\u8d44MRO\u9a8c\u6536\u6570\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8eMRO\u53d1\u8d27\u6570\u91cf");
                }
                detail.setMny(ComputeUtil.safeMultiply((BigDecimal)detail.getCheckNumsSum(), (BigDecimal)detail.getNprice()).setScale(2, 4));
                detail.setTax(ComputeUtil.safeMultiply((BigDecimal)detail.getMny(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)detail.getTaxrate(), (BigDecimal)BigDecimal.valueOf(100L))).setScale(2, 4));
                detail.setTaxmny(ComputeUtil.safeAdd((BigDecimal)detail.getMny(), (BigDecimal)detail.getTax()).setScale(2, 4));
                materialName.append(detail.getMaterialName() + ",");
                sumMny = CheckServiceImpl.safeAdd(sumMny, detail.getMny());
                sumTax = CheckServiceImpl.safeAdd(sumTax, detail.getTax());
                sumTaxMny = CheckServiceImpl.safeAdd(sumTaxMny, detail.getTaxmny());
                if (detail.getNtaxprice() == null) {
                    detail.setNtaxprice(ComputeUtil.safeMultiply((BigDecimal)detail.getNprice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.valueOf(1L), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)detail.getTax(), (BigDecimal)BigDecimal.valueOf(100L)))));
                }
                if (0 != detail.getSurplusFlag()) continue;
                isDetailContainCloud = true;
            }
            if (saveorUpdateVO.getSaveState() == 1 && 1 == saveorUpdateVO.getProjectCloudFlag() && isDetailContainCloud && null == saveorUpdateVO.getWarehouseId()) {
                throw new BusinessException("\u5355\u636e\u5305\u542b\u4e91\u5e93\u5b58\u6750\u6599\uff0c\u4e91\u5e93\u623f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String materialNames = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(materialNames);
            entity.setDef1(sumMny != null ? sumMny.setScale(2, 4).toPlainString() : null);
            entity.setDef2(sumTax != null ? sumTax.setScale(2, 4).toPlainString() : null);
            entity.setDef3(sumTaxMny != null ? sumTaxMny.setScale(2, 4).toPlainString() : null);
        }
        super.saveOrUpdate((Object)entity, false);
        this.saveDealAllot(entity);
        if (saveorUpdateVO.getId() == null && saveorUpdateVO.getSaveState() == 1 || saveorUpdateVO.getId() != null && 1 == ((CheckEntity)((Object)this.selectById(saveorUpdateVO.getId()))).getSaveState() && 1 == saveorUpdateVO.getSaveState()) {
            ArrayList<CheckDetailEntity> checkDetailEntities = new ArrayList<CheckDetailEntity>();
            for (CheckDetailEntity checkDetailEntity : entity.getDetailList()) {
                String fileIds = checkDetailEntity.getFileIds();
                if (StringUtils.isNotBlank((CharSequence)fileIds)) {
                    String[] fileIdArray;
                    ArrayList<AttachmentVO> attachmentVOS = new ArrayList<AttachmentVO>();
                    for (String fileId : fileIdArray = fileIds.split(",")) {
                        AttachmentVO attachmentVO = (AttachmentVO)this.attachmentApi.queryDetail(fileId).getData();
                        attachmentVO.setSourceId(checkDetailEntity.getId());
                        attachmentVOS.add(attachmentVO);
                    }
                    this.attachmentApi.insertBatch(attachmentVOS);
                }
                if (checkDetailEntity.getSurplusFlag() != 0) continue;
                checkDetailEntities.add(checkDetailEntity);
            }
            if (CollectionUtils.isNotEmpty(checkDetailEntities)) {
                entity.setDetailList(checkDetailEntities);
                this.push(entity);
            }
        }
        this.writeBackDelivery(saveorUpdateVO, true);
        this.writeBackOrder(saveorUpdateVO, true);
        this.writeBackPoundTemp(entity.getId(), saveorUpdateVO.getPkWeighBills());
        this.writeBackWeighReportCheck(entity.getId(), entity.getBillCode(), saveorUpdateVO.getPkWeighBills());
        if (saveorUpdateVO.getSaveState() == 1) {
            this.writeBackWeighReport(entity.getId());
            this.rmatFlowService.insertCheckFlow(entity, "BT210816000000002", RmatCommonConsts.NO);
            this.rmatFlowService.insertCheckTransfFlow(entity, "BT210816000000002", RmatCommonConsts.NO);
        }
        return (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
    }

    private void saveDealAllot(CheckEntity entity) {
        for (CheckDetailEntity detailEntity : entity.getDetailList()) {
            List<CheckAllotEntity> allotList = detailEntity.getAllotList();
            if (!CollectionUtils.isNotEmpty(allotList)) continue;
            ArrayList<CheckAllotEntity> insertList = new ArrayList<CheckAllotEntity>();
            ArrayList<Long> delPkList = new ArrayList<Long>();
            for (CheckAllotEntity allotEntity : allotList) {
                if ("del".equals(allotEntity.getRowState())) {
                    delPkList.add(allotEntity.getId());
                    continue;
                }
                allotEntity.setCheckId(entity.getId());
                allotEntity.setCheckDetailId(detailEntity.getId());
                insertList.add(allotEntity);
            }
            if (CollectionUtils.isNotEmpty(insertList)) {
                this.checkAllotService.saveOrUpdateBatch(insertList);
            }
            if (!CollectionUtils.isNotEmpty(delPkList)) continue;
            this.checkAllotService.removeByIds(delPkList);
        }
    }

    public boolean isExcatCarNo(String carNo) {
        if (carNo == null) {
            return false;
        }
        String regex = "([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886A-Z]{1}[A-Z]{1}(([0-9]{5}[DF])|([DF]([A-HJ-NP-Z0-9])[0-9]{4})))|([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886A-Z]{1}[A-Z]{1}[A-HJ-NP-Z0-9]{4}[A-HJ-NP-Z0-9\u6302\u5b66\u8b66\u6e2f\u6fb3]{1})";
        return carNo.matches(regex);
    }

    @Override
    public CommonResponse<String> push(CheckEntity checkEntity) {
        ArrayList<WarehouseFlowVO> warehouseFlowVOList = new ArrayList<WarehouseFlowVO>();
        for (CheckDetailEntity checkDetailEntity : checkEntity.getDetailList()) {
            WarehouseFlowVO warehouseFlowVO = new WarehouseFlowVO();
            warehouseFlowVO.setInOutFlag(InOutFlagEnum.\u5165\u5e93.getCode());
            warehouseFlowVO.setInOutType(InOutTypeEnum.\u9a8c\u6536\u5165\u5e93_\u6cb3\u5357.getCode());
            warehouseFlowVO.setBillCode(checkEntity.getBillCode());
            warehouseFlowVO.setBillDate(checkEntity.getCreateTime());
            warehouseFlowVO.setProjectId(checkEntity.getProjectId());
            warehouseFlowVO.setProjectName(checkEntity.getProjectName());
            warehouseFlowVO.setParentOrgId(checkEntity.getParentOrgId());
            CommonResponse orgVO = this.orgApi.getOneById(checkEntity.getParentOrgId());
            warehouseFlowVO.setParentOrgCode(((OrgVO)orgVO.getData()).getCode());
            warehouseFlowVO.setParentOrgName(((OrgVO)orgVO.getData()).getName());
            warehouseFlowVO.setOrgId(checkEntity.getOrgId());
            warehouseFlowVO.setOrgName(checkEntity.getOrgName());
            warehouseFlowVO.setStoreId(checkEntity.getWarehouseId());
            warehouseFlowVO.setStoreName(checkEntity.getWarehouseName());
            warehouseFlowVO.setEmployeeId(checkEntity.getEmployeeId());
            warehouseFlowVO.setEmployeeName(checkEntity.getEmployeeName());
            warehouseFlowVO.setInOutTypeName("\u9a8c\u6536\u5165\u5e93\uff08\u6cb3\u5357\uff09");
            warehouseFlowVO.setMaterialCategoryId(checkDetailEntity.getMaterialTypeId());
            warehouseFlowVO.setMaterialCategoryName(checkDetailEntity.getMaterialTypeName());
            warehouseFlowVO.setSourceBillDate(checkDetailEntity.getCreateTime());
            warehouseFlowVO.setSourceBillTypeCode("BT210816000000002");
            warehouseFlowVO.setSourceBillTypeName("\u7269\u8d44\u9a8c\u6536");
            warehouseFlowVO.setSourceId(checkEntity.getId());
            warehouseFlowVO.setSourceDetailId(checkDetailEntity.getId());
            warehouseFlowVO.setSourceBillCode(checkEntity.getBillCode());
            warehouseFlowVO.setMaterialId(checkDetailEntity.getMaterialId());
            warehouseFlowVO.setMaterialName(checkDetailEntity.getMaterialName());
            warehouseFlowVO.setMaterialCode(checkDetailEntity.getMaterialCode());
            warehouseFlowVO.setMaterialTypeName(checkDetailEntity.getMaterialTypeName());
            warehouseFlowVO.setMaterialSpec(checkDetailEntity.getSpec());
            warehouseFlowVO.setMaterialUnitName(checkDetailEntity.getUnit());
            warehouseFlowVO.setNum(checkDetailEntity.getInstoreNum());
            warehouseFlowVOList.add(warehouseFlowVO);
        }
        WarehouseManageVO manageVO = new WarehouseManageVO();
        manageVO.setProjectId(checkEntity.getProjectId());
        manageVO.setStoreId(checkEntity.getWarehouseId());
        manageVO.setInOutFlag(InOutFlagEnum.\u5165\u5e93.getCode());
        manageVO.setType(Integer.valueOf(1));
        manageVO.setFlowVOList(warehouseFlowVOList);
        CommonResponse flag = this.iWarehouseFlowApi.push(manageVO);
        return flag;
    }

    @Override
    public CheckVO queryDetail(Long id) {
        CheckEntity entity = (CheckEntity)((Object)this.selectById(id));
        List<CheckDetailEntity> detailList = entity.getDetailList();
        for (CheckDetailEntity detailEntity : detailList) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(CheckAllotEntity::getCheckDetailId, (Object)detailEntity.getId());
            List allotEntities = this.checkAllotService.list((Wrapper)queryWrapper);
            detailEntity.setAllotList(allotEntities);
        }
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return vo;
    }

    @Override
    public List<CheckAnalysisVO> querAnalysisList(Page<CheckAnalysisVO> page, QueryWrapper queryWrapper) {
        return ((CheckMapper)this.baseMapper).querAnalysisList(page, queryWrapper);
    }

    @Override
    public List<CheckDetailsVO> queryDetailsList(Page<CheckDetailsVO> page, QueryWrapper queryWrapper) {
        return ((CheckMapper)this.baseMapper).queryDetailsList(page, queryWrapper);
    }

    @Override
    public CheckVO deliveryToCheck(Long deliveryId) {
        DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.selectById(deliveryId));
        if (MaterialTypeEnum.\u5468\u8f6c\u6750.getCode().equals(delivery.getMaterialType())) {
            return this.rentDeliveryToCheck(delivery);
        }
        return this.deliveryToCheck(delivery);
    }

    private CheckVO rentDeliveryToCheck(DeliveryEntity delivery) {
        CheckVO vo = new CheckVO();
        vo.setProjectId(delivery.getProjectId());
        vo.setProjectSourceId(delivery.getProjectSourceId());
        vo.setProjectName(delivery.getProjectName());
        vo.setOrgId(delivery.getOrgId());
        vo.setOrgName(delivery.getOrgName());
        vo.setContractId(delivery.getContractId());
        vo.setContractName(delivery.getContractName());
        vo.setSupplierId(delivery.getSupplierId());
        vo.setSupplierName(delivery.getSupplierName());
        vo.setSupplierTenantId(delivery.getTenantId());
        vo.setLicensePlate(delivery.getDeliveryCarNumber());
        vo.setMaterialName(delivery.getMaterialName());
        vo.setOrderId(delivery.getOrderId());
        vo.setDeliveryId(delivery.getId());
        vo.setMaterialType(delivery.getMaterialType());
        vo.setOrgSourceId(delivery.getOrgSourceId());
        vo.setParentOrgId(delivery.getParentOrgId());
        vo.setParentOrgSourceId(delivery.getParentOrgSourceId());
        vo.setSupplierSourceId(delivery.getSupplierSourceId());
        vo.setConstruction(delivery.getConstruction());
        vo.setSmartStatus(delivery.getSmartStatus());
        vo.setProjectCloudFlag(Integer.valueOf(1));
        List<DeliveryDetailEntity> deliveryDetailList = delivery.getDeliveryDetail();
        StringBuffer msg = new StringBuffer();
        CommonResponse contractInfoRes = this.cmContractInfoApi.queryLeaseContractInfoById(vo.getContractId());
        if (!contractInfoRes.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)contractInfoRes.getData()))) {
            deliveryDetailList.forEach(dd -> msg.append("[").append(dd.getMaterialName()).append("-").append(dd.getSpec()).append("]"));
            msg.append("\u4e0d\u5728\u5408\u540c\u8303\u56f4\u5185,\u4e0d\u5141\u8bb8\u9a8c\u6536\u3002\u8bf7\u4fee\u6539NC\u5408\u540c\u8303\u56f4\u518d\u8fdb\u884c\u9a8c\u6536\u3002");
            vo.setWarnMsg(String.valueOf(msg));
            return vo;
        }
        List infoVOS = (List)contractInfoRes.getData();
        HashMap<Long, CmContractInfoVO> ncmaterialMap = new HashMap<Long, CmContractInfoVO>();
        HashMap<String, CmContractInfoVO> ncCategoryMap = new HashMap<String, CmContractInfoVO>();
        for (CmContractInfoVO infoVO : infoVOS) {
            if (null != infoVO.getMaterialId()) {
                ncmaterialMap.put(infoVO.getMaterialId(), infoVO);
                continue;
            }
            ncCategoryMap.put(infoVO.getMaterialTypeId() + "@" + infoVO.getPkMngmeasdoc(), infoVO);
        }
        if (CollectionUtils.isNotEmpty(deliveryDetailList)) {
            ArrayList<CheckDetailVO> detailList = new ArrayList<CheckDetailVO>();
            ArrayList<Long> materialIds = new ArrayList<Long>();
            for (DeliveryDetailEntity dd2 : deliveryDetailList) {
                CmContractInfoVO infoVO;
                CheckDetailVO detail = new CheckDetailVO();
                if (ncmaterialMap.containsKey(dd2.getMaterialId())) {
                    infoVO = (CmContractInfoVO)ncmaterialMap.get(dd2.getMaterialId());
                    detail.setSignRowType(SignTypeEnum.\u660e\u7ec6.getCode());
                    this.convertToCheckDetail(detail, infoVO);
                } else if (ncCategoryMap.containsKey(dd2.getMaterialTypeId() + "@" + dd2.getUnitId())) {
                    infoVO = (CmContractInfoVO)ncCategoryMap.get(dd2.getMaterialTypeId() + "@" + dd2.getUnitId());
                    detail.setSignRowType(SignTypeEnum.\u5206\u7c7b.getCode());
                    this.convertToCheckDetail(detail, infoVO);
                } else {
                    msg.append("[").append(dd2.getMaterialName()).append("-").append(dd2.getSpec()).append("]");
                    continue;
                }
                detail.setUnitId(dd2.getUnitId());
                detail.setUnit(dd2.getUnit());
                detail.setRealUnitId(dd2.getRealUnitId());
                detail.setRealUnitName(dd2.getRealUnitName());
                detail.setRealTransScale(dd2.getRealTransScale());
                detail.setRealNum(dd2.getRealNum());
                detail.setDeliveryId(delivery.getId());
                detail.setDeliveryDetailId(dd2.getId());
                detail.setOrderId(dd2.getOrderId());
                detail.setOrderDetailId(dd2.getOrderDetailId());
                detail.setMaterialTypeId(dd2.getMaterialTypeId());
                detail.setMaterialTypeName(dd2.getMaterialTypeName());
                detail.setMaterialId(dd2.getMaterialId());
                detail.setMaterialCode(dd2.getMaterialCode());
                detail.setMaterialName(dd2.getMaterialName());
                detail.setSpec(dd2.getSpec());
                detail.setMaterialManufacturer(dd2.getMaterialManufacturer());
                detail.setDeliverNumsSum(dd2.getDeliverNumsSum());
                detail.setNprice(dd2.getPrice());
                detail.setNtaxprice(dd2.getTaxPrice());
                detail.setTaxrate(dd2.getTaxRate());
                materialIds.add(dd2.getMaterialId());
                detail.setMaterialSourceId(dd2.getMaterialSourceId());
                detail.setSurplusFlag(Integer.valueOf(1));
                detailList.add(detail);
            }
            vo.setDetailList(detailList);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg})) {
            msg.append("\u4e0d\u5728\u5408\u540c\u8303\u56f4\u5185,\u4e0d\u5141\u8bb8\u9a8c\u6536\u3002\u8bf7\u4fee\u6539NC\u5408\u540c\u8303\u56f4\u518d\u8fdb\u884c\u9a8c\u6536\u3002");
            vo.setWarnMsg(String.valueOf(msg));
        }
        return vo;
    }

    private void convertToCheckDetail(CheckDetailVO detail, CmContractInfoVO infoVO) {
        detail.setNcDetailId(infoVO.getPkContractinfo());
        detail.setPkAmountlist(infoVO.getPkAmountlist());
        detail.setHtywnr(infoVO.getAmountname());
        detail.setNtaxprice(BigDecimal.valueOf(infoVO.getTaxhireprice()));
        detail.setTaxrate(infoVO.getSl());
        detail.setNprice(BigDecimal.valueOf(infoVO.getHireprice()));
        detail.setRentUnitId(infoVO.getPkContmeasdoc());
        detail.setRentUnitName(infoVO.getInfounit());
        detail.setRentTransScale(NumberUtils.createBigDecimal((String)infoVO.getMngScale()));
    }

    private CheckVO deliveryToCheck(DeliveryEntity delivery) {
        CommonResponse response;
        CheckVO vo = new CheckVO();
        vo.setProjectId(delivery.getProjectId());
        vo.setProjectSourceId(delivery.getProjectSourceId());
        vo.setProjectName(delivery.getProjectName());
        vo.setOrgId(delivery.getOrgId());
        vo.setOrgName(delivery.getOrgName());
        vo.setContractId(delivery.getContractId());
        vo.setContractName(delivery.getContractName());
        vo.setSupplierId(delivery.getSupplierId());
        vo.setSupplierName(delivery.getSupplierName());
        vo.setSupplierTenantId(delivery.getTenantId());
        vo.setLicensePlate(delivery.getDeliveryCarNumber());
        vo.setMaterialName(delivery.getMaterialName());
        vo.setOrderId(delivery.getOrderId());
        vo.setDeliveryId(delivery.getId());
        vo.setMaterialType(delivery.getMaterialType());
        vo.setOrgSourceId(delivery.getOrgSourceId());
        vo.setParentOrgId(delivery.getParentOrgId());
        vo.setParentOrgSourceId(delivery.getParentOrgSourceId());
        vo.setSupplierSourceId(delivery.getSupplierSourceId());
        vo.setConstruction(delivery.getConstruction());
        vo.setSmartStatus(delivery.getSmartStatus());
        if (MaterialTypeEnum.MRO.getCode() == delivery.getMaterialType()) {
            vo.setMroDeliveryCode(delivery.getMroDeliveryCode());
        }
        if ((response = this.cloudProjectApi.queryConfigByOrgId(delivery.getOrgId())).isSuccess() && null != response.getData() && 1 == ((ConfigProjectVO)response.getData()).getEnabled()) {
            vo.setProjectCloudFlag(Integer.valueOf(1));
        } else {
            vo.setProjectCloudFlag(Integer.valueOf(0));
        }
        List deliveryDetailList = this.deliveryDetailService.list((Wrapper)new LambdaQueryWrapper().eq(DeliveryDetailEntity::getDeliveryId, (Object)delivery.getId()));
        if (CollectionUtils.isNotEmpty((Collection)deliveryDetailList)) {
            CommonResponse commonResponse;
            ArrayList detailList = new ArrayList();
            ArrayList materialIds = new ArrayList();
            deliveryDetailList.forEach(dd -> {
                CheckDetailVO detail = new CheckDetailVO();
                detail.setDeliveryId(delivery.getId());
                detail.setDeliveryDetailId(dd.getId());
                detail.setOrderId(dd.getOrderId());
                detail.setOrderDetailId(dd.getOrderDetailId());
                detail.setMaterialTypeId(dd.getMaterialTypeId());
                detail.setMaterialTypeName(dd.getMaterialTypeName());
                detail.setMaterialId(dd.getMaterialId());
                detail.setMaterialCode(dd.getMaterialCode());
                detail.setMaterialName(dd.getMaterialName());
                detail.setUnit(dd.getUnit());
                detail.setSpec(dd.getSpec());
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());
                detail.setDeliverNumsSum(dd.getDeliverNumsSum());
                detail.setNprice(dd.getPrice());
                detail.setNtaxprice(dd.getTaxPrice());
                detail.setTaxrate(dd.getTaxRate());
                materialIds.add(dd.getMaterialId());
                detail.setMaterialSourceId(dd.getMaterialSourceId());
                detail.setSurplusFlag(Integer.valueOf(1));
                if (MaterialTypeEnum.MRO.getCode() == delivery.getMaterialType()) {
                    detail.setMroTaxrate(dd.getMroTaxrate());
                    detail.setMroDeliverNumsSum(dd.getMroDeliverNumsSum());
                    detail.setMroMny(dd.getMroMny());
                    detail.setMroNprice(dd.getMroNprice());
                    detail.setMroNtaxprice(dd.getMroNtaxprice());
                    detail.setMroSupplierSkuCode(dd.getMroSupplierSkuCode());
                    detail.setMroSupplierSkuId(dd.getMroSupplierSkuId());
                    detail.setMroTaxmny(dd.getMroTaxmny());
                    detail.setMroTax(dd.getMroTax());
                    detail.setMroUnit(dd.getMroUnit());
                    detail.setMroUnitRatio(dd.getMroUnitRatio());
                    detail.setMroCheckNum(dd.getMroDeliverNumsSum());
                    detail.setMny(detail.getMroMny());
                    detail.setTaxmny(detail.getMroTaxmny());
                    detail.setCheckNumsSum(detail.getDeliverNumsSum());
                    detail.setNprice(detail.getMroMny().divide(detail.getDeliverNumsSum(), 8, 4));
                    detail.setNtaxprice(detail.getMroTaxmny().divide(detail.getDeliverNumsSum(), 8, 4));
                    detail.setTaxrate(detail.getMroTaxrate());
                    detail.setTax(detail.getMroTax());
                }
                detailList.add(detail);
            });
            if (CollectionUtils.isNotEmpty(detailList) && 1 == vo.getProjectCloudFlag() && CollectionUtils.isNotEmpty(materialIds) && (commonResponse = this.cloudMeterialApi.queryCloudMeterial(materialIds, delivery.getOrgId())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                List longList = (List)commonResponse.getData();
                Iterator iterator = detailList.iterator();
                while (iterator.hasNext()) {
                    CheckDetailVO checkDetailVO;
                    checkDetailVO.setSurplusFlag(Integer.valueOf(longList.contains((checkDetailVO = (CheckDetailVO)iterator.next()).getMaterialId()) ? 0 : 1));
                }
            }
            vo.setDetailList(detailList);
        }
        return vo;
    }

    @Override
    public Boolean deleteIds(List<Long> ids) {
        List entityList = ((CheckMapper)this.baseMapper).selectList((Wrapper)new QueryWrapper().in((Object)"id", ids));
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityList.forEach(entity -> {
                if (entity.getUseState() == 1) {
                    throw new BusinessException("\u5355\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
                }
            });
        }
        List vos = BeanMapper.mapList((Iterable)entityList, CheckVO.class);
        ArrayList deleteFlowList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            vos.forEach(vo -> {
                this.writeBackDelivery((CheckVO)vo, false);
                this.writeBackOrder((CheckVO)vo, false);
                this.writeBackPoundDel(vo.getId());
                this.writeBackWeighReportDel(vo.getId());
                WarehouseManageVO manageVO = new WarehouseManageVO();
                manageVO.setProjectId(vo.getProjectId());
                manageVO.setStoreId(vo.getWarehouseId());
                manageVO.setInOutFlag(InOutFlagEnum.\u5165\u5e93.getCode());
                ArrayList<Long> detailIds = new ArrayList<Long>();
                CheckEntity checkEntity = (CheckEntity)((Object)((Object)super.selectById((Serializable)vo.getId())));
                if (checkEntity.getDeliveryId() == null) {
                    manageVO.setType(Integer.valueOf(1));
                } else {
                    manageVO.setType(Integer.valueOf(2));
                }
                for (CheckDetailEntity checkDetailEntity : checkEntity.getDetailList()) {
                    detailIds.add(checkDetailEntity.getId());
                }
                if (1 == checkEntity.getSaveState()) {
                    deleteFlowList.add(checkEntity);
                }
                manageVO.setDelDetailIdList(detailIds);
                this.writeBackFlow(manageVO);
            });
        }
        if (CollectionUtils.isNotEmpty(deleteFlowList)) {
            List checkVOS = BeanMapper.mapList(deleteFlowList, CheckVO.class);
            this.rmatFlowService.delCheckFlow(checkVOS);
            this.rmatFlowService.delCheckTransfFlow(checkVOS);
        }
        return super.removeByIds(ids, true);
    }

    private void writeBackFlow(WarehouseManageVO manageVO) {
        this.iWarehouseFlowApi.rollBack(manageVO);
    }

    @Override
    public Boolean push2NC(Long id) {
        boolean drflag = this.sysdr(id);
        if (!drflag) {
            throw new BusinessException("NC\u7aef\u5df2\u5b58\u5728\u4e14\u672a\u5220\u9664");
        }
        StringBuffer msg = new StringBuffer();
        String pkUser = this.getUserSourceId();
        CheckEntity check = (CheckEntity)((Object)((CheckMapper)this.baseMapper).selectById(id));
        if (StringUtils.isEmpty((CharSequence)check.getContractId())) {
            msg.append("[\u5408\u540c]");
        }
        if (StringUtils.isEmpty((CharSequence)check.getCwarehouseid())) {
            msg.append("[\u4ed3\u5e93]");
        }
        if (StringUtils.isEmpty((CharSequence)check.getCkcorgid())) {
            msg.append("[\u5e93\u5b58\u7ec4\u7ec7]");
        }
        if (StringUtils.isEmpty((CharSequence)check.getCdispatcherid())) {
            msg.append("[\u6536\u53d1\u7c7b\u522b]");
        }
        if (StringUtils.isEmpty((CharSequence)check.getCpurorganization())) {
            msg.append("[\u91c7\u8d2d\u7ec4\u7ec7]");
        }
        if (StringUtils.isEmpty((CharSequence)check.getCdptid())) {
            msg.append("[\u91c7\u8d2d\u90e8\u95e8]");
        }
        List checkBList = this.checkDetailService.list((Wrapper)Wrappers.lambdaQuery().eq(CheckDetailEntity::getCheckId, (Object)id));
        for (CheckDetailEntity detailEntity : checkBList) {
            if (!StringUtils.isEmpty((CharSequence)detailEntity.getPkAmountlist())) continue;
            msg.append("[\u8868\u4f53\u5206\u5f55]");
            break;
        }
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            throw new BusinessException(msg + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CommonResponse commonResponse = this.cmContractApi.queryMatContractById(check.getContractId());
        if (commonResponse.isSuccess()) {
            CmContract cmContract = (CmContract)commonResponse.getData();
            check.setContractCode(cmContract.getContractcode());
            check.setmPkCtManag(cmContract.getPkCtManage());
        }
        List<PurchaseOrderVO> checkVOList = this.changToNcVO(check, checkBList, pkUser);
        for (PurchaseOrderVO checkVO : checkVOList) {
            this.logger.info("--->> \u63a8\u9001NC\u6784\u9020\u5b9e\u4f53VO: " + JSON.toJSONString((Object)checkVO));
            IPurchaseOrderService ncService = new IPurchaseOrderService();
            try {
                IPurchaseOrderServicePortType http = ncService.getIPurchaseOrderServiceSOAP11PortHttp();
                String resulet = http.processData(checkVO);
                if (StringUtils.isNotEmpty((CharSequence)resulet)) {
                    this.logger.info("--->> \u63a8\u9001NC\u8fd4\u56deresult: " + resulet);
                    JSONObject valueMap = JSON.parseObject((String)resulet);
                    String code = (String)valueMap.get("code");
                    if (!"WS000001".equals(code)) {
                        msg.append((String)valueMap.get("msg"));
                    }
                }
            }
            catch (Exception e) {
                this.logger.info("\u63a8\u9001NC\u51fa\u9519" + e.getMessage());
                throw new BusinessException("\u63a8\u9001NC\u51fa\u9519");
            }
            if (!StringUtils.isNotEmpty((CharSequence)msg)) continue;
            throw new BusinessException("\u63a8\u9001NC" + msg);
        }
        check.setUseState(1);
        check.setPushUserId(InvocationInfoProxy.getUserid());
        check.setPushUserName(this.sessionManager.getUserContext().getUserName());
        check.setPushUserSourceId(this.getUserSourceId());
        ((CheckMapper)this.baseMapper).updateById((Object)check);
        return true;
    }

    @Override
    public Boolean push2Mro(Long id) {
        CheckEntity checkEntity = (CheckEntity)((Object)this.selectById(id));
        if (null == checkEntity.getMroState() || 0 == checkEntity.getMroState()) {
            SyncMroCheckVO mroCheckVO = new SyncMroCheckVO();
            mroCheckVO.setDeliveryCode(checkEntity.getMroDeliveryCode());
            if (CollectionUtils.isNotEmpty(checkEntity.getDetailList())) {
                ArrayList detailVOList = new ArrayList();
                checkEntity.getDetailList().forEach(detail -> {
                    SyncMroCheckDetailVO mroCheckDetailVO = new SyncMroCheckDetailVO();
                    mroCheckDetailVO.setQuantity(detail.getMroCheckNum());
                    mroCheckDetailVO.setSupplierSkuId(detail.getMroSupplierSkuId());
                    detailVOList.add(mroCheckDetailVO);
                });
                mroCheckVO.setDetailList(detailVOList);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            this.thirdSystemUtils.getMroSign(headers);
            String mroUrl = this.addr + "/iec/v1/purchase_plan/receipt";
            try {
                this.logger.info("\u63a8\u9001MRO" + JSONObject.toJSON((Object)mroCheckVO).toString());
                String responseStr = HttpTookit.postByJson(mroUrl, JSONObject.toJSON((Object)mroCheckVO).toString(), headers);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (200 != json.getInteger("code") || !json.getBoolean("success").booleanValue()) {
                    throw new BusinessException(json.getString("message"));
                }
                this.logger.info("\u63a8\u9001MRO\u6210\u529f" + json.toJSONString());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)id);
                updateWrapper.set(CheckEntity::getMroState, (Object)1);
                this.update((Wrapper)updateWrapper);
            }
            catch (Exception e) {
                throw new BusinessException(e.getMessage());
            }
        }
        return true;
    }

    @Override
    public Boolean sysdr(Long id) {
        boolean flag = true;
        Integer dr = 1;
        ArrayList<String> arrList = new ArrayList<String>();
        arrList.add(String.valueOf(id));
        IPurchaseOrderService ncService = new IPurchaseOrderService();
        StringBuffer msg = new StringBuffer();
        try {
            IPurchaseOrderServicePortType http = ncService.getIPurchaseOrderServiceSOAP11PortHttp();
            String json = http.getBillsStatus(arrList);
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                this.logger.info("--->> NC\u540c\u6b65dr\u8fd4\u56deresult: " + json);
                JSONObject valueMap = JSON.parseObject((String)json);
                String code = (String)valueMap.get("code");
                if (!"WS000001".equals(code)) {
                    msg.append((String)valueMap.get("msg"));
                } else {
                    JSONObject map;
                    JSONArray jsarr = (JSONArray)valueMap.get("data");
                    if (jsarr != null && jsarr.size() > 0 && (dr = Integer.valueOf((map = (JSONObject)jsarr.get(0)).get("dr") != null ? Integer.parseInt((String)map.get("dr")) : dr)) != 1) {
                        flag = false;
                    }
                }
            } else {
                msg.append("\u7ed3\u679c\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u540c\u6b65NC\u5220\u9664\u72b6\u6001\u51fa\u9519");
        }
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            throw new BusinessException("\u540c\u6b65NC" + msg);
        }
        CheckEntity entity = (CheckEntity)((Object)((CheckMapper)this.baseMapper).selectById(id));
        if (entity.getUseState() == 1 && dr == 1) {
            entity.setUseState(0);
            ((CheckMapper)this.baseMapper).updateById((Object)entity);
        }
        return flag;
    }

    @Override
    public Boolean updatenums(List<Long> ids) {
        boolean res;
        List checks = new ArrayList();
        if (!ids.isEmpty()) {
            checks = ((CheckMapper)this.baseMapper).selectBatchIds(ids);
            if (checks.size() > 0 && checks.size() == ids.size()) {
                Iterator iterator = checks.iterator();
                while (iterator.hasNext()) {
                    CheckEntity check;
                    check.setPrintNum((check = (CheckEntity)((Object)iterator.next())).getPrintNum() == null || check.getPrintNum() == 0 ? 1 : check.getPrintNum() + 1);
                }
            } else {
                throw new BusinessException("\u6570\u636e\u53ef\u80fd\u88ab\u66f4\u6539,\u8bf7\u5237\u65b0\u754c\u9762\u540e\u518d\u64cd\u4f5c");
            }
        }
        if (!(res = super.saveOrUpdateBatch(checks))) {
            throw new BusinessException("\u6570\u636e\u53ef\u80fd\u88ab\u66f4\u6539,\u8bf7\u5237\u65b0\u754c\u9762\u540e\u518d\u64cd\u4f5c");
        }
        return res;
    }

    private void writeBackDelivery(CheckVO checkVO, Boolean flag) {
        if (checkVO.getDeliveryId() != null) {
            DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.getById(checkVO.getDeliveryId()));
            if (null == checkVO.getId()) {
                delivery.setDeliverState(2);
                this.writeBackCheckToSupplier(checkVO.getDeliveryId(), true);
            }
            if (!flag.booleanValue()) {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.in(CheckEntity::getDeliveryId, new Object[]{checkVO.getDeliveryId()});
                lambda.ne(BaseEntity::getId, (Object)checkVO.getId());
                List entityList = ((CheckMapper)this.baseMapper).selectList((Wrapper)lambda);
                if (entityList.size() == 0) {
                    delivery.setDeliverState(1);
                    this.writeBackCheckToSupplier(checkVO.getDeliveryId(), false);
                }
                if ("1".equals(delivery.getCloseStatus())) {
                    delivery.setCloseStatus("0");
                    this.writeBackOpenDelivery(checkVO.getDeliveryId(), false);
                }
            }
            this.deliveryService.updateById((Object)delivery);
        }
        List detailList = checkVO.getDetailList();
        ArrayList ddEditList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(vo -> {
                if (vo.getDeliveryDetailId() != null) {
                    BigDecimal checkNums;
                    BigDecimal bigDecimal = checkNums = vo.getCheckNumsSum() == null ? BigDecimal.ZERO : vo.getCheckNumsSum();
                    if (null == vo.getId() || !flag.booleanValue() || "del".equals(vo.getRowState())) {
                        BigDecimal ddCheckNums;
                        DeliveryDetailEntity ddEntity = (DeliveryDetailEntity)((Object)((Object)this.deliveryDetailService.getById(vo.getDeliveryDetailId())));
                        BigDecimal bigDecimal2 = ddCheckNums = ddEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : ddEntity.getCheckNumsSum();
                        ddCheckNums = flag.booleanValue() ? ("del".equals(vo.getRowState()) ? ddCheckNums.subtract(checkNums) : ddCheckNums.add(checkNums)) : ddCheckNums.subtract(checkNums);
                        ddEntity.setCheckNumsSum(ddCheckNums);
                        ddEditList.add(ddEntity);
                    } else {
                        BigDecimal checkNumsDb;
                        CheckDetailEntity detailEntity = (CheckDetailEntity)((Object)((Object)this.checkDetailService.getById(vo.getId())));
                        BigDecimal bigDecimal3 = checkNumsDb = detailEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : detailEntity.getCheckNumsSum();
                        if (checkNums.compareTo(checkNumsDb) != 0) {
                            DeliveryDetailEntity ddEntity = (DeliveryDetailEntity)((Object)((Object)this.deliveryDetailService.getById(vo.getDeliveryDetailId())));
                            BigDecimal ddCheckNums = ddEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : ddEntity.getCheckNumsSum();
                            ddCheckNums = ddCheckNums.subtract(checkNumsDb).add(checkNums);
                            ddEntity.setCheckNumsSum(ddCheckNums);
                            ddEditList.add(ddEntity);
                        }
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(ddEditList)) {
                this.deliveryDetailService.updateBatchById(ddEditList);
            }
        }
    }

    private void writeBackOrder(CheckVO checkVO, Boolean flag) {
        List detailList = checkVO.getDetailList();
        ArrayList odEditList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(vo -> {
                if (vo.getOrderDetailId() != null) {
                    BigDecimal checkNums;
                    BigDecimal bigDecimal = checkNums = vo.getCheckNumsSum() == null ? BigDecimal.ZERO : vo.getCheckNumsSum();
                    if (null == vo.getId() || !flag.booleanValue() || "del".equals(vo.getRowState())) {
                        BigDecimal odCheckNums;
                        OrderDetailEntity odEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getOrderDetailId())));
                        BigDecimal bigDecimal2 = odCheckNums = odEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : odEntity.getCheckNumsSum();
                        odCheckNums = flag.booleanValue() ? ("del".equals(vo.getRowState()) ? odCheckNums.subtract(checkNums) : odCheckNums.add(checkNums)) : odCheckNums.subtract(checkNums);
                        odEntity.setCheckNumsSum(odCheckNums);
                        odEditList.add(odEntity);
                    } else {
                        BigDecimal checkNumsDb;
                        CheckDetailEntity detailEntity = (CheckDetailEntity)((Object)((Object)this.checkDetailService.getById(vo.getId())));
                        BigDecimal bigDecimal3 = checkNumsDb = detailEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : detailEntity.getCheckNumsSum();
                        if (checkNums.compareTo(checkNumsDb) != 0) {
                            OrderDetailEntity odEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getOrderDetailId())));
                            BigDecimal odCheckNums = odEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : odEntity.getCheckNumsSum();
                            odCheckNums = odCheckNums.subtract(checkNumsDb).add(checkNums);
                            odEntity.setCheckNumsSum(odCheckNums);
                            odEditList.add(odEntity);
                        }
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(odEditList)) {
                this.orderDetailService.updateBatchById(odEditList);
            }
        }
    }

    private List<PurchaseOrderVO> changToNcVO(CheckEntity check, List<CheckDetailEntity> checkBList, String pkUser) {
        ArrayList<PurchaseOrderVO> purchaseOrderVOS = new ArrayList<PurchaseOrderVO>();
        HashMap map = new HashMap();
        for (CheckDetailEntity detailEntity : checkBList) {
            BigDecimal sl = detailEntity.getTaxrate() == null ? BigDecimal.ZERO : detailEntity.getTaxrate();
            String key = detailEntity.getPkAmountlist() + "&" + sl;
            List list = map.containsKey(key) ? (List)map.get(key) : new ArrayList();
            list.add(detailEntity);
            map.put(key, list);
        }
        for (String key : map.keySet()) {
            PurchaseOrderVO checkVO = new PurchaseOrderVO();
            PurchaseOrderHeadVO checkHVO = this.changeToNcHVO(check, pkUser, key);
            List<PurchaseOrderBodyVO> checkBVOList = this.changeToNcBVO(check, (List)map.get(key));
            checkVO.setPurchaseOrderHeadVO(checkHVO);
            checkVO.setPurchaseOrderBodyVO(checkBVOList.toArray(new PurchaseOrderBodyVO[0]));
            purchaseOrderVOS.add(checkVO);
        }
        return purchaseOrderVOS;
    }

    private PurchaseOrderHeadVO changeToNcHVO(CheckEntity check, String pkUser, String key) {
        PurchaseOrderHeadVO checkVO = new PurchaseOrderHeadVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        checkVO.setPk_corp(check.getParentOrgSourceId());
        checkVO.setNversion(1);
        checkVO.setDbilldate(new SimpleDateFormat("yyyy-MM-dd").format(check.getCheckDate()));
        checkVO.setCbiztype("0001N510000000036VJ3");
        checkVO.setPk_project(check.getProjectSourceId());
        checkVO.setCwarehouseid(check.getCwarehouseid());
        checkVO.setCpurorganization(check.getCkcorgid());
        checkVO.setCvendormangid(check.getSupplierSourceId());
        checkVO.setCdispatcherid(check.getCdispatcherid());
        checkVO.setCpurorganization2(check.getCpurorganization());
        checkVO.setCdptid(check.getCdptid());
        checkVO.setVmemo(check.getBillCode());
        checkVO.setVbeizhu(StringUtils.isNotBlank((CharSequence)check.getConstruction()) && check.getConstruction().length() > 100 ? check.getConstruction().substring(0, 100) : check.getConstruction());
        checkVO.setNtaxrate(BigDecimal.valueOf(0L));
        checkVO.setPk_defdoc5(sdf.format(new Date()));
        checkVO.setFrom_source("qlhpt_00000001");
        checkVO.setWebsite(this.getWebSite(check.getId()));
        checkVO.setTmaketime(sdf.format(new Date()));
        checkVO.setCoperator(pkUser);
        checkVO.setDauditdate(sdf.format(new Date()));
        checkVO.setCauditpsn(pkUser);
        checkVO.setPk_transfer(String.valueOf(check.getId()));
        checkVO.setCwhsmanagerid(check.getCreateUserSourceId());
        checkVO.setPk_contract(check.getContractId());
        String[] arr = key.split("&");
        checkVO.setHtflh(arr[0]);
        checkVO.setSl(new BigDecimal(arr[1]));
        checkVO.setM_pk_ct_manag(check.getmPkCtManag());
        return checkVO;
    }

    private String getWebSite(Long id) {
        Long userid = InvocationInfoProxy.getUserid();
        String targeturl = this.BASE_HOST + "cscec5bhn-wzxt-frontend/#/check/card?id=" + id;
        this.logger.info("--->> targeturl: " + targeturl);
        try {
            targeturl = URLEncoder.encode(targeturl, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String webSite = this.BASE_HOST + "portal/sso/index?userid=" + userid + "&targeturl=" + targeturl;
        this.logger.info("--->> \u751f\u6210\u9a8c\u6536\u5355\u8df3\u8f6c\u5730\u5740: " + webSite);
        return webSite;
    }

    private List<PurchaseOrderBodyVO> changeToNcBVO(CheckEntity check, List<CheckDetailEntity> checkBList) {
        ArrayList<PurchaseOrderBodyVO> checkBVOList = new ArrayList<PurchaseOrderBodyVO>();
        if (checkBList != null && checkBList.size() > 0) {
            for (CheckDetailEntity checkB : checkBList) {
                PurchaseOrderBodyVO checkBVO = new PurchaseOrderBodyVO();
                checkBVO.setPk_contract(check.getContractId());
                checkBVO.setContract_name(check.getContractName());
                checkBVO.setPk_cinventory(checkB.getMaterialSourceId());
                checkBVO.setCinventorycode(checkB.getMaterialCode());
                checkBVO.setCinventoryname(checkB.getMaterialName());
                checkBVO.setInvspec(checkB.getDef1());
                checkBVO.setInvtype(checkB.getDef2());
                checkBVO.setPk_measddoc(checkB.getDef3());
                checkBVO.setNinnum(checkB.getCheckNumsSum() == null ? BigDecimal.ZERO : checkB.getCheckNumsSum());
                checkBVO.setNprice(checkB.getNprice() == null ? BigDecimal.ZERO : checkB.getNprice());
                checkBVO.setNmny(checkB.getMny().setScale(2, 4));
                checkBVO.setNtaxrate_b(checkB.getTaxrate() == null ? BigDecimal.ZERO : checkB.getTaxrate());
                checkBVO.setTaxmny(checkB.getTax().setScale(2, 4));
                checkBVO.setNtaxmny(checkB.getTaxmny().setScale(2, 4));
                checkBVO.setDbizdate(new SimpleDateFormat("yyyy-MM-dd").format(check.getCheckDate()));
                checkBVO.setVnotebody(checkB.getMemo());
                checkBVO.setVdef20(checkB.getMaterialManufacturer());
                checkBVO.setHtflh(checkB.getPkAmountlist());
                checkBVO.setSl(checkB.getTaxrate() == null ? BigDecimal.ZERO : checkB.getTaxrate());
                checkBVOList.add(checkBVO);
            }
        }
        return checkBVOList;
    }

    @Override
    public CommonResponse<Object> poundList(String id) {
        this.logger.info("------------  \u67e5\u8be2\u78c5\u5355\u5217\u8868  ------------");
        String url = this.SUPPLIER_HTTP + "/el/sw/weigh/check/list";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkCheck", String.valueOf(id));
        return this.doGetHttp(url, params);
    }

    @Override
    public CommonResponse<Object> poundDetail(String pkWeighBill) {
        this.logger.info("------------  \u67e5\u8be2\u78c5\u5355\u8be6\u60c5  ------------");
        String url = this.SUPPLIER_HTTP + "/el/sw/weigh/detail";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkWeighBill", pkWeighBill);
        return this.doGetHttp(url, params);
    }

    @Override
    public CommonResponse<Object> getWeighListByPks(List<String> pkWeighBill) {
        this.logger.info("------------  \u6839\u636e\u4e3b\u952e\u96c6\u5408\u83b7\u53d6\u78c5\u5355\u4fe1\u606f  ------------");
        String url = this.SUPPLIER_HTTP + "/el/sw/weigh/list";
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("pkWeighs", pkWeighBill);
        JSONObject params = JSONObject.parseObject((String)JSON.toJSONString(map));
        String parameterStr = params.toJSONString();
        return this.doPostHttp(url, parameterStr);
    }

    @Override
    public CommonResponse<Object> getWeighListByDelivery(String pkDelivery, Integer checkStatus) {
        this.logger.info("------------  \u6839\u636e\u53d1\u8d27\u5355\u4e3b\u952e\u83b7\u53d6\u78c5\u5355\u4fe1\u606f  ------------");
        String url = this.SUPPLIER_HTTP + "/el/sw/weigh/delivery/list";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkDelivery", pkDelivery);
        if (checkStatus != null) {
            params.put("checkStatus", String.valueOf(checkStatus));
        }
        return this.doGetHttp(url, params);
    }

    @Override
    public List<MaterialInRefVO> getMaterialInRef(Page<MaterialInRefVO> page, QueryWrapper wrapper, String contractId, Long tenantId) {
        List<MaterialInRefVO> list = ((CheckMapper)this.baseMapper).getMaterialInRef(page, wrapper, contractId, tenantId);
        return list;
    }

    private CommonResponse<Object> writeBackCheckToSupplier(Long deliveryId, Boolean isCheck) {
        DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.getById(deliveryId));
        String pkDelivery = StringUtils.isNotEmpty((CharSequence)delivery.getHistoryId()) ? delivery.getHistoryId() : String.valueOf(deliveryId);
        this.logger.info("------------  \u56de\u5199\u4f9b\u65b9\u53d1\u8d27\u5355\u9a8c\u6536\u72b6\u6001  ------------");
        String url = this.SUPPLIER_HTTP + "/el/delivery/delivery/check";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkDelivery", pkDelivery);
        params.put("isCheck", String.valueOf(isCheck));
        return this.doGetHttp(url, params);
    }

    public CommonResponse<Object> writeBackOpenDelivery(Long deliveryId, Boolean isClose) {
        DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.getById(deliveryId));
        String pkDelivery = StringUtils.isNotEmpty((CharSequence)delivery.getHistoryId()) ? delivery.getHistoryId() : String.valueOf(deliveryId);
        this.logger.info("------------  \u56de\u5199\u4f9b\u65b9\u53d1\u8d27\u5355\u5f00\u542f  ------------");
        String url = this.SUPPLIER_HTTP + "/el/delivery/delivery/close";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkDelivery", pkDelivery);
        params.put("isClose", String.valueOf(isClose));
        return this.doGetHttp(url, params);
    }

    private CommonResponse<Object> writeBackPoundTemp(Long id, List<String> pkWeighBills) {
        if (CollectionUtils.isEmpty(pkWeighBills)) {
            return CommonResponse.error((String)"pkWeighBills\u4e3a\u7a7a\uff01");
        }
        this.logger.info("------------  \u4fdd\u5b58\u9a8c\u6536\u5355\u4e3b\u952e\u4e0e\u78c5\u5355\u4e3b\u952e\u5173\u7cfb\uff08\u78c5\u5355\u786e\u8ba4\u72b6\u6001-\u6682\u5b58\uff09  ------------");
        String url = this.SUPPLIER_HTTP + "/el/sw/weigh/check";
        WeighCheckVO data = new WeighCheckVO();
        data.setPkCheck(String.valueOf(id));
        data.setPkWeighBills(pkWeighBills);
        String parameterStr = JSONObject.toJSON((Object)data).toString();
        return this.doPostHttp(url, parameterStr);
    }

    private void writeBackWeighReportCheck(Long id, String billCode, List<String> pkWeighBills) {
        if (CollectionUtils.isEmpty(pkWeighBills)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(WeighReportEntity::getPkWeighBill, pkWeighBills);
        updateWrapper.set(WeighReportEntity::getPkCheck, (Object)String.valueOf(id));
        updateWrapper.set(WeighReportEntity::getCheckCode, (Object)billCode);
        updateWrapper.set(WeighReportEntity::getCheckStatus, (Object)1);
        this.weighReportService.update((Wrapper)updateWrapper);
    }

    private CommonResponse<Object> writeBackPound(Long id) {
        this.logger.info("------------  \u66f4\u65b0\u78c5\u5355\u786e\u8ba4\u72b6\u6001-\u5df2\u786e\u8ba4  ------------");
        String url = this.SUPPLIER_HTTP + "/el/sw/weigh/updateCheckStatus";
        WeighCheckVO data = new WeighCheckVO();
        data.setPkCheck(String.valueOf(id));
        data.setBillStatus(Integer.valueOf(2));
        String parameterStr = JSONObject.toJSON((Object)data).toString();
        return this.doPostHttp(url, parameterStr);
    }

    private void writeBackWeighReport(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(WeighReportEntity::getPkCheck, (Object)String.valueOf(id));
        updateWrapper.set(WeighReportEntity::getCheckStatus, (Object)2);
        this.weighReportService.update((Wrapper)updateWrapper);
    }

    private CommonResponse<Object> writeBackPoundDel(Long id) {
        this.logger.info("------------  \u5220\u9664\u56de\u5199\u78c5\u5355\u9a8c\u6536\u72b6\u6001  ------------");
        String url = this.SUPPLIER_HTTP + "/el/sw/weigh/unCheck";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkCheck", String.valueOf(id));
        return this.doGetHttp(url, params);
    }

    private void writeBackWeighReportDel(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(WeighReportEntity::getPkCheck, (Object)String.valueOf(id));
        updateWrapper.set(WeighReportEntity::getPkCheck, null);
        updateWrapper.set(WeighReportEntity::getCheckStatus, (Object)0);
        updateWrapper.set(WeighReportEntity::getCheckCode, null);
        this.weighReportService.update((Wrapper)updateWrapper);
    }

    private CommonResponse<Object> doGetHttp(String url, Map<String, String> params) {
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.orderService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            try {
                this.logger.info("------------  url\uff1a" + url + "  ------------");
                this.logger.info("------------  \u5165\u53c2\uff1a" + params.toString() + "  ------------");
                String back = HttpTookit.get(url, params, headers);
                JSONObject jsonBack = JSONObject.parseObject((String)back);
                if ("200".equals(jsonBack.getString("code"))) {
                    this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                    return CommonResponse.success((Object)jsonBack.get((Object)"body"));
                }
                this.logger.error("------------  \u8bf7\u6c42\u5931\u8d25\uff01message = " + jsonBack.getString("message") + "  ------------");
                return CommonResponse.error((String)jsonBack.getString("message"));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
            }
        }
        this.logger.error("\u83b7\u53d6token\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
    }

    private CommonResponse<Object> doPostHttp(String url, String parameterStr) {
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.orderService.getAccessToken(headers);
        if (tokenres.isSuccess()) {
            try {
                this.logger.info("------------  url\uff1a" + url + "  ------------");
                this.logger.info("------------  \u5165\u53c2\uff1a" + parameterStr + "  ------------");
                String back = HttpTookit.postByJson(url, parameterStr, headers);
                JSONObject jsonBack = JSONObject.parseObject((String)back);
                if ("200".equals(jsonBack.getString("code"))) {
                    this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01body = " + jsonBack.getString("body") + "  ------------");
                    return CommonResponse.success((Object)jsonBack.get((Object)"body"));
                }
                this.logger.error("------------  \u8bf7\u6c42\u5931\u8d25\uff01message = " + jsonBack.getString("message") + "  ------------");
                return CommonResponse.error((String)jsonBack.getString("message"));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
            }
        }
        this.logger.error("\u83b7\u53d6token\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
    }

    private String getUserSourceId() {
        UserVO vo;
        CommonResponse res = this.userApi.queryListByIds(new String[]{String.valueOf(InvocationInfoProxy.getUserid())});
        if (!res.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff01");
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)res.getData())) && (vo = (UserVO)((List)res.getData()).get(0)) != null && StringUtils.isNotEmpty((CharSequence)vo.getSourceId())) {
            return vo.getSourceId();
        }
        return null;
    }

    public static BigDecimal safeAdd(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null && decimal2 == null) {
            return null;
        }
        decimal1 = decimal1 == null ? BigDecimal.ZERO : new BigDecimal(decimal1.toString());
        decimal2 = decimal2 == null ? BigDecimal.ZERO : new BigDecimal(decimal2.toString());
        return decimal1.add(decimal2);
    }
}

