/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.datalake.api.IMysteelApi;
import com.ejianc.business.datalake.vo.BrandRefVO;
import com.ejianc.business.datalake.vo.MarketPriceVO;
import com.ejianc.business.datalake.vo.RegionRefVO;
import com.ejianc.business.wzxt.bean.CtPlanEntity;
import com.ejianc.business.wzxt.service.ICtPlanService;
import com.ejianc.business.wzxt.vo.ConCheckVO;
import com.ejianc.business.wzxt.vo.CtPlanRefVO;
import com.ejianc.business.wzxt.vo.CtPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ctPlan"})
public class CtPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICtPlanService service;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IMysteelApi mysteelApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CtPlanVO> saveOrUpdate(@RequestBody CtPlanVO saveorUpdateVO) {
        CtPlanEntity entity = (CtPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CtPlanEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CtPlanVO vo = (CtPlanVO)BeanMapper.map((Object)((Object)entity), CtPlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CtPlanVO> queryDetail(Long id) {
        CtPlanEntity entity = (CtPlanEntity)((Object)this.service.selectById(id));
        CtPlanVO vo = (CtPlanVO)BeanMapper.map((Object)((Object)entity), CtPlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CtPlanVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getNumByProjectId"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ConCheckVO>> getNumByProjectId(@RequestBody ConCheckVO conCheckVO) {
        List<ConCheckVO> list = this.service.getNumByProjectId(conCheckVO);
        return CommonResponse.success((String)"\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CtPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            ArrayList commonOrgIds = new ArrayList();
            CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgListResp.isSuccess()) {
                return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put("orgId", new Parameter("in", childIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CtPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/controlPlanRef"})
    @ResponseBody
    public CommonResponse<JSONObject> controlPlanRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            projectId = Long.valueOf(conditionMap.get("projectId").toString());
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<CtPlanRefVO> list = this.service.getControlPlan((Page<CtPlanRefVO>)page, wrapper, projectId, InvocationInfoProxy.getTenantid());
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @GetMapping(value={"/regionRef"})
    @ResponseBody
    public CommonResponse<JSONObject> regionRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("region");
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        String materialName = null;
        String website = null;
        String checkDate = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("materialName")) {
                materialName = conditionMap.get("materialName").toString();
            }
            if (null != conditionMap.get("website")) {
                website = conditionMap.get("website").toString();
            }
            if (null != conditionMap.get("checkDate")) {
                checkDate = conditionMap.get("checkDate").toString();
            }
        }
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<Object> list = new ArrayList();
        if (website != null && website.equals("myweb")) {
            CommonResponse myRegionList = this.mysteelApi.getRegionRef1(pageNumber, pageSize, condition, searchText);
            if (!myRegionList.isSuccess()) {
                return CommonResponse.success((String)"[\u6211\u7684\u94a2\u94c1\u7f51] \u5730\u533a\u53c2\u7167\u67e5\u8be2\u5931\u8d25\uff01");
            }
            list = (List)myRegionList.getData();
        } else {
            list = this.service.getRegionRef2((Page<RegionRefVO>)page, wrapper, materialName, checkDate);
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @GetMapping(value={"/brandRef"})
    @ResponseBody
    public CommonResponse<JSONObject> brandRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("brand");
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        String materialName = null;
        String region = null;
        String website = null;
        String checkDate = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("materialName")) {
                materialName = conditionMap.get("materialName").toString();
            }
            if (null != conditionMap.get("region")) {
                region = conditionMap.get("region").toString();
            }
            if (null != conditionMap.get("website")) {
                website = conditionMap.get("website").toString();
            }
            if (null != conditionMap.get("checkDate")) {
                checkDate = conditionMap.get("checkDate").toString();
            }
        }
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List list = null;
        if (website.equals("myweb")) {
            CommonResponse myBrandList = this.mysteelApi.getBrandRef1(pageNumber, pageSize, condition, searchText);
            if (!myBrandList.isSuccess()) {
                return CommonResponse.success((String)"[\u6211\u7684\u94a2\u94c1\u7f51] \u54c1\u724c\u53c2\u7167\u67e5\u8be2\u5931\u8d25\uff01");
            }
            list = (List)myBrandList.getData();
        } else {
            list = this.service.getBrandRef2((Page<BrandRefVO>)page, wrapper, materialName, region, checkDate);
        }
        JSONObject res = new JSONObject();
        res.put("records", (Object)list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/getRecomPrice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> getRecomPrice(String website, String region, String brand, String materialName, String checkDate) {
        BigDecimal price = null;
        if (website.equals("myweb")) {
            CommonResponse myPrice = this.mysteelApi.getRecomPrice1(region, brand, materialName, checkDate);
            if (!myPrice.isSuccess()) {
                return CommonResponse.success((String)"[\u6211\u7684\u94a2\u94c1\u7f51] \u63a8\u8350\u4ef7\u683c\u67e5\u8be2\u5931\u8d25\uff01");
            }
            price = (BigDecimal)myPrice.getData();
        } else {
            price = this.service.getRecomPrice2(region, brand, materialName, checkDate);
        }
        return CommonResponse.success((String)"\u6210\u529f\uff01", (Object)price);
    }

    @RequestMapping(value={"/getMarketPrice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MarketPriceVO>> getMarketPrice(String website, String region, String brand, String materialName, String checkDate) {
        List priceList = null;
        if (website.equals("myweb")) {
            CommonResponse myPriceList = this.mysteelApi.getMarketPrice1(region, brand, materialName, checkDate);
            if (!myPriceList.isSuccess()) {
                return CommonResponse.success((String)"[\u6211\u7684\u94a2\u94c1\u7f51] \u8054\u67e5\u5e02\u573a\u4ef7\u683c\u67e5\u8be2\u5931\u8d25\uff01");
            }
            priceList = (List)myPriceList.getData();
        } else {
            priceList = this.service.getMarketPrice2(region, brand, materialName, checkDate);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5e02\u573a\u4ef7\u683c\u6570\u636e\u6210\u529f\uff01", priceList);
    }
}

