/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.datalake.vo.BrandRefVO;
import com.ejianc.business.datalake.vo.MarketPriceVO;
import com.ejianc.business.datalake.vo.RegionRefVO;
import com.ejianc.business.wzxt.bean.CtPlanEntity;
import com.ejianc.business.wzxt.mapper.CtPlanMapper;
import com.ejianc.business.wzxt.service.ICtPlanService;
import com.ejianc.business.wzxt.vo.ConCheckVO;
import com.ejianc.business.wzxt.vo.CtPlanRefVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ctPlanService")
public class CtPlanServiceImpl
extends BaseServiceImpl<CtPlanMapper, CtPlanEntity>
implements ICtPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<CtPlanRefVO> getControlPlan(Page<CtPlanRefVO> page, QueryWrapper wrapper, Long projectId, Long tenantid) {
        List<CtPlanRefVO> list = ((CtPlanMapper)this.baseMapper).getControlPlan(page, wrapper, projectId, tenantid);
        return list;
    }

    @Override
    public List<ConCheckVO> getNumByProjectId(ConCheckVO conCheckVO) {
        List<ConCheckVO> controlNumList = ((CtPlanMapper)this.baseMapper).getControlNum(conCheckVO.getProjectId(), conCheckVO.getMaterialIds());
        List<ConCheckVO> checkNumList = ((CtPlanMapper)this.baseMapper).getCheckNum(conCheckVO.getProjectId(), conCheckVO.getMaterialIds());
        List materialIds = conCheckVO.getMaterialIds();
        ArrayList<ConCheckVO> conCheckVOList = new ArrayList<ConCheckVO>();
        for (Long material : materialIds) {
            ConCheckVO conCheck = new ConCheckVO();
            conCheck.setMaterialId(material);
            for (ConCheckVO controlNumVO : controlNumList) {
                if (!controlNumVO.getMaterialId().equals(material)) continue;
                conCheck.setControlNum(controlNumVO.getControlNum());
            }
            for (ConCheckVO controlNumVO : checkNumList) {
                if (!controlNumVO.getMaterialId().equals(material)) continue;
                conCheck.setCheckNum(controlNumVO.getCheckNum());
            }
            conCheckVOList.add(conCheck);
        }
        return conCheckVOList;
    }

    @Override
    public List<RegionRefVO> getRegionRef1(Page<RegionRefVO> page, QueryWrapper wrapper, String materialName, String checkDate) {
        List<RegionRefVO> list = ((CtPlanMapper)this.baseMapper).getRegionRef1(page, wrapper, materialName, checkDate);
        return list;
    }

    @Override
    public List<RegionRefVO> getRegionRef2(Page<RegionRefVO> page, QueryWrapper wrapper, String materialName, String checkDate) {
        List<RegionRefVO> list = ((CtPlanMapper)this.baseMapper).getRegionRef2(page, wrapper, materialName, checkDate);
        return list;
    }

    @Override
    public List<BrandRefVO> getBrandRef1(Page<BrandRefVO> page, QueryWrapper wrapper, String materialName, String region, String checkDate) {
        List<BrandRefVO> list = ((CtPlanMapper)this.baseMapper).getBrandRef1(page, wrapper, materialName, region, checkDate);
        return list;
    }

    @Override
    public List<BrandRefVO> getBrandRef2(Page<BrandRefVO> page, QueryWrapper wrapper, String materialName, String region, String checkDate) {
        List<BrandRefVO> list = ((CtPlanMapper)this.baseMapper).getBrandRef2(page, wrapper, materialName, region, checkDate);
        return list;
    }

    @Override
    public BigDecimal getRecomPrice1(String region, String brand, String materialName, String checkDate) {
        BigDecimal price = ((CtPlanMapper)this.baseMapper).getRecomPrice1(region, brand, materialName, checkDate);
        return price;
    }

    @Override
    public BigDecimal getRecomPrice2(String region, String brand, String materialName, String checkDate) {
        BigDecimal price = ((CtPlanMapper)this.baseMapper).getRecomPrice2(region, brand, materialName, checkDate);
        return price;
    }

    @Override
    public List<MarketPriceVO> getMarketPrice1(String region, String brand, String materialName, String checkDate) {
        List<MarketPriceVO> priceList = ((CtPlanMapper)this.baseMapper).getMarketPrice1(region, brand, materialName, checkDate);
        return priceList;
    }

    @Override
    public List<MarketPriceVO> getMarketPrice2(String region, String brand, String materialName, String checkDate) {
        List<MarketPriceVO> priceList = ((CtPlanMapper)this.baseMapper).getMarketPrice2(region, brand, materialName, checkDate);
        if (priceList == null) {
            String beforeDay = this.getBeforeDay(checkDate);
            priceList = this.getMarketPrice1(region, brand, materialName, beforeDay);
        }
        return priceList;
    }

    private String getBeforeDay(String dateTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateTime);
        }
        catch (ParseException e) {
            this.logger.error("String\u8f6cDate\u65e5\u671f\u5931\u8d25:", (Throwable)e);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        return simpleDateFormat.format(calendar.getTime());
    }

    public int daysBetween(String smdate, String bdate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(sdf.parse(smdate));
        }
        catch (ParseException e) {
            this.logger.error("String\u8f6cDate\u65e5\u671f\u5931\u8d25:", (Throwable)e);
        }
        long time1 = cal.getTimeInMillis();
        try {
            cal.setTime(sdf.parse(bdate));
        }
        catch (ParseException e) {
            this.logger.error("String\u8f6cDate\u65e5\u671f\u5931\u8d25:", (Throwable)e);
        }
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }
}

