package com.ejianc.business.hr.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.bean.BaseUserEntity;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 人力基础人员信息
 * 
 * @author generator
 * 
 */
@Mapper
public interface BaseUserMapper extends BaseCrudMapper<BaseUserEntity> {
    /**
     * 查询所有人员信息
     * @return
     */
    List<UserDataVO> queryAllUserData(Page<UserDataVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);
    /**
     * 根据组织获取性别分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> querySexType(@Param("orgCodes") List<String> orgCodes);
    /**
     * 根据组织获取工龄分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryWorkYearType(@Param("orgCodes") List<String> orgCodes);
    /**
     * 根据组织获取年龄分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryAgeType(@Param("orgCodes") List<String> orgCodes);
    /**
     * 根据组织获取学历分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryEductionType(@Param("orgCodes") List<String> orgCodes);
}
