package com.ejianc.business.hr.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.bean.BaseUserEntity;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 人力基础人员信息
 * 
 * @author generator
 * 
 */
public interface IBaseUserService extends IBaseService<BaseUserEntity> {
    /**
     * 查询所有人员信息
     * @return
     */
    List<UserDataVO> queryAllUserData(Page<UserDataVO> page, QueryWrapper wrapper);

    /**
     * 根据组织过滤查询年龄分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> querySexType(List<String> orgCodes);
    /**
     * 根据组织过滤查询工龄分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryWorkYearType(List<String> orgCodes);
    /**
     * 根据组织获取年龄分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryAgeType(List<String> orgCodes);
    /**
     * 根据组织获取学历分布
     * @param orgCodes
     * @return
     */
    List<TypeVO> queryEductionType(List<String> orgCodes);
}
