package com.ejianc.business.hr.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.bean.BaseUserEntity;
import com.ejianc.business.hr.mapper.BaseUserMapper;
import com.ejianc.business.hr.service.IBaseUserService;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 人力基础人员信息
 * 
 * @author generator
 * 
 */
@Service("baseUserService")
public class BaseUserServiceImpl extends BaseServiceImpl<BaseUserMapper, BaseUserEntity> implements IBaseUserService{

    @Autowired
    private BaseUserMapper baseUserMapper;

    @Override
    public List<UserDataVO> queryAllUserData(Page<UserDataVO> page, QueryWrapper wrapper) {
        return baseUserMapper.queryAllUserData(page,wrapper);
    }
    @Override
    public List<TypeVO> querySexType(List<String> orgCodes) {

        List<TypeVO> typeVOS = baseUserMapper.querySexType(orgCodes);
        for (TypeVO typeVO : typeVOS) {
            if(StrUtil.isNotBlank(typeVO.getType())){
                if(typeVO.getType().equals("1")){
                    typeVO.setType("男");
                }
                if(typeVO.getType().equals("2")){
                    typeVO.setType("女");
                }
            }
        }

        return typeVOS;
    }

    @Override
    public List<TypeVO> queryWorkYearType(List<String> orgCodes) {
        List<TypeVO> typeVOS = baseUserMapper.queryWorkYearType(orgCodes);
        for (TypeVO typeVO : typeVOS) {
            if(StrUtil.isNotBlank(typeVO.getType())){
                switch (typeVO.getType()) {
                    case "1":
                        typeVO.setType("25岁以下");
                        break;
                    case "2":
                        typeVO.setType("25-35岁");
                        break;
                    case "3":
                        typeVO.setType("35-45岁");
                        break;
                    case "4":
                        typeVO.setType("45-55岁");
                        break;
                    case "5":
                        typeVO.setType("55岁以上");
                        break;
                }
            }
        }
        return typeVOS;
    }
    @Override
    public List<TypeVO> queryAgeType(List<String> orgCodes) {
        List<TypeVO> typeVOS = baseUserMapper.queryAgeType(orgCodes);
        for (TypeVO typeVO : typeVOS) {
            if(StrUtil.isNotBlank(typeVO.getType())){
                switch (typeVO.getType()) {
                    case "1":
                        typeVO.setType("25岁以下");
                        break;
                    case "2":
                        typeVO.setType("25-35岁");
                        break;
                    case "3":
                        typeVO.setType("35-45岁");
                        break;
                    case "4":
                        typeVO.setType("45-55岁");
                        break;
                    case "5":
                        typeVO.setType("55岁以上");
                        break;
                }
            }
        }
        return typeVOS;
    }
    @Override
    public List<TypeVO> queryEductionType(List<String> orgCodes) {

        return baseUserMapper.queryEductionType(orgCodes);
    }
}
