package com.ejianc.business.hr.controller;

import com.ejianc.business.hr.service.IBaseUserService;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 人员结构
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("userStruct")
public class UserStructController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBaseUserService service;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description querySexType
     *      年龄分布饼状图;
     * @param param
     */
    @RequestMapping(value = "/querySexType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> querySexType(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if(!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        List<TypeVO> typeVOS = service.querySexType(null);
        return CommonResponse.success("查询列表数据成功！",typeVOS);
    }


    /**
     * @Description querySexType
     *      工龄分布饼状图;
     * @param param
     */
    @RequestMapping(value = "/queryWorkYearType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryWorkYearType(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if(!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }
        List<TypeVO> typeVOS = service.queryWorkYearType(null);
        return CommonResponse.success("查询列表数据成功！",typeVOS);
    }

    /**
     * @Description querySexType
     *      年龄分布饼状图;
     * @param param
     */
    @RequestMapping(value = "/queryAgeType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryAgeType(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if(!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        List<TypeVO> typeVOS = service.queryAgeType(null);
        return CommonResponse.success("查询列表数据成功！",typeVOS);
    }

    /**
     * @Description querySexType
     *      学历分布饼状图;
     * @param param
     */
    @RequestMapping(value = "/queryEductionType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TypeVO>> queryEductionType(@RequestBody QueryParam param) {

        List<OrgVO> orgVOList = null;
        List<String> orgCodes = new ArrayList<>();
        if(!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }

        List<TypeVO> typeVOS = service.queryEductionType(null);
        return CommonResponse.success("查询列表数据成功！",typeVOS);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

}
