package com.ejianc.foundation.analyticdatas.vo;

import java.util.Date;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

public class BusinessDataAnalyticVO extends BaseVO {

	private static final long serialVersionUID = 7105516267615795014L;

	private Long billTypeId; // 单据类型ID

	private String businessName; // 业务名称

	private Long queryTenantId; // 查询租户ID

	private String queryTenantName; // 查询租户名称

	private Integer sequence; // 排序号

	private Long dataCount; // 数据总数

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date lastUpdateTime; // 最后一次更新时间

    @ReferSerialTransfer(referCode="billType")
	public Long getBillTypeId() {
		return billTypeId;
	}

    @ReferDeserialTransfer
	public void setBillTypeId(Long billTypeId) {
		this.billTypeId = billTypeId;
	}

	public String getBusinessName() {
		return businessName;
	}

	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}

	public Long getQueryTenantId() {
		return queryTenantId;
	}

	public void setQueryTenantId(Long queryTenantId) {
		this.queryTenantId = queryTenantId;
	}

	public String getQueryTenantName() {
		return queryTenantName;
	}

	public void setQueryTenantName(String queryTenantName) {
		this.queryTenantName = queryTenantName;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Long getDataCount() {
		return dataCount;
	}

	public void setDataCount(Long dataCount) {
		this.dataCount = dataCount;
	}

	public Date getLastUpdateTime() {
		return lastUpdateTime;
	}

	public void setLastUpdateTime(Date lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

}
