package com.ejianc.foundation.analyticdatas.controller;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.*;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.TenantDataEntity;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillDataService;
import com.ejianc.foundation.analyticdatas.service.ITenantDataService;
import com.ejianc.foundation.analyticdatas.vo.StatisticBillVO;
import com.ejianc.foundation.analyticdatas.bean.StatisticBillDataEntity;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.analyticdatas.bean.StatisticBillEntity;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillService;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletRequest;

@Controller
@RequestMapping("statbill")
public class StatisticBillController implements Serializable {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final long serialVersionUID = 1L;
	
	@Autowired
	private IStatisticBillService statisticBillService;
	@Autowired
	private IStatisticBillDataService statisticBillDataService;
	@Autowired
	private IMdClassApi mdClassApi;
	@Autowired
	private IMdProjectApi mdProjectApi;
	@Autowired
	private EnvironmentTools environmentTools;
	@Autowired
	private ITenantDataService tenantDataService;
	
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<StatisticBillVO> saveOrUpdate(@RequestBody StatisticBillVO saveOrUpdateVO) {
		if(saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) {
			StatisticBillEntity uniqueBean = statisticBillService.getById(saveOrUpdateVO.getId());
			uniqueBean.setRemark(saveOrUpdateVO.getRemark());
			uniqueBean.setSequence(saveOrUpdateVO.getSequence());
			statisticBillService.updateById(uniqueBean);
		}else{
			StatisticBillEntity statisticBillEntity = BeanMapper.map(saveOrUpdateVO,StatisticBillEntity.class);
			QueryParam param = new QueryParam();
			param.getParams().put("billtype_id",new Parameter(QueryParam.EQ,statisticBillEntity.getBilltypeId()));
			if(ListUtil.isNotEmpty(statisticBillService.queryList(param))){
				return CommonResponse.error("该单据已存在！");
			}
			CommonResponse<MdClassVO> classResponse = mdClassApi.queryDetail(saveOrUpdateVO.getMdEntityId());
			if(classResponse.isSuccess()) {
				MdClassVO mdClassVo = classResponse.getData();
				
				CommonResponse<MdProjectVO> projectResponse = mdProjectApi.queryDetail(mdClassVo.getProjectId());
				if(projectResponse.isSuccess()) {
					MdProjectVO projectVo = projectResponse.getData();
					statisticBillEntity.setMdProjectName(projectVo.getProjectName());
					statisticBillEntity.setTableName(mdClassVo.getTableName());
				}
				statisticBillService.save(statisticBillEntity);
			}
		}
		return CommonResponse.success();
	}
	
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<StatisticBillVO>> pageList(@RequestBody QueryParam queryParam) {

		Map<String, String> order = queryParam.getOrderMap();
		order.put("sequence", "asc");
		
		IPage<StatisticBillEntity> pageData = statisticBillService.queryPage(queryParam, false);
		IPage<StatisticBillVO> page = new Page<>();
		page.setRecords(BeanMapper.mapList(pageData.getRecords(),StatisticBillVO.class));
		page.setPages(pageData.getPages());
		page.setTotal(pageData.getTotal());
		page.setCurrent(pageData.getCurrent());
		page.setSize(pageData.getSize());

		return CommonResponse.success(page);
	}
	
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<StatisticBillVO> queryDetail(@RequestParam Long id) {
		StatisticBillEntity statisticBillEntity = statisticBillService.getById(id);
		return CommonResponse.success(BeanMapper.map(statisticBillEntity,StatisticBillVO.class));
	}
	
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		 statisticBillService.removeByIds(ids);
		 return CommonResponse.success();
	}

	/**
	 * 同步统计每个租户制单数量
	 * */
	@RequestMapping(value = "sync",method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> sync(HttpServletRequest request){
		logger.info("同步单据数据开始---------");
		Map<String, String> header = new HashMap<>();
		header.put("authority", request.getHeader("authority"));
		QueryParam param = new QueryParam();
		List<StatisticBillEntity> billEntities = statisticBillService.queryList(param);
		Calendar calendar = Calendar.getInstance();
		// 将日期减一天
		calendar.add(Calendar.DATE, -1);
		String today = DateFormatUtil.formatDate("yyyy-MM-dd",calendar.getTime());
		if(ListUtil.isNotEmpty(billEntities)){
			for (StatisticBillEntity billEntity : billEntities) {
				String baseHost = environmentTools.getBaseHost(InvocationInfoProxy.getTenantid());
				Map<String,String> mapParam = new HashMap<>();
				mapParam.put("tableName",billEntity.getTableName());
				try {
					String billTenantInfoResp = ReferHttpClientUtils.get(baseHost+billEntity.getMdProjectName()+"/common/billTenant/queryTenantTotalBill", mapParam, header);
					logger.info(billTenantInfoResp);
					CommonResponse<JSONArray> response = JSONObject.parseObject(billTenantInfoResp, CommonResponse.class);
					if (response!=null && response.isSuccess() && response.getData()!=null &&response.getData().size()>0) {
						JSONArray array = response.getData();
						for (Object o : array) {
							StatisticBillDataEntity billDataEntity = JSONObject.parseObject(JSONObject.toJSONString(o),StatisticBillDataEntity.class);
							billDataEntity.setStatisticTime(today);
							billDataEntity.setStatisticName(billEntity.getBillName());
							billDataEntity.setStatisticId(billEntity.getId());
							TenantDataEntity tenantDataEntity =  tenantDataService.selectByTenantId(billDataEntity.getStatisticTenantId());
							if(tenantDataEntity != null ){
								billDataEntity.setStatisticTenantName(tenantDataEntity.getTenantName());
							}
							if(Objects.equals(billDataEntity.getStatisticTenantId(),999999L)){
								billDataEntity.setStatisticTenantName("北京益企联科技有限公司");
							}
							if(billDataEntity.getStatisticTenantId()!=null && tenantDataEntity != null && Objects.equals(tenantDataEntity.getState(),1)){
								statisticBillDataService.saveOrUpdateNoES(billDataEntity);
							}
						}
					}else {
						logger.error("请求出错，该工程后端应该未构建发布！"+billTenantInfoResp);
					}
				} catch (GeneralSecurityException | IOException e) {
					e.printStackTrace();
					logger.error("同步出错----"+e.getMessage());
				}
			}
		}
		return CommonResponse.success("同步成功");
	}
	
}
