package com.ejianc.foundation.analyticdatas.mapper;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.foundation.analyticdatas.bean.BehaviorDataAnalyticEntity;
import com.ejianc.foundation.analyticdatas.vo.BehaviorDataAnalyticVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@Mapper
public interface BehaviorDataAnalyticMapper extends BaseCrudMapper<BehaviorDataAnalyticEntity> {

    public List<BehaviorDataAnalyticVO> queryProvinceMapData();
    
    public List<BehaviorDataAnalyticVO> queryCityMapData(String provinceName);

	public long countCountRankPage(Map<String, Object> param);

	public List<BehaviorDataAnalyticVO> queryCountRankPage(Map<String, Object> param);

	@Select(" SELECT DISTINCT b.company_name  FROM `ejc_analyticdatas_behaviordata` b WHERE b.app_name = #{appName} ")
	List<String> queryComNameByAppName(@Param("appName") String appName);

	@Select(" SELECT d.app_name appName, COUNT(d.app_name) c FROM ejc_analyticdatas_behaviordata d WHERE " +
			" d.company_name = #{comName} GROUP BY d.app_name ORDER BY c DESC LIMIT 3 ")
	List<JSONObject> queryAppNameByComName(@Param("comName") String comName);

}
