package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.service.IAppAuthService;
import com.ejianc.business.cefoc.asip.bean.AppAuthEntity;
import com.ejianc.business.cefoc.asip.vo.AppAuthVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 应用鉴权
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("appAuth")
public class AppAuthController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAppAuthService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AppAuthVO> saveOrUpdate(@RequestBody AppAuthVO saveOrUpdateVO) {
        AppAuthVO vo =  service.saveData(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppAuthVO> queryDetail(Long id) {
        AppAuthVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AppAuthVO> vos) {
        service.removeByIds(vos.stream().map(AppAuthVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    @RequestMapping(value = "/verifyToken", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> verifyToken(@RequestBody AppAuthVO vo) {
        JSONObject josn = service.verifyToken(vo);
        return CommonResponse.success(josn);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AppAuthVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<AppAuthEntity> page = service.queryPage(param,false);
        IPage<AppAuthVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppAuthVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryDetailByAppId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AppAuthVO> queryDetailByAppId(@RequestParam Long appId, @RequestParam String type) {

        AppAuthVO data = service.queryDetailByAppId(appId,type);
        return CommonResponse.success("查询数据成功！",data);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAppAuthData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AppAuthVO>> refAppAuthData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AppAuthEntity> page = service.queryPage(param,false);
        IPage<AppAuthVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AppAuthVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
