package com.ejianc.business.cefoc.asip.service.impl;

import com.ejianc.business.cefoc.asip.bean.AppResourceConnectEntity;
import com.ejianc.business.cefoc.asip.mapper.AppResourceConnectMapper;
import com.ejianc.business.cefoc.asip.service.IAppResourceConnectService;
import com.ejianc.business.cefoc.asip.utils.JdbcDataProvider;
import com.ejianc.business.cefoc.asip.vo.AppResourceConnectVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 应用资源-连接
 * 
 * @author generator
 * 
 */
@Service("appResourceConnectService")
public class AppResourceConnectServiceImpl extends BaseServiceImpl<AppResourceConnectMapper, AppResourceConnectEntity> implements IAppResourceConnectService{

    @Override
    public CommonResponse<String> testConnect(AppResourceConnectVO vo) {
        JdbcDataProvider jdbcDataProvider = JdbcDataProvider.getInstance();
        Map<String, String> dataSourceMap = jdbcDataProvider.bulidDataSource(BeanMapper.map(vo, AppResourceConnectEntity.class));
        try {
            jdbcDataProvider.assignVal(dataSourceMap, null);
            boolean result = jdbcDataProvider.testConnection();
            if(result){
                return CommonResponse.success("测试连接成功");
            }else{
                return CommonResponse.error("连接失败");
            }
        } catch (Exception e) {
            throw new BusinessException("连接失败");
        }
    }
}
