/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppEntity;
import com.ejianc.business.cefoc.asip.bean.AppInterfaceEntity;
import com.ejianc.business.cefoc.asip.bean.AppReqEntity;
import com.ejianc.business.cefoc.asip.bean.AppResourceConnectEntity;
import com.ejianc.business.cefoc.asip.bean.AppRespEntity;
import com.ejianc.business.cefoc.asip.bean.WaitApplyEntity;
import com.ejianc.business.cefoc.asip.mapper.AppInterfaceMapper;
import com.ejianc.business.cefoc.asip.service.IAppInterfaceService;
import com.ejianc.business.cefoc.asip.service.IAppResourceConnectService;
import com.ejianc.business.cefoc.asip.service.IAppService;
import com.ejianc.business.cefoc.asip.service.IWaitApplyService;
import com.ejianc.business.cefoc.asip.utils.JdbcDataProvider;
import com.ejianc.business.cefoc.asip.vo.AppInterfaceVO;
import com.ejianc.business.cefoc.asip.vo.AppReqVO;
import com.ejianc.business.cefoc.asip.vo.AppRespVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="appInterfaceService")
public class AppInterfaceServiceImpl
extends BaseServiceImpl<AppInterfaceMapper, AppInterfaceEntity>
implements IAppInterfaceService {
    @Autowired
    private IWaitApplyService waitApplyService;
    @Autowired
    private IAppService appService;
    @Autowired
    private IAppResourceConnectService appResourceConnectService;
    @Autowired
    private EnvironmentTools environmentTools;

    @Override
    public AppInterfaceVO saveData(AppInterfaceVO saveOrUpdateVO) {
        List<BaseEntity> paramList;
        AppInterfaceEntity entity = (AppInterfaceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AppInterfaceEntity.class));
        if (entity.getId() != null) {
            AppInterfaceEntity old = (AppInterfaceEntity)((Object)this.selectById(entity.getId()));
            entity.setCreateTime(old.getCreateTime());
            entity.setCreateUserCode(old.getCreateUserCode());
            entity.setTenantId(old.getTenantId());
            entity.setVersion(old.getVersion());
        } else {
            entity = (AppInterfaceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AppInterfaceEntity.class));
        }
        QueryParam queryParam = QueryParam.getInstance();
        queryParam.getParams().put("interfaceIdentification", new Parameter("eq", (Object)entity.getInterfaceIdentification()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        List appInterfaceList = this.queryList(queryParam, false);
        if (!ListUtil.isEmpty((List)appInterfaceList)) {
            throw new BusinessException("\u63a5\u53e3\u6807\u8bc6\u5df2\u5b58\u5728,\u8bf7\u66f4\u6539\u63a5\u53e3\u6807\u8bc6\uff01");
        }
        List<AppReqEntity> appReqList = new ArrayList<AppReqEntity>();
        if (saveOrUpdateVO.getHeaderReqList() != null && saveOrUpdateVO.getHeaderReqList().size() > 0) {
            appReqList = BeanMapper.mapList((Iterable)saveOrUpdateVO.getHeaderReqList(), AppReqEntity.class);
        }
        if (saveOrUpdateVO.getBodyReqList() != null && saveOrUpdateVO.getBodyReqList().size() > 0) {
            paramList = new ArrayList<AppReqEntity>();
            paramList = this.dealChildren1(saveOrUpdateVO.getBodyReqList(), paramList, null, "body");
            appReqList.addAll(paramList);
        }
        if (saveOrUpdateVO.getUrlParamReqList() != null && saveOrUpdateVO.getUrlParamReqList().size() > 0) {
            appReqList.addAll(BeanMapper.mapList((Iterable)saveOrUpdateVO.getUrlParamReqList(), AppReqEntity.class));
        }
        entity.setAppReqList(appReqList);
        if (saveOrUpdateVO.getAppRespList() != null && saveOrUpdateVO.getAppRespList().size() > 0) {
            paramList = new ArrayList();
            paramList = this.dealChildren2(saveOrUpdateVO.getAppRespList(), paramList, null, "body");
            entity.setAppRespList(paramList);
        }
        this.saveOrUpdate((Object)entity, false);
        AppInterfaceVO vo = (AppInterfaceVO)BeanMapper.map((Object)((Object)entity), AppInterfaceVO.class);
        return null;
    }

    private List<AppReqEntity> dealChildren1(List<AppReqVO> children, List<AppReqEntity> paramList, Long pid, String type) {
        for (AppReqVO param : children) {
            param.setPid(pid);
            if ("add".equals(param.getRowState())) {
                param.setId(Long.valueOf(IdWorker.getId()));
            }
            if (param.getChildren() != null && param.getChildren().size() > 0) {
                paramList = this.dealChildren1(param.getChildren(), paramList, param.getId(), type);
            }
            AppReqEntity en = (AppReqEntity)((Object)BeanMapper.map((Object)param, AppReqEntity.class));
            en.setType(type);
            paramList.add(en);
        }
        return paramList;
    }

    private List<AppReqVO> createTreeData1(List<AppReqVO> list) {
        ArrayList<AppReqVO> resp = new ArrayList<AppReqVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, AppReqVO> listMap = new HashMap<String, AppReqVO>();
        for (AppReqVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            AppReqVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            AppReqVO parent = (AppReqVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<AppReqVO> children = new ArrayList<AppReqVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((AppReqVO)listMap.get(rootId));
        }
        return resp;
    }

    private List<AppRespEntity> dealChildren2(List<AppRespVO> children, List<AppRespEntity> paramList, Long pid, String type) {
        for (AppRespVO param : children) {
            param.setPid(pid);
            if ("add".equals(param.getRowState())) {
                param.setId(Long.valueOf(IdWorker.getId()));
            }
            if (param.getChildren() != null && param.getChildren().size() > 0) {
                paramList = this.dealChildren2(param.getChildren(), paramList, param.getId(), type);
            }
            AppRespEntity en = (AppRespEntity)((Object)BeanMapper.map((Object)param, AppRespEntity.class));
            en.setType(type);
            paramList.add(en);
        }
        return paramList;
    }

    private List<AppRespVO> createTreeData2(List<AppRespVO> list) {
        ArrayList<AppRespVO> resp = new ArrayList<AppRespVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, AppRespVO> listMap = new HashMap<String, AppRespVO>();
        for (AppRespVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            AppRespVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            AppRespVO parent = (AppRespVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<AppRespVO> children = new ArrayList<AppRespVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((AppRespVO)listMap.get(rootId));
        }
        return resp;
    }

    @Override
    public AppInterfaceVO queryDetail(Long id) {
        AppInterfaceVO vo = null;
        AppInterfaceEntity entity = (AppInterfaceEntity)((Object)this.selectById(id));
        if (entity != null) {
            vo = (AppInterfaceVO)BeanMapper.map((Object)((Object)entity), AppInterfaceVO.class);
            ArrayList<Object> headerReqList = new ArrayList<Object>();
            ArrayList<AppReqVO> bodyReqList = new ArrayList<AppReqVO>();
            ArrayList<Object> urlParamReqList = new ArrayList<Object>();
            List<AppReqEntity> reqList = entity.getAppReqList();
            if (reqList != null && reqList.size() > 0) {
                for (AppReqEntity item : reqList) {
                    if ("header".equals(item.getType())) {
                        headerReqList.add(BeanMapper.map((Object)((Object)item), AppReqVO.class));
                        continue;
                    }
                    if ("body".equals(item.getType())) {
                        bodyReqList.add((AppReqVO)BeanMapper.map((Object)((Object)item), AppReqVO.class));
                        continue;
                    }
                    if (!"urlParam".equals(item.getType())) continue;
                    urlParamReqList.add(BeanMapper.map((Object)((Object)item), AppReqVO.class));
                }
            }
            vo.setHeaderReqList(headerReqList);
            List<AppReqVO> detailVOS = this.createTreeData1(bodyReqList);
            vo.setBodyReqList(detailVOS);
            vo.setUrlParamReqList(urlParamReqList);
            List<AppRespVO> appRespList = this.createTreeData2(vo.getAppRespList());
            vo.setAppRespList(appRespList);
        }
        return vo;
    }

    @Override
    public AppInterfaceVO queryById(Long id) {
        AppEntity app;
        AppInterfaceVO vo = this.queryDetail(id);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"user_id", (Object)InvocationInfoProxy.getUserid());
        wrapper.eq((Object)"interface_id", (Object)id);
        List waitList = this.waitApplyService.list((Wrapper)wrapper);
        if (waitList != null && waitList.size() > 0) {
            vo.setWait(Boolean.valueOf(true));
        }
        if ((app = (AppEntity)((Object)this.appService.selectById(vo.getAppId()))) != null && StringUtils.isNotBlank((CharSequence)app.getAppIconSrc())) {
            String appIconSrc = this.environmentTools.getBaseHost() + app.getAppIconSrc();
            vo.setAppIconSrc(appIconSrc);
        }
        return vo;
    }

    @Override
    public void testSql(Long id) {
        AppInterfaceEntity appInterface = (AppInterfaceEntity)((Object)this.selectById(id));
        AppResourceConnectEntity uniqueBean = (AppResourceConnectEntity)((Object)this.appResourceConnectService.getById(appInterface.getSqlDataSourceId()));
        HashMap<String, String> dataSourceMap = new HashMap<String, String>();
        dataSourceMap.put("driver", "com.mysql.jdbc.Driver");
        dataSourceMap.put("jdbcurl", "jdbc:mysql://" + uniqueBean.getDatabaseHost() + ":" + uniqueBean.getDatabasePort() + "/" + uniqueBean.getDatabaseName() + "?useUnicode=true&characterEncoding=utf-8&autoReconnect=true&failOverReadOnly=false&useSSL=false");
        dataSourceMap.put("username", uniqueBean.getDatabaseUser());
        dataSourceMap.put("password", uniqueBean.getDatabasePassword());
        dataSourceMap.put("pooled", "false");
        JSONObject params = new JSONObject();
        params.put("tenantId", (Object)InvocationInfoProxy.getTenantid());
        params.put("parentId", (Object)1286210139836182530L);
        String sql = appInterface.getSqlData();
        List<String> paramList = this.getVariables(sql);
        HashMap paramMap = new HashMap();
        if (paramList != null && paramList.size() > 0) {
            for (String p : paramList) {
                sql = sql.replace("${" + p + "}", params.get((Object)p).toString());
            }
        }
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("sql", sql);
        JdbcDataProvider jdbcDataProvider = JdbcDataProvider.getInstance();
        try {
            jdbcDataProvider.assignVal(dataSourceMap, query);
            List<JSONObject> data = jdbcDataProvider.getDataList();
            System.out.println(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getVariables(String str) {
        ArrayList<String> variables = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        return variables;
    }

    @Override
    public IPage<AppInterfaceVO> queryMarketInterfaceList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("interfaceName");
        fuzzyFields.add("interfaceAddress");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AppInterfaceVO.class));
        if (pageData.getRecords() != null && pageData.getRecords().size() > 0) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"user_id", (Object)InvocationInfoProxy.getUserid());
            List waitList = this.waitApplyService.list((Wrapper)wrapper);
            HashMap<Long, Object> mapWait = new HashMap<Long, Object>();
            if (waitList != null && waitList.size() > 0) {
                for (Object cefocAsipWaitApplyEntity : waitList) {
                    mapWait.put(((WaitApplyEntity)((Object)cefocAsipWaitApplyEntity)).getInterfaceId(), cefocAsipWaitApplyEntity);
                }
            }
            ArrayList<Long> appIds = new ArrayList<Long>();
            for (AppInterfaceVO record : pageData.getRecords()) {
                if (appIds.contains(record.getAppId())) continue;
                appIds.add(record.getAppId());
            }
            List appList = (List)this.appService.listByIds(appIds);
            HashMap<Long, AppEntity> mapApp = new HashMap<Long, AppEntity>();
            if (appList != null && appList.size() > 0) {
                for (AppEntity app : appList) {
                    mapApp.put(app.getId(), app);
                }
            }
            for (AppInterfaceVO record : pageData.getRecords()) {
                if (mapWait.get(record.getId()) != null) {
                    record.setWait(Boolean.valueOf(true));
                } else {
                    record.setWait(Boolean.valueOf(false));
                }
                if (mapApp.get(record.getAppId()) == null || !StringUtils.isNotBlank((CharSequence)((AppEntity)((Object)mapApp.get(record.getAppId()))).getAppIconSrc())) continue;
                String appIconSrc = this.environmentTools.getBaseHost() + ((AppEntity)((Object)mapApp.get(record.getAppId()))).getAppIconSrc();
                record.setAppIconSrc(appIconSrc);
            }
        }
        return pageData;
    }
}

