/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.cefoc.asip.utils.NaturalOrderComparator;
import com.ejianc.business.cefoc.asip.utils.sql.config.AggConfig;
import com.ejianc.business.cefoc.asip.utils.sql.config.CompositeConfig;
import com.ejianc.business.cefoc.asip.utils.sql.config.ConfigComponent;
import com.ejianc.business.cefoc.asip.utils.sql.config.DimensionConfig;
import com.ejianc.business.cefoc.asip.utils.sql.dataprovider.Aggregatable;
import com.ejianc.business.cefoc.asip.utils.sql.dataprovider.InnerAggregator;
import com.ejianc.business.cefoc.asip.utils.sql.expression.NowFunction;
import com.ejianc.business.cefoc.asip.utils.sql.result.AggregateResult;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataProvider {
    private InnerAggregator innerAggregator;
    protected Map<String, String> dataSource;
    protected Map<String, String> query;
    private int resultLimit;
    private boolean isUsedForTest = false;
    private long interval = 43200L;
    public static final String NULL_STRING = "#NULL";
    private static final Logger logger = LoggerFactory.getLogger(DataProvider.class);

    public abstract boolean doAggregationInDataSource();

    public boolean isDataSourceAggInstance() {
        return this instanceof Aggregatable && this.doAggregationInDataSource();
    }

    public final AggregateResult getAggData(AggConfig ac, boolean reload) throws Exception {
        this.evalValueExpression(ac);
        if (this.isDataSourceAggInstance()) {
            return ((Aggregatable)((Object)this)).queryAggData(ac);
        }
        this.checkAndLoad(reload);
        return this.innerAggregator.queryAggData(ac);
    }

    public final String getViewAggDataQuery(AggConfig config) throws Exception {
        this.evalValueExpression(config);
        if (this.isDataSourceAggInstance()) {
            return ((Aggregatable)((Object)this)).viewAggDataQuery(config);
        }
        return "Not Support";
    }

    public final String[] getDimVals(String columnName, AggConfig config, boolean reload) throws Exception {
        String[] dimVals = null;
        this.evalValueExpression(config);
        if (this.isDataSourceAggInstance()) {
            dimVals = ((Aggregatable)((Object)this)).queryDimVals(columnName, config);
        } else {
            this.checkAndLoad(reload);
            dimVals = this.innerAggregator.queryDimVals(columnName, config);
        }
        return (String[])Arrays.stream(dimVals).map(member -> Objects.isNull(member) ? NULL_STRING : member).sorted(new NaturalOrderComparator()).limit(1000L).toArray(String[]::new);
    }

    public final String[] invokeGetColumn(boolean reload) throws Exception {
        Object[] columns = null;
        if (this.isDataSourceAggInstance()) {
            columns = ((Aggregatable)((Object)this)).getColumn(reload);
        } else {
            this.checkAndLoad(reload);
            columns = this.innerAggregator.getColumn(reload);
        }
        Arrays.sort(columns);
        return columns;
    }

    public final Map<String, String> invokeGetSelectColumn(boolean reload) throws Exception {
        Map<String, String> columns = null;
        if (this.isDataSourceAggInstance()) {
            columns = ((Aggregatable)((Object)this)).getSelectColumn(reload);
        } else {
            this.checkAndLoad(reload);
            columns = this.innerAggregator.getSelectColumn(reload);
        }
        LinkedHashMap<String, String> finalMap = new LinkedHashMap<String, String>();
        columns.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
            String cfr_ignored_0 = (String)finalMap.put((String)e.getKey(), (String)e.getValue());
        });
        return finalMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndLoad(boolean reload) throws Exception {
        String key = this.getLockKey();
        String string = key.intern();
        synchronized (string) {
            if (reload || !this.innerAggregator.checkExist()) {
                String[][] data = this.getData();
                if (data != null) {
                    this.innerAggregator.loadData(data, this.interval);
                }
                logger.info("loadData {}", (Object)key);
            }
        }
    }

    private void evalValueExpression(AggConfig ac) {
        if (ac == null) {
            return;
        }
        ac.getFilters().forEach(e -> this.evaluator((ConfigComponent)e));
        ac.getColumns().forEach(e -> this.evaluator((ConfigComponent)e));
        ac.getRows().forEach(e -> this.evaluator((ConfigComponent)e));
    }

    private void evaluator(ConfigComponent e) {
        if (e instanceof DimensionConfig) {
            DimensionConfig dc = (DimensionConfig)e;
            dc.setValues(dc.getValues().stream().flatMap(v -> this.getFilterValue((String)v)).collect(Collectors.toList()));
        }
        if (e instanceof CompositeConfig) {
            CompositeConfig cc = (CompositeConfig)e;
            cc.getConfigComponents().forEach(_e -> this.evaluator((ConfigComponent)_e));
        }
    }

    private Stream<String> getFilterValue(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value == null || !value.startsWith("{") || !value.endsWith("}")) {
            list.add(value);
        } else if (!("{loginName}".equals(value) || "{userName}".equals(value) || "{userRoles}".equals(value) || "{curOrg}".equals(value) || "{curSubOrg}".equals(value) || "{curSubParOrg}".equals(value))) {
            list.add(AviatorEvaluator.compile((String)value.substring(1, value.length() - 1), (boolean)true).execute().toString());
        }
        return list.stream();
    }

    public String getLockKey() {
        String dataSourceStr = JSONObject.toJSON(this.dataSource).toString();
        String queryStr = JSONObject.toJSON(this.query).toString();
        return Hashing.md5().newHasher().putString((CharSequence)(dataSourceStr + queryStr), Charsets.UTF_8).hash().toString();
    }

    public List<DimensionConfig> filterCCList2DCList(List<ConfigComponent> filters) {
        LinkedList<DimensionConfig> result = new LinkedList<DimensionConfig>();
        filters.stream().forEach(cc -> result.addAll(this.configComp2DimConfigList((ConfigComponent)cc)));
        return result;
    }

    public List<DimensionConfig> configComp2DimConfigList(ConfigComponent cc) {
        LinkedList<DimensionConfig> result = new LinkedList<DimensionConfig>();
        if (cc instanceof DimensionConfig) {
            result.add((DimensionConfig)cc);
        } else {
            Iterator<ConfigComponent> iterator = cc.getIterator();
            while (iterator.hasNext()) {
                ConfigComponent next = iterator.next();
                result.addAll(this.configComp2DimConfigList(next));
            }
        }
        return result;
    }

    public abstract String[][] getData() throws Exception;

    public void test() throws Exception {
        this.getData();
    }

    public void setDataSource(Map<String, String> dataSource) {
        this.dataSource = dataSource;
    }

    public void setQuery(Map<String, String> query) {
        this.query = query;
    }

    public void setResultLimit(int resultLimit) {
        this.resultLimit = resultLimit;
    }

    public int getResultLimit() {
        return this.resultLimit;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public InnerAggregator getInnerAggregator() {
        return this.innerAggregator;
    }

    public void setInnerAggregator(InnerAggregator innerAggregator) {
        this.innerAggregator = innerAggregator;
    }

    public boolean isUsedForTest() {
        return this.isUsedForTest;
    }

    public void setUsedForTest(boolean usedForTest) {
        this.isUsedForTest = usedForTest;
    }

    public static ConfigComponent separateNull(ConfigComponent configComponent) {
        DimensionConfig cc;
        if (configComponent instanceof DimensionConfig && ("=".equals((cc = (DimensionConfig)configComponent).getFilterType()) || "\u2260".equals(cc.getFilterType())) && cc.getValues().size() > 1 && cc.getValues().stream().anyMatch(s -> NULL_STRING.equals(s))) {
            CompositeConfig compositeConfig = new CompositeConfig();
            compositeConfig.setType("=".equals(cc.getFilterType()) ? "OR" : "AND");
            cc.setValues(cc.getValues().stream().filter(s -> !NULL_STRING.equals(s)).collect(Collectors.toList()));
            compositeConfig.getConfigComponents().add(cc);
            DimensionConfig nullCc = new DimensionConfig();
            nullCc.setColumnName(cc.getColumnName());
            nullCc.setFilterType(cc.getFilterType());
            nullCc.setValues(new ArrayList<String>());
            nullCc.getValues().add(NULL_STRING);
            compositeConfig.getConfigComponents().add(nullCc);
            return compositeConfig;
        }
        return configComponent;
    }

    static {
        AviatorEvaluator.addFunction((AviatorFunction)new NowFunction());
    }
}

