/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cefoc.asip.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cefoc.asip.bean.AppResourceDataStructureParamEntity;
import com.ejianc.business.cefoc.asip.service.IAppResourceDataStructureParamService;
import com.ejianc.business.cefoc.asip.vo.AppResourceDataStructureParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"appResourceDataStructureParam"})
public class AppResourceDataStructureParamController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAppResourceDataStructureParamService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AppResourceDataStructureParamVO> saveOrUpdate(@RequestBody AppResourceDataStructureParamVO saveOrUpdateVO) {
        AppResourceDataStructureParamEntity entity = (AppResourceDataStructureParamEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AppResourceDataStructureParamEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        AppResourceDataStructureParamVO vo = (AppResourceDataStructureParamVO)BeanMapper.map((Object)((Object)entity), AppResourceDataStructureParamVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AppResourceDataStructureParamVO> queryDetail(Long id) {
        AppResourceDataStructureParamEntity entity = (AppResourceDataStructureParamEntity)((Object)this.service.selectById(id));
        AppResourceDataStructureParamVO vo = (AppResourceDataStructureParamVO)BeanMapper.map((Object)((Object)entity), AppResourceDataStructureParamVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AppResourceDataStructureParamVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<AppResourceDataStructureParamVO>> queryList(Long dataStructureId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dataStructureId", new Parameter("eq", (Object)dataStructureId));
        List records = this.service.queryList(param, false);
        List<AppResourceDataStructureParamVO> list = BeanMapper.mapList((Iterable)records, AppResourceDataStructureParamVO.class);
        list = this.createTreeData(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", list);
    }

    private List<AppResourceDataStructureParamVO> createTreeData(List<AppResourceDataStructureParamVO> list) {
        ArrayList<AppResourceDataStructureParamVO> resp = new ArrayList<AppResourceDataStructureParamVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, AppResourceDataStructureParamVO> listMap = new HashMap<String, AppResourceDataStructureParamVO>();
        for (AppResourceDataStructureParamVO item : list) {
            listMap.put(item.getId().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            AppResourceDataStructureParamVO item;
            item = list.get(i);
            String parentId = item.getPid() != null ? item.getPid().toString() : "";
            AppResourceDataStructureParamVO parent = (AppResourceDataStructureParamVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<AppResourceDataStructureParamVO> children = new ArrayList<AppResourceDataStructureParamVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((AppResourceDataStructureParamVO)listMap.get(rootId));
        }
        return resp;
    }

    @RequestMapping(value={"/refAppResourceDataStructureParamData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AppResourceDataStructureParamVO>> refAppResourceDataStructureParamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AppResourceDataStructureParamVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

