package com.ejianc.business.assist.ownrmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.assist.ownrmat.vo.OwnDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 自有材料摊销
 * 
 * @author generator
 * 
 */
public class OwnVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long orgId; // 摊销单位
    private String orgCode; // 摊销单位编码
    private String orgName; // 摊销单位名称
    private String amortizationCycle; // 摊销周期
    private BigDecimal amortizationMnyTax; // 摊销金额(含税)
    private BigDecimal amortizationMny; // 摊销金额(无税)
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date processingDate; // 办理日期
    private String memo; // 备注
    private String categoryName; // 材料分类名称
    private Integer billState; // 单据状态
    private Integer amortizationMethod; // 摊销方法,0-年平均法，1-录入
    private String lastDate; // 上次摊销周期
    private String billStateName;
    private Date effectTime; // 单据生效时间
    
    private List<OwnDetailVO> ownDetailList = new ArrayList<>(); // 自有材料摊销-清单


    public Date getEffectTime() {
        return effectTime;
    }

    public void setEffectTime(Date effectTime) {
        this.effectTime = effectTime;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getLastDate() {
        return lastDate;
    }

    public void setLastDate(String lastDate) {
        this.lastDate = lastDate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getAmortizationCycle() {
        return amortizationCycle;
    }

    public void setAmortizationCycle(String amortizationCycle) {
        this.amortizationCycle = amortizationCycle;
    }
    public BigDecimal getAmortizationMnyTax() {
        return amortizationMnyTax;
    }

    public void setAmortizationMnyTax(BigDecimal amortizationMnyTax) {
        this.amortizationMnyTax = amortizationMnyTax;
    }
    public BigDecimal getAmortizationMny() {
        return amortizationMny;
    }

    public void setAmortizationMny(BigDecimal amortizationMny) {
        this.amortizationMny = amortizationMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Date getProcessingDate() {
        return processingDate;
    }

    public void setProcessingDate(Date processingDate) {
        this.processingDate = processingDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getAmortizationMethod() {
        return amortizationMethod;
    }

    public void setAmortizationMethod(Integer amortizationMethod) {
        this.amortizationMethod = amortizationMethod;
    }
    
     public List<OwnDetailVO> getOwnDetailList() {
        return ownDetailList;
     }

     public void setOwnDetailList(List<OwnDetailVO> ownDetailList) {
        this.ownDetailList = ownDetailList;
     }
}
