package com.ejianc.business.assist.rmat.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 周转材租赁合同-日租明细变更表
 *
 * @author generator
 */
public class ChangeDailyRentVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long changeId; // 变更主键
    private String changeType; // 变更类型
    private Long contractId; // 合同id
    private Long sourceId; // 来源数据Id(参照数据id)
    private Long sourceBid; // 来源子表主键(合同子表id)
    private String sourceType; // 来源类型：0-定标结果带入，1-总计划，2-材料档案，3-批次计划
    private Long materialTypeId; // 物资材料分类Id
    private String materialTypeName; // 物资材料分类名称
    private String materialName; // 材料名称
    private String spec; // 规则/型号
    private BigDecimal count; // 数量
    private BigDecimal unitPrice; // 单价(无税)
    private BigDecimal unitTaxPrice; // 单价
    private BigDecimal taxRate; // 税率
    private BigDecimal tax; // 税额
    private BigDecimal stopUnitPrice; // 停租单价(无税)
    private BigDecimal stopUnitTaxPrice; // 停租单价
    private BigDecimal loseUnitPrice; // 遗失单价(无税)
    private BigDecimal loseUnitTaxPrice; // 遗失单价
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 计划进场时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 计划出场时间
    private String memo; // 备注
    private Long materialId; // 材料id
    private String materialCode; // 材料编码
    private Long unitId; // 计租单位id
    private String unitName; // 计租单位名称

    private BigDecimal surplusCount; // 剩余数量
    private BigDecimal bcCount; // 变更前数量
    private BigDecimal bcUnitTaxPrice; // 变更前单价
    private BigDecimal bcStopUnitTaxPrice; // 变更前停租单价
    private BigDecimal bcLoseUnitTaxPrice; // 变更前遗失单价
    private BigDecimal bcTaxRate; // 变更前税率
    private Date bcStartDate; // 变更前计划进场时间
    private Date bcEndDate; // 变更前计划出场时间
    private String bcMemo; // 变更前备注
    private String bcUnitName; // 变更前计租单位

    private Long unitMId; // 计量单位id
    private String unitMName; // 计量单位名称
    private String materialTypeCode; // 材料分类编码
    private Integer rowType; // 行分类：0-分类，1-材料
    

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public BigDecimal getCount() {
        return count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getUnitTaxPrice() {
        return unitTaxPrice;
    }

    public void setUnitTaxPrice(BigDecimal unitTaxPrice) {
        this.unitTaxPrice = unitTaxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getStopUnitPrice() {
        return stopUnitPrice;
    }

    public void setStopUnitPrice(BigDecimal stopUnitPrice) {
        this.stopUnitPrice = stopUnitPrice;
    }

    public BigDecimal getStopUnitTaxPrice() {
        return stopUnitTaxPrice;
    }

    public void setStopUnitTaxPrice(BigDecimal stopUnitTaxPrice) {
        this.stopUnitTaxPrice = stopUnitTaxPrice;
    }

    public BigDecimal getLoseUnitPrice() {
        return loseUnitPrice;
    }

    public void setLoseUnitPrice(BigDecimal loseUnitPrice) {
        this.loseUnitPrice = loseUnitPrice;
    }

    public BigDecimal getLoseUnitTaxPrice() {
        return loseUnitTaxPrice;
    }

    public void setLoseUnitTaxPrice(BigDecimal loseUnitTaxPrice) {
        this.loseUnitTaxPrice = loseUnitTaxPrice;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    @ReferSerialTransfer(referCode = "share-unit")
    public Long getUnitId() {
        return unitId;
    }

    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getSurplusCount() {
        return surplusCount;
    }

    public void setSurplusCount(BigDecimal surplusCount) {
        this.surplusCount = surplusCount;
    }

    public BigDecimal getBcCount() {
        return bcCount;
    }

    public void setBcCount(BigDecimal bcCount) {
        this.bcCount = bcCount;
    }

    public BigDecimal getBcUnitTaxPrice() {
        return bcUnitTaxPrice;
    }

    public void setBcUnitTaxPrice(BigDecimal bcUnitTaxPrice) {
        this.bcUnitTaxPrice = bcUnitTaxPrice;
    }

    public BigDecimal getBcStopUnitTaxPrice() {
        return bcStopUnitTaxPrice;
    }

    public void setBcStopUnitTaxPrice(BigDecimal bcStopUnitTaxPrice) {
        this.bcStopUnitTaxPrice = bcStopUnitTaxPrice;
    }

    public BigDecimal getBcLoseUnitTaxPrice() {
        return bcLoseUnitTaxPrice;
    }

    public void setBcLoseUnitTaxPrice(BigDecimal bcLoseUnitTaxPrice) {
        this.bcLoseUnitTaxPrice = bcLoseUnitTaxPrice;
    }

    public BigDecimal getBcTaxRate() {
        return bcTaxRate;
    }

    public void setBcTaxRate(BigDecimal bcTaxRate) {
        this.bcTaxRate = bcTaxRate;
    }

    public Date getBcStartDate() {
        return bcStartDate;
    }

    public void setBcStartDate(Date bcStartDate) {
        this.bcStartDate = bcStartDate;
    }

    public Date getBcEndDate() {
        return bcEndDate;
    }

    public void setBcEndDate(Date bcEndDate) {
        this.bcEndDate = bcEndDate;
    }

    public String getBcMemo() {
        return bcMemo;
    }

    public void setBcMemo(String bcMemo) {
        this.bcMemo = bcMemo;
    }

    public String getBcUnitName() {
        return bcUnitName;
    }

    public void setBcUnitName(String bcUnitName) {
        this.bcUnitName = bcUnitName;
    }

    public Long getUnitMId() {
        return unitMId;
    }

    public void setUnitMId(Long unitMId) {
        this.unitMId = unitMId;
    }

    public String getUnitMName() {
        return unitMName;
    }

    public void setUnitMName(String unitMName) {
        this.unitMName = unitMName;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public Integer getRowType() {
        return rowType;
    }

    public void setRowType(Integer rowType) {
        this.rowType = rowType;
    }
}
