package com.ejianc.business.assist.store.vo;

import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.util.StoreManageUtil;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 调拨出库
 * 
 * @author generator
 * 
 */
public class AllotOutVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private Long projectId; // 出库项目id
    private String projectName; // 出库项目名称
    private Long orgId; // 出库组织id
    private String orgName; // 出库组织名称
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long storeId; // 出库仓库id
    private String storeName; // 出库仓库名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 调出的时间
    private BigDecimal outMny; // 调出金额
    private BigDecimal outTaxMny; // 调出金额
    private Integer allocatType; // 调拨方式 1 资产盘活 2 自制
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门id
    private String departmentName; //  经办人部门
    private Long inProjectId; // 调入项目id
    private String inProjectName; // 调入项目名称
    private Long inParentOrgId; // 调入项目部上级组织Id
    private String inParentOrgName; // 调入项目部上级组织名称
    private String inParentOrgCode; // 调入项目部上级组织编码
    private Long inOrgId; // 调入组织id
    private String inOrgName; // 调入组织名称
    private String materialNames; // 出库物资名称集合
    private Long receiverId; // 通知收料状人id
    private String receiverName; // 通知收料状人
    private String memo; // 备注
    private String returnReason; // 调入组织退回原因
    private Integer receiveState; // 收料状态 1、待收；2、已收；3、退回
    private String receiverPersonId; // 收料人id
    private String receiverPerson; // 收料人
    private Long inStoreId; // 入库id
    private String inStoreName; // 入库名称
    private Date receiveDate; // 收料时间
    private List<AllotOutDetailVO> allotOutDetailList = new ArrayList<>(); // 调拨出库子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode="store-store")
    public Long getStoreId() {
        return storeId;
    }

    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }

    public Integer getAllocatType() {
        return allocatType;
    }

    public void setAllocatType(Integer allocatType) {
        this.allocatType = allocatType;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getInProjectId() {
        return inProjectId;
    }
    @ReferDeserialTransfer
    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }
    public String getInProjectName() {
        return inProjectName;
    }

    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }

    public Long getInParentOrgId() {
        return inParentOrgId;
    }

    public void setInParentOrgId(Long inParentOrgId) {
        this.inParentOrgId = inParentOrgId;
    }

    public String getInParentOrgName() {
        return inParentOrgName;
    }

    public void setInParentOrgName(String inParentOrgName) {
        this.inParentOrgName = inParentOrgName;
    }

    public String getInParentOrgCode() {
        return inParentOrgCode;
    }

    public void setInParentOrgCode(String inParentOrgCode) {
        this.inParentOrgCode = inParentOrgCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getInOrgId() {
        return inOrgId;
    }
    @ReferDeserialTransfer
    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }
    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }
    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getReceiverId() {
        return receiverId;
    }
    @ReferDeserialTransfer
    public void setReceiverId(Long receiverId) {
        this.receiverId = receiverId;
    }
    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }
    public Integer getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }
    
     public List<AllotOutDetailVO> getAllotOutDetailList() {
        return allotOutDetailList;
     }

     public void setAllotOutDetailList(List<AllotOutDetailVO> allotOutDetailList) {
        this.allotOutDetailList = allotOutDetailList;
     }

    public String getReceiverPersonId() {
        return receiverPersonId;
    }

    public void setReceiverPersonId(String receiverPersonId) {
        this.receiverPersonId = receiverPersonId;
    }

    public String getReceiverPerson() {
        return receiverPerson;
    }

    public void setReceiverPerson(String receiverPerson) {
        this.receiverPerson = receiverPerson;
    }

    public Long getInStoreId() {
        return inStoreId;
    }

    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }

    public String getInStoreName() {
        return inStoreName;
    }

    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    public StoreManageVO getStoreManageVO(AllotOutVO vo ){
        StoreManageVO storeManageVO = new StoreManageVO();
       if (vo!=null){
           List<AllotOutDetailVO> allotOutDetailList = vo.getAllotOutDetailList();
           storeManageVO.setStoreId(vo.getStoreId());
           storeManageVO.setSourceId(vo.getId());
           storeManageVO.setInOutTypeEnum(InOutTypeEnum.调拨出库);
           ArrayList<FlowVO> flowVOS = new ArrayList<>();
           vo.getAllotOutDetailList().forEach(t->{
               FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.调拨出库, 0);
               flowVO.setStoreId(vo.getStoreId());
               flowVO.setStoreName(vo.getStoreName());
               flowVO.setProjectId(vo.getProjectId());
               flowVO.setProjectName(vo.getProjectName());
               flowVO.setOrgId(vo.getOrgId());
               flowVO.setOrgName(vo.getOrgName());
               flowVO.setParentOrgId(vo.getParentOrgId());
               flowVO.setParentOrgName(vo.getParentOrgName());
               flowVO.setParentOrgCode(vo.getParentOrgCode());
               flowVO.setEmployeeId(vo.getEmployeeId());
               flowVO.setEmployeeName(vo.getEmployeeName());
               flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
               flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
               flowVO.setMaterialId(t.getMaterialId());
               flowVO.setMaterialName(t.getMaterialName());
               flowVO.setMaterialSpec(t.getMaterialSpec());
               flowVO.setMaterialUnitId(t.getMaterialUnitId());
               flowVO.setMaterialUnitName(t.getMaterialUnit());
               flowVO.setNum(t.getAllocatNum());
               flowVO.setTaxPrice(t.getAllocatTaxPrice());
               flowVO.setPrice(t.getAllocatPrice());
               flowVO.setTax(t.getAllocatTax());
               flowVO.setTaxMny(t.getAllocatTaxMny());
               flowVO.setMny(t.getAllocatMny());
               flowVO.setTaxRate(t.getAllocatTaxRate());
               flowVO.setSourceId(vo.getId());
               flowVO.setSourceDetailId(t.getId());
               flowVO.setSourceBillCode(vo.getBillCode());
               flowVO.setSourceBillDate(vo.getOutDate());
               flowVO.setSourceBillRemark(vo.getMemo());
               flowVO.setRowState(t.getRowState());
               flowVOS.add(flowVO);
           });
           storeManageVO.setFlowVOList(flowVOS);
       }
        return storeManageVO;
    }
}
