package com.ejianc.business.assist.rmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 租金计算单-工程量租
 * 
 * @author generator
 * 
 */
public class RentCalculateNumVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long rentId; // 主表主键
    private Long sourceId; // 来源数据Id
    private Long materialTypeId; // 物资材料分类Id
    private String materialTypeName; // 物资材料分类名称
    private Long materialId; // 材料id
    private String materialCode; // 材料编码
    private String materialName; // 材料名称
    private String spec; // 规则/型号
    private Long unitId; // 计量单位id
    private String unitName; // 计量单位名称
    private BigDecimal num; // 数量
    private BigDecimal unitTaxPrice; // 租赁单价
    private BigDecimal unitPrice; // 租赁单价(无税)
    private BigDecimal taxRate; // 税率
    private BigDecimal numRentTaxMny; // 工程量租金
    private BigDecimal numRentMny; // 工程量租金(无税)
    private BigDecimal numTax; // 税额
    private Date startDate; // 计费开始日期
    private Date endDate; // 计费结束日期
    private String memo; // 备注
    

    public Long getRentId() {
        return rentId;
    }

    public void setRentId(Long rentId) {
        this.rentId = rentId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    @ReferSerialTransfer(referCode = "share-unit")
    public Long getUnitId() {
        return unitId;
    }

    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getUnitTaxPrice() {
        return unitTaxPrice;
    }

    public void setUnitTaxPrice(BigDecimal unitTaxPrice) {
        this.unitTaxPrice = unitTaxPrice;
    }
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getNumRentTaxMny() {
        return numRentTaxMny;
    }

    public void setNumRentTaxMny(BigDecimal numRentTaxMny) {
        this.numRentTaxMny = numRentTaxMny;
    }
    public BigDecimal getNumRentMny() {
        return numRentMny;
    }

    public void setNumRentMny(BigDecimal numRentMny) {
        this.numRentMny = numRentMny;
    }
    public BigDecimal getNumTax() {
        return numTax;
    }

    public void setNumTax(BigDecimal numTax) {
        this.numTax = numTax;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
