package com.ejianc.business.assist.rmat.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 周转材租赁合同-报废标准
 *
 * @author generator
 */
public class ContractScrapVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long contractId; // 合同id
    private Long changeId; // 变更表主键
    private Long changeBid; // 变更子表主键
    private Long materialTypeId; // 物资材料分类Id
    private String materialTypeName; // 物资材料分类名称
    private String materialName; // 材料名称
    private String spec; // 规则/型号
    private String damageScrapName; // 损坏报废名称
    private BigDecimal damageScrapPrice; // 损坏报废单价(无税)
    private BigDecimal damageScrapTaxPrice; // 损坏报废单价
    private BigDecimal taxRate; // 税率
    private BigDecimal tax; // 税额
    private String memo; // 备注
    private Long materialId; // 材料id
    private String materialCode; // 材料编码
    private Long unitId; // 计量单位id
    private String unitName; // 计量单位名称
    private Long damageScrapUnitId; // 损坏报废单位id
    private String damageScrapUnitName; // 损坏报废单位名称
    private Long sourceId; // 来源数据Id(参照数据id)
    private String sourceType; // 来源类型：0-定标结果带入，1-总计划，2-材料档案，3-批次计划

    private String materialTypeCode; // 材料分类编码
    private Integer rowType; // 行分类：0-分类，1-材料


    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getDamageScrapName() {
        return damageScrapName;
    }

    public void setDamageScrapName(String damageScrapName) {
        this.damageScrapName = damageScrapName;
    }
    
    public BigDecimal getDamageScrapPrice() {
        return damageScrapPrice;
    }

    public void setDamageScrapPrice(BigDecimal damageScrapPrice) {
        this.damageScrapPrice = damageScrapPrice;
    }

    public BigDecimal getDamageScrapTaxPrice() {
        return damageScrapTaxPrice;
    }

    public void setDamageScrapTaxPrice(BigDecimal damageScrapTaxPrice) {
        this.damageScrapTaxPrice = damageScrapTaxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    @ReferSerialTransfer(referCode = "share-unit")
    public Long getUnitId() {
        return unitId;
    }

    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Long getDamageScrapUnitId() {
        return damageScrapUnitId;
    }

    public void setDamageScrapUnitId(Long damageScrapUnitId) {
        this.damageScrapUnitId = damageScrapUnitId;
    }

    public String getDamageScrapUnitName() {
        return damageScrapUnitName;
    }

    public void setDamageScrapUnitName(String damageScrapUnitName) {
        this.damageScrapUnitName = damageScrapUnitName;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public Integer getRowType() {
        return rowType;
    }

    public void setRowType(Integer rowType) {
        this.rowType = rowType;
    }

}
