package com.ejianc.business.assist.store.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 仓库表
 * 
 * @author generator
 * 
 */
public class StoreVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // 所属项目部
    private String orgName; // 所属项目部名称
    private Long projectId; // 所属项目
    private String projectName; // 所属项目名称
    private String projectCode; // 所属项目编码
    private Integer projectType; // 是否项目（1、是，0、否）
    private Long parentOrgId; // 项目部上级组织
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Integer state; // 仓库状态（1、启用，0、停用）
    private String name; // 仓库名称
    private Integer attrFlag; // 仓库属性 1-自购材；2-甲供材
    private BigDecimal totalMny; // 库存金额
    private Integer defaultFlag; // 是否默认：0-否；1-是
    private String memo; // 描述

    private BigDecimal totalOriginalValueTax;// 原值
    private BigDecimal totalNetWorthTax;// 净值
    private BigDecimal totalResidualValueTax;// 残值


    public BigDecimal getTotalOriginalValueTax() {
        return totalOriginalValueTax;
    }

    public void setTotalOriginalValueTax(BigDecimal totalOriginalValueTax) {
        this.totalOriginalValueTax = totalOriginalValueTax;
    }

    public BigDecimal getTotalNetWorthTax() {
        return totalNetWorthTax;
    }

    public void setTotalNetWorthTax(BigDecimal totalNetWorthTax) {
        this.totalNetWorthTax = totalNetWorthTax;
    }

    public BigDecimal getTotalResidualValueTax() {
        return totalResidualValueTax;
    }

    public void setTotalResidualValueTax(BigDecimal totalResidualValueTax) {
        this.totalResidualValueTax = totalResidualValueTax;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Integer getProjectType() {
        return projectType;
    }

    public void setProjectType(Integer projectType) {
        this.projectType = projectType;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getAttrFlag() {
        return attrFlag;
    }

    public void setAttrFlag(Integer attrFlag) {
        this.attrFlag = attrFlag;
    }

    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public Integer getDefaultFlag() {
        return defaultFlag;
    }

    public void setDefaultFlag(Integer defaultFlag) {
        this.defaultFlag = defaultFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
