package com.ejianc.business.assist.material.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 周转材采购申请-清单
 * 
 * @author generator
 * 
 */
public class MaterialBatchPlanDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long batchId; // 批次计划主键
    private Long materialTypeId; // 材料分类id
    private String materialTypeCode; // 材料分类编码
    private String materialTypeName; // 材料分类名称
    private Long materialId; // 材料id
    private String materialCode; // 材料编码
    private String materialName; // 材料名称
    private String spec; // 规格型号
    private String unit; // 计量单位
    private BigDecimal num; // 计划总量
    private BigDecimal mny; // 暂估金额
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date planUseTime; // 计划开始使用时间
    private String standard; // 质量验收标准或要求
    private String memo; // 备注
    private Long sourceId; // 物资来源出业务Id
    private Integer sourceType; // 来源,1-目标成本，2-材料档案，3-总计划
    private Long unitId; // 计量单位id
    private Integer rowType; // 行分类,1-分类，2-材料
    private Long unitMId; // 计租单位id
    private String unitMName; // 计租单位名称
    private BigDecimal price; // 单价
    private String brand; // 品牌

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Long getUnitMId() {
        return unitMId;
    }

    public void setUnitMId(Long unitMId) {
        this.unitMId = unitMId;
    }

    public String getUnitMName() {
        return unitMName;
    }

    public void setUnitMName(String unitMName) {
        this.unitMName = unitMName;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public Integer getRowType() {
        return rowType;
    }

    public void setRowType(Integer rowType) {
        this.rowType = rowType;
    }
    @ReferSerialTransfer(referCode="share-unit")
    public Long getUnitId() {
        return unitId;
    }
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public Long getBatchId() {
        return batchId;
    }

    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public Date getPlanUseTime() {
        return planUseTime;
    }

    public void setPlanUseTime(Date planUseTime) {
        this.planUseTime = planUseTime;
    }
    public String getStandard() {
        return standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    
}
