package com.ejianc.business.assist.material.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 辅料中心采购合同
 *
 * @author generator
 */
public class MaterialContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;


    @ConvertField(targetField = "sourceId,contractId,id")
    private Long id;
    @ConvertField
    private Integer dr;
    @ConvertField(targetField = "contractCode")
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    @ConvertField
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    @ConvertField
    private String projectName; // 项目名称
    @ConvertField
    private Long orgId; // 项目组织ID
    @ConvertField
    private String orgCode; // 项目组织编码
    @ConvertField
    private String orgName; // 项目组织名称
    @ConvertField
    private Long parentOrgId; // 父级组织ID
    @ConvertField
    private String parentOrgCode; // 父级组织编码
    @ConvertField
    private String parentOrgName; // 父级组织名称
    private Integer addType; // 合同新增方式：0-参照定标结果新增，1-直接新增
    private Long targetResultId; // 定标结果Id
    private String targetResultName; // 定标结果名称
    @ConvertField
    private String contractName; // 合同名称
    @ConvertField(targetField = "categoryId")
    private Long contractCategoryId; // 合同类别Id
    @ConvertField(targetField = "categoryName")
    private String contractCategoryName; // 合同类别名称
    @ConvertField(targetField = "partyaId")
    private Long firstPartyId; // 甲方Id
    @ConvertField(targetField = "partyaName")
    private String firstPartyName; // 甲方名称
    private Long firstPartyProjectManagerId; // 甲方项目负责人Id
    private String firstPartyProjectManagerName; // 甲方项目负责人名称
    @ConvertField(targetField = "employeeId")
    private Long firstPartyEmployeeId; // 甲方经办人id
    @ConvertField(targetField = "employeeName")
    private String firstPartyEmployeeName; // 甲方经办人名称
    private Long firstPartyEntrustedAgentId; // 甲方委托代理人id
    private String firstPartyEntrustedAgentName; // 甲方委托代理人名称
    @ConvertField(targetField = "employeePhone")
    private String firstPartyPhone; // 甲方电话
    @ConvertField(targetField = "partybId")
    private Long supplierId; // 乙方Id
    @ConvertField(targetField = "partybName")
    private String supplierName; // 乙方名称
    private Long supplierEmployeeId; // 乙方经办人id
    private String supplierEmployeeName; // 乙方经办人名称
    private String supplierPhone; // 乙方电话
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    @ConvertField(targetField = "signPlace")
    private String signAddress; // 签订地点
    @ConvertField
    private BigDecimal contractMny; // 合同金额(不含税)
    @ConvertField
    private BigDecimal contractTaxMny; // 合同金额
    @ConvertField
    private BigDecimal taxRate; // 合同税率
    @ConvertField(targetField = "contractTax")
    private BigDecimal contractTax; // 合同税额
    private String receiptAddress; // 收货地点
    @ConvertField(targetField = "performanceStatus")
    private String performanceStatus; // 合同履约状态：1-未签订，2-履约中，3-已终止，4-已作废，5-已冻结，6-已结束

    private String draftType; // 起草方式：1-在线起草，2-上传合同，3-线下签订
    private Integer signatureStatus; // 签章状态：0-未签章，1-待乙方签章，2-待甲方签章，3-已签章
    private String contractFilePath; // 合同附件路径
    private Long contractFileId; // 合同附件Id
    private Long contractTemplateId; // 合同模板Id
    private String contractTemplateName; // 合同模板名称
    private Long contractFileVersionId; // 合同附件版本Id
    private Long contractFileVersion; // 合同附件版本
    private String contractFileHighlightPath; // 合同高亮附件路径
    private Long contractFileHighlightId; // 合同高亮附件Id
    @ConvertField
    private BigDecimal baseMny; // 初始版本金额(不含税)
    @ConvertField
    private BigDecimal baseTaxMny; // 初始版本金额
    private BigDecimal beforeChangeMny; // 变更前金额(不含税)
    private BigDecimal beforeChangeTaxMny; // 变更前金额
    private BigDecimal changingMny; // 变更中金额(不含税)
    private BigDecimal changingTaxMny; // 变更中金额
    private Long changeId; // 变更主键
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    @ConvertField
    private Integer changeStatus; // 变更状态：1-未变更，2-变更中，3-已变更
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private String changeContractSignatureStatus; // 变更合同签章状态
    private String changeDraftType; // 变更起草方式：1-上传附件，2-线下签订
    private Long changeFileId; // 变更附件Id
    private String changeContractName; // 变更合同名称
    private Long signedFileId; // 签章完成合同文件Id
    @ConvertField
    private Long mainContractId; // 主合同Id
    @ConvertField
    private String mainContractCode; // 主合同编码
    @ConvertField
    private String mainContractName; // 主合同名称
    private String supplementDescribe; // 补充项描述
    @ConvertField
    private Integer supplementFlag; // 是否补充协议：0-否，1-是
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mainContractCreateDate; // 主合同创建日期(用于合同、补充协议排序)
    @ConvertField
    private Long departmentId; // 经办部门
    @ConvertField
    private String departmentName; // 经办部门名称
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    private String pushPoolFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    private String signatureStatusName; // 签章状态名称
    private String billStateName; // 单据状态名称

    private BigDecimal detailTaxMny; // 清单金额
    private BigDecimal detailMny; // 清单金额(无税)
    private BigDecimal detailTax; // 清单税额
    private BigDecimal otherTaxMny; // 其他费用
    private BigDecimal otherMny; // 其他费用(无税)
    private BigDecimal otherTax; // 其他税额
    private Boolean contractFileSyncFlag = true; // 线上起草合同，审批中修改的合同是否已重新进行合同编辑
    private Long watermarkContractFileId; // 水印合同附件Id

    private List<MaterialContractDetailVO> detailList = new ArrayList<>(); // 辅料中心采购合同-材料明细
    private List<MaterialContractOtherVO> otherList = new ArrayList<>(); // 辅料中心采购合同-其他费用
    @ConvertField(targetField = "contractSubPaymentNodeList", targetFieldType = ConvertField.TargetType.CLASS)
    private List<MaterialContractPaymentVO> paymentList = new ArrayList<>(); // 辅料中心采购合同-付款阶段
    private List<MaterialContractClauseVO> clauseList = new ArrayList<>(); // 辅料中心采购合同-合同条款

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }
    
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }

    public Long getTargetResultId() {
        return targetResultId;
    }

    @ReferDeserialTransfer
    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    @ReferDeserialTransfer
    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getFirstPartyId() {
        return firstPartyId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFirstPartyProjectManagerId() {
        return firstPartyProjectManagerId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyProjectManagerId(Long firstPartyProjectManagerId) {
        this.firstPartyProjectManagerId = firstPartyProjectManagerId;
    }

    public String getFirstPartyProjectManagerName() {
        return firstPartyProjectManagerName;
    }

    public void setFirstPartyProjectManagerName(String firstPartyProjectManagerName) {
        this.firstPartyProjectManagerName = firstPartyProjectManagerName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFirstPartyEmployeeId() {
        return firstPartyEmployeeId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyEmployeeId(Long firstPartyEmployeeId) {
        this.firstPartyEmployeeId = firstPartyEmployeeId;
    }

    public String getFirstPartyEmployeeName() {
        return firstPartyEmployeeName;
    }

    public void setFirstPartyEmployeeName(String firstPartyEmployeeName) {
        this.firstPartyEmployeeName = firstPartyEmployeeName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFirstPartyEntrustedAgentId() {
        return firstPartyEntrustedAgentId;
    }

    @ReferDeserialTransfer
    public void setFirstPartyEntrustedAgentId(Long firstPartyEntrustedAgentId) {
        this.firstPartyEntrustedAgentId = firstPartyEntrustedAgentId;
    }

    public String getFirstPartyEntrustedAgentName() {
        return firstPartyEntrustedAgentName;
    }

    public void setFirstPartyEntrustedAgentName(String firstPartyEntrustedAgentName) {
        this.firstPartyEntrustedAgentName = firstPartyEntrustedAgentName;
    }

    public String getFirstPartyPhone() {
        return firstPartyPhone;
    }

    public void setFirstPartyPhone(String firstPartyPhone) {
        this.firstPartyPhone = firstPartyPhone;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getSupplierEmployeeId() {
        return supplierEmployeeId;
    }

    @ReferDeserialTransfer
    public void setSupplierEmployeeId(Long supplierEmployeeId) {
        this.supplierEmployeeId = supplierEmployeeId;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSignAddress() {
        return signAddress;
    }

    public void setSignAddress(String signAddress) {
        this.signAddress = signAddress;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public String getReceiptAddress() {
        return receiptAddress;
    }

    public void setReceiptAddress(String receiptAddress) {
        this.receiptAddress = receiptAddress;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }

    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }

    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(String changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }

    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }

    public Long getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }

    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getPushPoolFlag() {
        return pushPoolFlag;
    }

    public void setPushPoolFlag(String pushPoolFlag) {
        this.pushPoolFlag = pushPoolFlag;
    }

    public String getSignatureStatusName() {
        return signatureStatusName;
    }

    public void setSignatureStatusName(String signatureStatusName) {
        this.signatureStatusName = signatureStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public Boolean getContractFileSyncFlag() {
        return contractFileSyncFlag;
    }

    public void setContractFileSyncFlag(Boolean contractFileSyncFlag) {
        this.contractFileSyncFlag = contractFileSyncFlag;
    }

    public Long getWatermarkContractFileId() {
        return watermarkContractFileId;
    }

    public void setWatermarkContractFileId(Long watermarkContractFileId) {
        this.watermarkContractFileId = watermarkContractFileId;
    }

    public List<MaterialContractDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<MaterialContractDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<MaterialContractOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<MaterialContractOtherVO> otherList) {
        this.otherList = otherList;
    }

    public List<MaterialContractPaymentVO> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<MaterialContractPaymentVO> paymentList) {
        this.paymentList = paymentList;
    }

    public List<MaterialContractClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<MaterialContractClauseVO> clauseList) {
        this.clauseList = clauseList;
    }
}
