package com.ejianc.business.assist.rmat.utils;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;
import java.util.concurrent.*;

/**
 * @author yqls
 * @date 2021-05-24 18:23:16
 */
@Component
public class DetailListUtil<T> {

    public static <T> T selectById(Long id, IBaseService service){
        QueryWrapper<T> ew = new QueryWrapper<>();
        ew.eq("tenant_id", InvocationInfoProxy.getTenantid());
        ew.eq("id", id);
        T entity = (T) service.getOne(ew);
        entity = setDetailList(new ArrayList<>(Arrays.asList(entity))).get(0);
        return entity;
    }

    public static <T> T selectById(Long id, Class<?> serviceClass){
        String serviceName = serviceClass.getAnnotation(Service.class).value();
        BaseServiceImpl service = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
        QueryWrapper<T> ew = new QueryWrapper<>();
        ew.eq("tenant_id", InvocationInfoProxy.getTenantid());
        ew.eq("id", id);
        T entity = (T) service.getOne(ew);
        entity = setDetailList(new ArrayList<>(Arrays.asList(entity))).get(0);
        return entity;
    }

    public static <T> List<T> setDetailList(List<T> list) {
        if(list != null && list.size() > 0) {
            Map<Long, Map<String, List<BaseEntity>>> listSubMap = getListSubMap(list);// 获取主键对应子表map
            for(T entity : list){
                Class<?> mainClass = entity.getClass();
                Field[] fields = mainClass.getDeclaredFields();
                /** 查找字表字段 可能有多个子表*/
                for (Field field : fields) {
                    if(field.isAnnotationPresent(SubEntity.class)){
                        SubEntity subEntity = field.getAnnotation(SubEntity.class);
                        String serviceName = subEntity.serviceName();
                        String fieldName = field.getName();
                        if(StringUtils.isBlank(serviceName)){
                            throw new BusinessException("子表字段【"+fieldName+"】注解SubEntity未设置子表实现类服务名！");
                        }
                        BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
                        if(subService==null){
                            throw new BusinessException("字段【"+fieldName+"】子表没有实现类！");
                        }
                        try {
                            Method m =  mainClass.getMethod("getId",  null);
                            /** 获取子表数据 */
                            Long id = (Long)m.invoke(entity, null);

                            // 取主键对应各个子表
                            Map<String, List<BaseEntity>> subMap = new HashMap<>();
                            if(listSubMap.containsKey(id)){
                                subMap = listSubMap.get(id);
                            }
                            List<BaseEntity> subList = new ArrayList<>();
                            if(subMap.containsKey(fieldName)){
                                subList = subMap.get(fieldName);
                            }

                            if(!ListUtil.isEmpty(subList)){
                                Class[] cArg = new Class[1];
                                cArg[0] = field.getType();
                                Method setSubList = mainClass.getDeclaredMethod("set"+fieldName.substring(0,1).toUpperCase()+fieldName.substring(1),cArg);
                                setSubList.invoke(entity,subList);
                            }
                        } catch (NoSuchMethodException e) {
                            throw new BusinessException("字段【"+fieldName+"】未定义set方法！");
                        } catch (IllegalAccessException e) {
                            throw new BusinessException("字段【"+fieldName+"】set方法需要是public属性！");
                        } catch (InvocationTargetException e) {
                            throw new BusinessException("字段【"+fieldName+"】set方法执行出错！");
                        }
                    }
                }
            };
        }
        return list;
    }

    private static <T> Map<Long, Map<String, List<BaseEntity>>> getListSubMap(List<T> list) {
        Map<Long, Map<String, ListCallable>> listCallMap = new HashMap<>();
        int size = getListCallMap(list, listCallMap);// 获取主键对应线程类map
        ExecutorService threadPool = null;
        if(size > 0) {
            threadPool = Executors.newFixedThreadPool(size);
        }
        Map<Long, Map<String, Future>> listFutMap = new HashMap<>();
        for(Long id : listCallMap.keySet()){
            Map<String, ListCallable> callableMap = listCallMap.get(id);
            Map<String, Future> futureMap = new HashMap<>();
            if(listFutMap.containsKey(id)){
                futureMap = listFutMap.get(id);
            }
            for(String fieldName : callableMap.keySet()) {
                Callable<List<BaseEntity>> callable = callableMap.get(fieldName);
                Future<List<BaseEntity>> future = threadPool.submit(callable);
                futureMap.put(fieldName, future);
            }
            listFutMap.put(id, futureMap);
        }
        Map<Long, Map<String, List<BaseEntity>>> listSubMap = new HashMap<>();
        try {
            for(Long id : listFutMap.keySet()){
                Map<String, Future> futureMap = listFutMap.get(id);
                Map<String, List<BaseEntity>> subMap = new HashMap<>();
                if(listSubMap.containsKey(id)){
                    subMap = listSubMap.get(id);
                }
                for (String fieldName : futureMap.keySet()) {
                    Future<List<BaseEntity>> future = futureMap.get(fieldName);
                    List<BaseEntity> subList = future.get(30, TimeUnit.SECONDS);
                    if(CollectionUtils.isNotEmpty(subList)) {
                        subMap.put(fieldName, subList);
                    }
                }
                listSubMap.put(id, subMap);
            }
        } catch (Exception e) {
            throw new BusinessException(e.getMessage());
        } finally {
            if(null != threadPool) {
                threadPool.shutdown();
            }
        }
        return listSubMap;
    }

    private static <T> int getListCallMap(List<T> list, Map<Long, Map<String, ListCallable>> listCallMap) {
        int size = 0;
        for(T entity : list) {
            Class<?> mainClass = entity.getClass();
            Field[] fields = mainClass.getDeclaredFields();
            /** 查找字表字段 可能有多个子表*/

            for (Field field : fields) {
                if(field.isAnnotationPresent(SubEntity.class)){
                    SubEntity subEntity = field.getAnnotation(SubEntity.class);
                    String serviceName = subEntity.serviceName();
                    String fieldName = field.getName();
                    if(StringUtils.isBlank(serviceName)){
                        throw new BusinessException("子表字段【"+fieldName+"】注解SubEntity未设置子表实现类服务名！");
                    }
                    BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
                    if(subService==null){
                        throw new BusinessException("字段【"+fieldName+"】子表没有实现类！");
                    }
                    try {
                        Method m =  mainClass.getMethod("getId",  null);
                        /** 获取子表数据 */
                        Long id = (Long)m.invoke(entity, null);
                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put(subEntity.pidName(), new Parameter(QueryParam.EQ, id));
                        queryParam.getOrderMap().put("id",QueryParam.ASC);
                        Map<String, ListCallable> callableMap = new HashMap<>();
                        if(listCallMap.containsKey(id)){
                            callableMap = listCallMap.get(id);
                        }
                        callableMap.put(fieldName, new ListCallable(queryParam, subService));
                        listCallMap.put(id, callableMap);
                        ++size;
                    } catch (NoSuchMethodException e) {
                        throw new BusinessException("字段【"+fieldName+"】未定义set方法！");
                    } catch (IllegalAccessException e) {
                        throw new BusinessException("字段【"+fieldName+"】set方法需要是public属性！");
                    } catch (InvocationTargetException e) {
                        throw new BusinessException("字段【"+fieldName+"】set方法执行出错！");
                    }
                }
            }
        }
        return size;
    }

    static class ListCallable implements Callable<List<BaseEntity>> {
        private QueryParam queryParam;
        private BaseServiceImpl service;

        public ListCallable(QueryParam queryParam, BaseServiceImpl service) {
            this.queryParam = queryParam;
            this.service = service;
        }

        @Override
        public List<BaseEntity> call() throws Exception {
            List<BaseEntity> subList = service.queryList(queryParam,false);
            return subList;
        }
    }
}
