package com.ejianc.business.outrmat.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.outrmat.hystrix.OutRmatHystrix;
import com.ejianc.business.outrmat.order.vo.OutRmatOrderVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@FeignClient(
        name = "ejc-assistrmat-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-assistrmat-web",
        fallback = OutRmatHystrix.class
)
public interface IOutRmatApi {
    @ApiOperation("保存推送的订单数据")
    @RequestMapping(
            value = {"/api/outRmat/saveOrder"},
            method = {RequestMethod.POST}
    )
    CommonResponse<String> saveOrder(@RequestBody OutRmatOrderVO saveOrUpdateVO);
    @ApiOperation("删除推送的订单数据")
    @RequestMapping(
            value = {"/api/outRmat/deleteOrder"},
            method = {RequestMethod.POST}
    )
    CommonResponse<String> deleteOrder(@RequestBody OutRmatOrderVO saveOrUpdateVO);
    @ApiOperation("订单关闭")
    @RequestMapping(
            value = {"/api/outRmat/updateOrderCloseFlag"},
            method = {RequestMethod.POST}
    )
    CommonResponse<String> updateOrderCloseFlag(@RequestBody OutRmatOrderVO saveOrUpdateVO);

    @ApiOperation("公共签字接口")
    @RequestMapping(
            value = {"/api/outRmat/updateBillSupSignSyncInfo"},
            method = {RequestMethod.POST}
    )
    @ResponseBody
    CommonResponse<String> updateBillSupSignSyncInfo(@RequestBody Map<String,String> map,@RequestParam String type);

}
