package com.ejianc.business.outrmat.contract.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OutRmatContractChangeCompareVO {

    private static final long serialVersionUID = 1L;
    
    private String contractName; // 合同名称
    private String firstPartyProjectManagerName; // 甲方项目负责人名称
    private String firstPartyEmployeeName; // 甲方经办人名称
    private String firstPartyPhone; // 甲方电话
    private String supplierName; // 乙方名称
    private String supplierEmployeeName; // 乙方经办人名称
    private String supplierPhone; // 乙方电话
    private String supplierAddress; // 乙方地址
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    private Integer monthSettlementDay; // 月结算日
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentCalculationDate; // 计租日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endRentCalculationDate; // 止租日期
    private BigDecimal taxRate; // 合同税率
    private String supplyAddress; // 供货地点
    private BigDecimal contractMny; // 合同金额(不含税)
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal tax; // 合同税额

    private String firstPartyEntrustedAgentName; // 甲方委托代理人名称
    private String firstPartyPrincipalName; // 甲方负责人名称
    private String firstPartyAddress; // 甲方地址
    private String supplierPrincipalName; // 乙方单位负责人名称
    private String materialClerkOneName; // 材料员一名称
    private String materialClerkOnePhone; // 材料员一联系方式
    private String materialClerkTwoName; // 材料员二名称
    private String materialClerkTwoPhone; // 材料员二联系方式

    private List<OutRmatContractChangeDailyRentVO> dailyRentList = new ArrayList<>(); // 周转材租赁合同-日租明细变更表
    private List<OutRmatContractChangeMonthRentVO> monthRentList = new ArrayList<>(); // 周转材租赁合同-月租明细变更表
    private List<OutRmatContractChangeNumRentVO> numRentList = new ArrayList<>(); // 周转材租赁合同-工程量租明细表更表
    private List<OutRmatContractChangeRepairVO> repairList = new ArrayList<>(); // 周转材租赁合同-维修标准变更表
    private List<OutRmatContractChangeScrapVO> scrapList = new ArrayList<>(); // 周转材租赁合同-报废标准变更表
    private List<OutRmatContractChangeOtherVO> otherList = new ArrayList<>(); // 周转材租赁合同-其他费用变更表
    private List<OutRmatContractChangePaymentVO> paymentList = new ArrayList<>(); // 周转材租赁合同-付款阶段变更表
    private List<OutRmatContractChangeClauseVO> clauseList = new ArrayList<>(); // 周转材租赁合同-合同条款变更表

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getFirstPartyProjectManagerName() {
        return firstPartyProjectManagerName;
    }

    public void setFirstPartyProjectManagerName(String firstPartyProjectManagerName) {
        this.firstPartyProjectManagerName = firstPartyProjectManagerName;
    }

    public String getFirstPartyEmployeeName() {
        return firstPartyEmployeeName;
    }

    public void setFirstPartyEmployeeName(String firstPartyEmployeeName) {
        this.firstPartyEmployeeName = firstPartyEmployeeName;
    }

    public String getFirstPartyPhone() {
        return firstPartyPhone;
    }

    public void setFirstPartyPhone(String firstPartyPhone) {
        this.firstPartyPhone = firstPartyPhone;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public Integer getMonthSettlementDay() {
        return monthSettlementDay;
    }

    public void setMonthSettlementDay(Integer monthSettlementDay) {
        this.monthSettlementDay = monthSettlementDay;
    }

    public Date getRentCalculationDate() {
        return rentCalculationDate;
    }

    public void setRentCalculationDate(Date rentCalculationDate) {
        this.rentCalculationDate = rentCalculationDate;
    }

    public Date getEndRentCalculationDate() {
        return endRentCalculationDate;
    }

    public void setEndRentCalculationDate(Date endRentCalculationDate) {
        this.endRentCalculationDate = endRentCalculationDate;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getSupplyAddress() {
        return supplyAddress;
    }

    public void setSupplyAddress(String supplyAddress) {
        this.supplyAddress = supplyAddress;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getFirstPartyEntrustedAgentName() {
        return firstPartyEntrustedAgentName;
    }

    public void setFirstPartyEntrustedAgentName(String firstPartyEntrustedAgentName) {
        this.firstPartyEntrustedAgentName = firstPartyEntrustedAgentName;
    }

    public String getFirstPartyPrincipalName() {
        return firstPartyPrincipalName;
    }

    public void setFirstPartyPrincipalName(String firstPartyPrincipalName) {
        this.firstPartyPrincipalName = firstPartyPrincipalName;
    }

    public String getFirstPartyAddress() {
        return firstPartyAddress;
    }

    public void setFirstPartyAddress(String firstPartyAddress) {
        this.firstPartyAddress = firstPartyAddress;
    }

    public String getSupplierPrincipalName() {
        return supplierPrincipalName;
    }

    public void setSupplierPrincipalName(String supplierPrincipalName) {
        this.supplierPrincipalName = supplierPrincipalName;
    }

    public String getMaterialClerkOneName() {
        return materialClerkOneName;
    }

    public void setMaterialClerkOneName(String materialClerkOneName) {
        this.materialClerkOneName = materialClerkOneName;
    }

    public String getMaterialClerkOnePhone() {
        return materialClerkOnePhone;
    }

    public void setMaterialClerkOnePhone(String materialClerkOnePhone) {
        this.materialClerkOnePhone = materialClerkOnePhone;
    }

    public String getMaterialClerkTwoName() {
        return materialClerkTwoName;
    }

    public void setMaterialClerkTwoName(String materialClerkTwoName) {
        this.materialClerkTwoName = materialClerkTwoName;
    }

    public String getMaterialClerkTwoPhone() {
        return materialClerkTwoPhone;
    }

    public void setMaterialClerkTwoPhone(String materialClerkTwoPhone) {
        this.materialClerkTwoPhone = materialClerkTwoPhone;
    }

    public List<OutRmatContractChangeDailyRentVO> getDailyRentList() {
        return dailyRentList;
    }

    public void setDailyRentList(List<OutRmatContractChangeDailyRentVO> dailyRentList) {
        this.dailyRentList = dailyRentList;
    }

    public List<OutRmatContractChangeMonthRentVO> getMonthRentList() {
        return monthRentList;
    }

    public void setMonthRentList(List<OutRmatContractChangeMonthRentVO> monthRentList) {
        this.monthRentList = monthRentList;
    }

    public List<OutRmatContractChangeNumRentVO> getNumRentList() {
        return numRentList;
    }

    public void setNumRentList(List<OutRmatContractChangeNumRentVO> numRentList) {
        this.numRentList = numRentList;
    }

    public List<OutRmatContractChangeRepairVO> getRepairList() {
        return repairList;
    }

    public void setRepairList(List<OutRmatContractChangeRepairVO> repairList) {
        this.repairList = repairList;
    }

    public List<OutRmatContractChangeScrapVO> getScrapList() {
        return scrapList;
    }

    public void setScrapList(List<OutRmatContractChangeScrapVO> scrapList) {
        this.scrapList = scrapList;
    }

    public List<OutRmatContractChangeOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<OutRmatContractChangeOtherVO> otherList) {
        this.otherList = otherList;
    }

    public List<OutRmatContractChangePaymentVO> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<OutRmatContractChangePaymentVO> paymentList) {
        this.paymentList = paymentList;
    }

    public List<OutRmatContractChangeClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<OutRmatContractChangeClauseVO> clauseList) {
        this.clauseList = clauseList;
    }
}
