package com.ejianc.business.outrmat.contract.vo.record;

import com.ejianc.business.assist.rmat.vo.ContractRelieveVO;
import com.ejianc.business.outrmat.contract.vo.OutRmatContractRelieveVO;

import java.util.ArrayList;
import java.util.List;

public class OutRmatContractRelieveRecordVO {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    
    /**
     * 主合同主键
     */
    private Long mainContractId;
    
    /**
     * 合同履约状态：1-未签订，2-履约中，3-已终止，4-已作废，5-已冻结，6-已结束
     */
    private String performanceStatus;
    
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;

    /**
     * 签章状态：0-未签章，1-待乙方签章，2-待甲方签章，3-已签章
     */
    private Integer signatureStatus;
    
    private List<OutRmatContractRelieveVO> detailList = new ArrayList<>();


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public List<OutRmatContractRelieveVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<OutRmatContractRelieveVO> detailList) {
        this.detailList = detailList;
    }
}
