package com.ejianc.business.outrmat.contract.vo.record;

import com.ejianc.business.assist.rmat.vo.SettleVO;
import com.ejianc.business.outrmat.settle.vo.OutRmatSettleVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class OutRmatContractSettleRecordVO {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    
    /**
     * 主合同主键
     */
    private Long mainContractId;
    
    /**
     * 合同金额(含税)
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同金额(无税)
     */
    private BigDecimal contractMny;

    /**
     * 累计结算金额
     */
    private BigDecimal totalSettleTaxMny;
    
    /**
     * 累计结算金额(无税)
     */
    private BigDecimal totalSettleMny;

    /**
     * 结算比例
     */
    private BigDecimal settleRate;
    
    /**
     * 合同履约状态：1-未签订，2-履约中，3-已终止，4-已作废，5-已冻结，6-已结束
     */
    private String performanceStatus;
    
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;

    /**
     * 签章状态：0-未签章，1-待乙方签章，2-待甲方签章，3-已签章
     */
    private Integer signatureStatus;
    
    private List<OutRmatSettleVO> detailList = new ArrayList<>();


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public BigDecimal getSettleRate() {
        return settleRate;
    }

    public void setSettleRate(BigDecimal settleRate) {
        this.settleRate = settleRate;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public List<OutRmatSettleVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<OutRmatSettleVO> detailList) {
        this.detailList = detailList;
    }
}
