package com.ejianc.business.assist.material.vo.compare;

import com.ejianc.business.assist.material.vo.MaterialChangeClauseVO;
import com.ejianc.business.assist.material.vo.MaterialChangeDetailVO;
import com.ejianc.business.assist.material.vo.MaterialChangeOtherVO;
import com.ejianc.business.assist.material.vo.MaterialChangePaymentVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MaterialChangeCompareVO {

    private static final long serialVersionUID = 1L;
    
    private String contractName; // 合同名称
    private String firstPartyProjectManagerName; // 甲方项目负责人名称
    private String firstPartyEntrustedAgentName; // 甲方委托代理人名称
    private String firstPartyEmployeeName; // 甲方经办人名称
    private String firstPartyPhone; // 甲方电话
    private String supplierName; // 乙方名称
    private String supplierEmployeeName; // 乙方经办人名称
    private String supplierPhone; // 乙方电话
    private String supplierAddress; // 乙方地址
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String signAddress; // 签订地点
    private BigDecimal taxRate; // 合同税率
    private String receiptAddress; // 收货地点
    private BigDecimal contractMny; // 合同金额(不含税)
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal tax; // 合同税额

    
    private List<MaterialChangeDetailVO> detailList = new ArrayList<>(); // 辅料中心采购合同-材料明细变更表
    private List<MaterialChangeOtherVO> otherList = new ArrayList<>(); // 辅料中心采购合同-其他费用变更表
    private List<MaterialChangePaymentVO> paymentList = new ArrayList<>(); // 辅料中心采购合同-付款阶段变更表
    private List<MaterialChangeClauseVO> clauseList = new ArrayList<>(); // 辅料中心采购合同-合同条款变更表


    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getFirstPartyProjectManagerName() {
        return firstPartyProjectManagerName;
    }

    public void setFirstPartyProjectManagerName(String firstPartyProjectManagerName) {
        this.firstPartyProjectManagerName = firstPartyProjectManagerName;
    }

    public String getFirstPartyEntrustedAgentName() {
        return firstPartyEntrustedAgentName;
    }

    public void setFirstPartyEntrustedAgentName(String firstPartyEntrustedAgentName) {
        this.firstPartyEntrustedAgentName = firstPartyEntrustedAgentName;
    }

    public String getFirstPartyEmployeeName() {
        return firstPartyEmployeeName;
    }

    public void setFirstPartyEmployeeName(String firstPartyEmployeeName) {
        this.firstPartyEmployeeName = firstPartyEmployeeName;
    }

    public String getFirstPartyPhone() {
        return firstPartyPhone;
    }

    public void setFirstPartyPhone(String firstPartyPhone) {
        this.firstPartyPhone = firstPartyPhone;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSupplierPhone() {
        return supplierPhone;
    }

    public void setSupplierPhone(String supplierPhone) {
        this.supplierPhone = supplierPhone;
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSignAddress() {
        return signAddress;
    }

    public void setSignAddress(String signAddress) {
        this.signAddress = signAddress;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getReceiptAddress() {
        return receiptAddress;
    }

    public void setReceiptAddress(String receiptAddress) {
        this.receiptAddress = receiptAddress;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public List<MaterialChangeDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<MaterialChangeDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<MaterialChangeOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<MaterialChangeOtherVO> otherList) {
        this.otherList = otherList;
    }

    public List<MaterialChangePaymentVO> getPaymentList() {
        return paymentList;
    }

    public void setPaymentList(List<MaterialChangePaymentVO> paymentList) {
        this.paymentList = paymentList;
    }

    public List<MaterialChangeClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<MaterialChangeClauseVO> clauseList) {
        this.clauseList = clauseList;
    }
}
