package com.ejianc.business.assist.rmat.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.List;


/**
 * 材料明细
 * 
 * @author generator
 * 
 */
public class MaterialVO {
    private static final long serialVersionUID = 1L;

    private String id; // 主键ID
    /** 合同信息 */
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Long supplierId; // 供方主键
    private String supplierName; // 供方名称

    /** 物料信息 */
    private Long materialTypeId; // 物资分类主键
    private String materialTypeName; // 物资分类名称
    private Long materialId; // 物料主键
    private String materialCode; // 物料编码
    private String materialName; // 物料名称
    private String spec; // 规格/型号
    private Long unitId; // 计量单位主键
    private String unitName; // 计量单位
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    private String rentTypeName; // 计租方式：0-日租，1-月租，2-工程量租

    private Long assistUnitId; // 计租单位
    private String assistUnitName; // 计租单位名称
    private BigDecimal assistNum; // 计租数量
    private BigDecimal transScale; // 转换系数

    /** 在场信息 */
    private String useStatus; // 使用状态：0-停用，1-启用
    private BigDecimal checkedNum; // 已进场数量
    private BigDecimal startedNum; // 在场已启用数量
    private BigDecimal stopedNum; // 在场已停用数量
    private BigDecimal restitutedNum; // 已退赔数量
    private BigDecimal losedNum; // 已遗失数量
    private BigDecimal tempRestNum; // 未生效退赔数量
    private BigDecimal tempLoseNum; // 未生效遗失数量
    private BigDecimal numM;// 非台账可参照主数量
    private BigDecimal refNum; // 可参照数量

    private String contractRmatMethod; // 合同租赁方式,0-外租，1-内租
    private String contractRmatMethodName; // 合同租赁方式,0-外租，1-内租
    private String useStatusName; // 使用状态：0-停用，1-启用

    private BigDecimal outReturnNum; // 租出已释放数量
    private Long storeId; // 仓库
    private String storeName; // 仓库名称
    private Integer sourceType; // 材料来源,0-自购,1-租赁，为空的租赁，不为空的租出

    private List<MaterialFlowVO> flowList;// 操作明细

    private List<MaterialFlowVO> beginList;// 期初

    public List<MaterialFlowVO> getBeginList() {
        return beginList;
    }

    public void setBeginList(List<MaterialFlowVO> beginList) {
        this.beginList = beginList;
    }

    public List<MaterialFlowVO> getFlowList() {
        return flowList;
    }

    public void setFlowList(List<MaterialFlowVO> flowList) {
        this.flowList = flowList;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public BigDecimal getOutReturnNum() {
        return outReturnNum;
    }

    public void setOutReturnNum(BigDecimal outReturnNum) {
        this.outReturnNum = outReturnNum;
    }

    public BigDecimal getNumM() {
        return numM;
    }

    public void setNumM(BigDecimal numM) {
        this.numM = numM;
    }

    public Long getAssistUnitId() {
        return assistUnitId;
    }

    public void setAssistUnitId(Long assistUnitId) {
        this.assistUnitId = assistUnitId;
    }

    public String getAssistUnitName() {
        return assistUnitName;
    }

    public void setAssistUnitName(String assistUnitName) {
        this.assistUnitName = assistUnitName;
    }

    public BigDecimal getAssistNum() {
        return assistNum;
    }

    public void setAssistNum(BigDecimal assistNum) {
        this.assistNum = assistNum;
    }

    public BigDecimal getTransScale() {
        return transScale;
    }

    public void setTransScale(BigDecimal transScale) {
        this.transScale = transScale;
    }

    public String getContractRmatMethodName() {
        return contractRmatMethodName;
    }

    public void setContractRmatMethodName(String contractRmatMethodName) {
        this.contractRmatMethodName = contractRmatMethodName;
    }

    public String getUseStatusName() {
        return useStatusName;
    }

    public void setUseStatusName(String useStatusName) {
        this.useStatusName = useStatusName;
    }

    public String getContractRmatMethod() {
        return contractRmatMethod;
    }

    public void setContractRmatMethod(String contractRmatMethod) {
        this.contractRmatMethod = contractRmatMethod;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }

    public String getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(String useStatus) {
        this.useStatus = useStatus;
    }

    public BigDecimal getCheckedNum() {
        return checkedNum;
    }

    public void setCheckedNum(BigDecimal checkedNum) {
        this.checkedNum = checkedNum;
    }

    public BigDecimal getStartedNum() {
        return startedNum;
    }

    public void setStartedNum(BigDecimal startedNum) {
        this.startedNum = startedNum;
    }

    public BigDecimal getStopedNum() {
        return stopedNum;
    }

    public void setStopedNum(BigDecimal stopedNum) {
        this.stopedNum = stopedNum;
    }

    public BigDecimal getRestitutedNum() {
        return restitutedNum;
    }

    public void setRestitutedNum(BigDecimal restitutedNum) {
        this.restitutedNum = restitutedNum;
    }

    public BigDecimal getLosedNum() {
        return losedNum;
    }

    public void setLosedNum(BigDecimal losedNum) {
        this.losedNum = losedNum;
    }

    public BigDecimal getTempRestNum() {
        return tempRestNum;
    }

    public void setTempRestNum(BigDecimal tempRestNum) {
        this.tempRestNum = tempRestNum;
    }

    public BigDecimal getTempLoseNum() {
        return tempLoseNum;
    }

    public void setTempLoseNum(BigDecimal tempLoseNum) {
        this.tempLoseNum = tempLoseNum;
    }

    public BigDecimal getRefNum() {
        return refNum;
    }

    public void setRefNum(BigDecimal refNum) {
        this.refNum = refNum;
    }
}
