package com.ejianc.business.assist.rmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import javax.validation.constraints.NotEmpty;


/**
 * 租赁流水表
 * 
 * @author generator
 * 
 */
public class RmatFlowVO extends BaseVO{
    private static final long serialVersionUID = 1L;

    @NotEmpty(message = "来源单据类型编码不能为空")
    private String billTypeCode; // 来源单据类型编码
    @NotEmpty(message = "来源单据id不能为空")
    private Long sourceId; // 来源单据id
    @NotEmpty(message = "来源单据明细id不能为空")
    private Long sourceDetailId; // 来源单据明细id
    @NotEmpty(message = "来源单据编码不能为空")
    private String billCode; // 来源单据编码
    @NotEmpty(message = "仓库不能为空")
    private Long storeId; // 仓库
    private String storeName; // 仓库名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long orgId; // 所属组织
    private String orgCode; // 项目组织编码
    private String orgName; // 所属组织名称
    @NotEmpty(message = "合同id不能为空")
    private Long contractId; // 合同id
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    private Long employeeId; // 业务经办人ID
    private String employeeName; // 业务经办人名称
    @NotEmpty(message = "来源单据日期不能为空")
    private Date billDate; // 来源单据日期
    @NotEmpty(message = "来源单据明细日期不能为空")
    private Date detailDate; // 来源单据明细日期
    private Date effectiveDate; // 生效时间
    @NotEmpty(message = "生效状态不能为空")
    private Integer effectiveState; // 生效状态0自由1已生效
    @NotEmpty(message = "流水类型不能为空")
    private String flowType; // 流水类型: 1-验收，2-停用，3-启用，4-退赔，5-遗失
    @NotEmpty(message = "进退场属性不能为空")
    private Integer inOutFlag; // 进退场属性1进场2退场

    @NotEmpty(message = "使用状态不能为空")
    private String useStatus; // 使用状态：0-停用，1-启用
    private Long materialTypeId; // 物资分类id
    private String materialTypeName; // 物资分类名称
    @NotEmpty(message = "物资id不能为空")
    private Long materialId; // 物资id
    private String materialCode; // 物资编码
    private String materialName; // 物资名称
    private String spec; // 规格型号
    private Long unitId; // 计量单位id
    private String unitName; // 计量单位
    private BigDecimal num; // 数量
    private Long assistUnitId; // 计租单位
    private String assistUnitName; // 计租单位名称
    private BigDecimal assistNum; // 计租数量
    @NotEmpty(message = "转换系数不能为空")
    private BigDecimal transScale; // 转换系数
    @NotEmpty(message = "计租方式不能为空")
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租

    /** 在场信息 */
    private BigDecimal checkedNum; // 已进场数量
    private BigDecimal startedNum; // 在场已启用数量
    private BigDecimal stopedNum; // 在场已停用数量
    private BigDecimal restitutedNum; // 已退赔数量
    private BigDecimal losedNum; // 已遗失数量
    private BigDecimal tempRestNum; // 未生效退赔数量
    private BigDecimal tempLoseNum; // 未生效遗失数量
    private BigDecimal refNum; // 可参照数量

    private String rentTypeName; // 计租方式：0-日租，1-月租，2-工程量租
    private String contractRmatMethod; // 合同租赁方式,0-外租，1-内租
    private String contractRmatMethodName; // 合同租赁方式,0-外租，1-内租
    private String useStatusName; // 使用状态：0-停用，1-启用

    private Integer sourceType; // 材料来源,0-自购,1-租赁，为空的租赁，不为空的租出

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public BigDecimal getCheckedNum() {
        return checkedNum;
    }

    public void setCheckedNum(BigDecimal checkedNum) {
        this.checkedNum = checkedNum;
    }

    public BigDecimal getStartedNum() {
        return startedNum;
    }

    public void setStartedNum(BigDecimal startedNum) {
        this.startedNum = startedNum;
    }

    public BigDecimal getStopedNum() {
        return stopedNum;
    }

    public void setStopedNum(BigDecimal stopedNum) {
        this.stopedNum = stopedNum;
    }

    public BigDecimal getRestitutedNum() {
        return restitutedNum;
    }

    public void setRestitutedNum(BigDecimal restitutedNum) {
        this.restitutedNum = restitutedNum;
    }

    public BigDecimal getLosedNum() {
        return losedNum;
    }

    public void setLosedNum(BigDecimal losedNum) {
        this.losedNum = losedNum;
    }

    public BigDecimal getTempRestNum() {
        return tempRestNum;
    }

    public void setTempRestNum(BigDecimal tempRestNum) {
        this.tempRestNum = tempRestNum;
    }

    public BigDecimal getTempLoseNum() {
        return tempLoseNum;
    }

    public void setTempLoseNum(BigDecimal tempLoseNum) {
        this.tempLoseNum = tempLoseNum;
    }

    public BigDecimal getRefNum() {
        return refNum;
    }

    public void setRefNum(BigDecimal refNum) {
        this.refNum = refNum;
    }

    public String getContractRmatMethod() {
        return contractRmatMethod;
    }

    public void setContractRmatMethod(String contractRmatMethod) {
        this.contractRmatMethod = contractRmatMethod;
    }

    public String getContractRmatMethodName() {
        return contractRmatMethodName;
    }

    public void setContractRmatMethodName(String contractRmatMethodName) {
        this.contractRmatMethodName = contractRmatMethodName;
    }

    public String getUseStatusName() {
        return useStatusName;
    }

    public void setUseStatusName(String useStatusName) {
        this.useStatusName = useStatusName;
    }

    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Date getDetailDate() {
        return detailDate;
    }

    public void setDetailDate(Date detailDate) {
        this.detailDate = detailDate;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getEffectiveState() {
        return effectiveState;
    }

    public void setEffectiveState(Integer effectiveState) {
        this.effectiveState = effectiveState;
    }
    public String getFlowType() {
        return flowType;
    }

    public void setFlowType(String flowType) {
        this.flowType = flowType;
    }
    public Integer getInOutFlag() {
        return inOutFlag;
    }

    public void setInOutFlag(Integer inOutFlag) {
        this.inOutFlag = inOutFlag;
    }
    public String getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(String useStatus) {
        this.useStatus = useStatus;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public Long getAssistUnitId() {
        return assistUnitId;
    }

    public void setAssistUnitId(Long assistUnitId) {
        this.assistUnitId = assistUnitId;
    }
    public String getAssistUnitName() {
        return assistUnitName;
    }

    public void setAssistUnitName(String assistUnitName) {
        this.assistUnitName = assistUnitName;
    }
    public BigDecimal getAssistNum() {
        return assistNum;
    }

    public void setAssistNum(BigDecimal assistNum) {
        this.assistNum = assistNum;
    }
    public BigDecimal getTransScale() {
        return transScale;
    }

    public void setTransScale(BigDecimal transScale) {
        this.transScale = transScale;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }


}
