package com.ejianc.business.assist.store.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 出入库类型
 */
public enum InOutTypeEnum {

    //*******start*****消耗材******************

    /**
     * 常规入库
     */
    收料入库(1, 11, "收料入库", 1),
    调拨入库(1, 12, "调拨入库", 1),
    盘盈入库(1, 13, "盘盈入库", 1),

    /**
     * 负数出库
     * 更新
     */
    领料退库(2, 29, "领料退库", 0),


    直入直出入库(1, 30, "直入直出", 0),

    直入直出出库(2, 30, "直入直出", 0),

    /**
     * 常规出库
     */
    领料出库(2, 21, "领料出库", 0),
    调拨出库(2, 22, "调拨出库", 0),
    盘亏出库(2, 23, "盘亏出库", 0),
    材料处置(2, 24, "材料处置", 0),

    /**
     * 负数入库
     */
    材料退货(1, 19, "材料退货", 0),

    //*******end*****消耗材******************


    周转材收料入库(1, 31, "收料入库", 1),

    周转材调拨入库(1, 32, "调拨入库", 1),

    周转材调拨出库(2, 32, "调拨出库", 0),

    周转材材料处置(2, 34, "材料处置", 0),

    //************辅料中心******************

    原材料加工入库(1, 35, "原材料加工", 1),

    原材料加工出库(2, 35, "原材料加工", 0),

    其他入库(1, 36, "其他入库", 1),

    辅料中心租出退赔(2,37,"退赔出库", 0),

    辅料中心租出遗失(2,38,"遗失出库", 0);

    /**
     * 出入库标志: 1入库 2出库
     */
    private Integer inOutFlag;

    /**
     * 出入库类型编码,参照枚举对象
     */
    private Integer inOutType;

    /**
     * 出入库类型名称,参照枚举对象
     */
    private String inOutTypeName;


    /**
     * 针对入库出库使用状态
     * 0无需出库    出库单固定此状态
     * 1可以出库    入库单生效未被使用
     * 2出库占用中   入库单使用中
     * 3出库完成    入库单使用完成
     */
    private Integer outUseFlag;


    private static Map<Integer, InOutTypeEnum> enumMap = new HashMap();

    static {
        enumMap = EnumSet.allOf(InOutTypeEnum.class).stream().collect(Collectors.toMap(InOutTypeEnum::getInOutType, Function.identity(), (k1, k2) -> k2));
    }

    /**
     * 根据入库类型编码,获取枚举对象
     */
    public static InOutTypeEnum getEnumByInOutType(Integer inOutType) {
        return enumMap.get(inOutType);
    }


    /**
     * @description: 是否是周转材
     * @return: boolean
     * @author songlx
     * @date: 2022/3/2
     */
    public Integer getTurnFlag() {
        return this.inOutType.intValue() > 30 ? 1 : 0;
    }


    InOutTypeEnum(Integer inOutFlag, Integer inOutType, String inOutTypeName, Integer outUseFlag) {
        this.inOutFlag = inOutFlag;
        this.inOutType = inOutType;
        this.inOutTypeName = inOutTypeName;
        this.outUseFlag = outUseFlag;
    }

    public Integer getInOutFlag() {
        return inOutFlag;
    }

    public void setInOutFlag(Integer inOutFlag) {
        this.inOutFlag = inOutFlag;
    }

    public Integer getInOutType() {
        return inOutType;
    }

    public void setInOutType(Integer inOutType) {
        this.inOutType = inOutType;
    }

    public String getInOutTypeName() {
        return inOutTypeName;
    }

    public void setInOutTypeName(String inOutTypeName) {
        this.inOutTypeName = inOutTypeName;
    }


    public Integer getOutUseFlag() {
        return outUseFlag;
    }

    public void setOutUseFlag(Integer outUseFlag) {
        this.outUseFlag = outUseFlag;
    }

}
