package com.ejianc.business.outrmat.contract.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 签字区分枚举
 */
public enum StatusTypeEnum {

    辅料中心租出合同结算单("辅料中心租出合同结算单", "EJCBT202209000011","settlexmf"),
    租出遗失单("租出遗失单", "EJCBT202209000010","losexmf"),
    租出启用单("租出启用单", "EJCBT202209000001","startMSupplier"),
    租出停用单("租出停用单", "EJCBT202209000002","stopMsupplier"),
    租出出库单("租出验收单", "EJCBT202209000015","deliverySupplier"),
    租出退赔单("租出退赔单", "EJCBT202209000012","restituteSupplier"),
    ;

    private final String name;
    private final String code;
    private final String fileType;
    private static Map<String, StatusTypeEnum> enumMap = new HashMap();

    StatusTypeEnum(String name, String code,String fileType) {
        this.name = name;
        this.code = code;
        this.fileType = fileType;
    }

    public String getFileType() {
        return fileType;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static StatusTypeEnum getEnumByName(String billTypeName) {
        return (StatusTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(StatusTypeEnum.class).stream().collect(Collectors.toMap(StatusTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
