package com.ejianc.business.outrmat.calculate.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 租金计算单
 * 
 * @author generator
 * 
 */
public class OutRmatCalculateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目组织id
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织id
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Long contractId; // 合同id
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private Long supplierId; // 供应商
    private String supplierName; // 供应商名称
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    private Integer monthSettlementDay; // 月结算日
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentDate; // 租金计算日期
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private BigDecimal rentTaxMny; // 本次租赁金额
    private BigDecimal rentMny; // 本次租赁金额(无税)
    private BigDecimal rentTax; // 本次租赁税额
    private String memo; // 备注
    private Integer settleFlag; // 是否结算 0-未结算，1-已结算

    private String billStateName; // 单据状态名称
    private String settleFlagName; // 结算状态名称
    private String calculateType; // 租金计算类型（0：手动计算，1：自动计算）
    @TableField(value="project_org_id")
    private Long projectOrgId; // 项目组织id
    @TableField(value="project_org_code")
    private String projectOrgCode; // 项目组织code
    @TableField(value="project_org_name")
    private String projectOrgName; // 项目组织name
    @TableField(value="project_dept_id")
    private Long projectDeptId; // 项目部门id
    @TableField(value="project_dept_code")
    private String projectDeptCode; // 项目部门code
    @TableField(value="project_dept_name")
    private String projectDeptName; // 项目部门name
    private String rentType; // 租赁方式(0-外租，1-内租)
    private String rentTypeName; // 租赁方式名称


    
    private List<OutRmatCalculateDailyVO> dailyList = new ArrayList<>(); // 租金计算单-日租
    private List<OutRmatCalculateMonthVO> monthList = new ArrayList<>(); // 租金计算单-月租
    private List<OutRmatCalculateNumVO> numList = new ArrayList<>(); // 租金计算单-工程量租

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode="out_arri_contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }
    public Integer getMonthSettlementDay() {
        return monthSettlementDay;
    }

    public void setMonthSettlementDay(Integer monthSettlementDay) {
        this.monthSettlementDay = monthSettlementDay;
    }
    public Date getRentDate() {
        return rentDate;
    }

    public void setRentDate(Date rentDate) {
        this.rentDate = rentDate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }
    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }
    public BigDecimal getRentTax() {
        return rentTax;
    }

    public void setRentTax(BigDecimal rentTax) {
        this.rentTax = rentTax;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }
    public String getCalculateType() {
        return calculateType;
    }

    public void setCalculateType(String calculateType) {
        this.calculateType = calculateType;
    }

    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }

    public String getProjectOrgCode() {
        return projectOrgCode;
    }

    public void setProjectOrgCode(String projectOrgCode) {
        this.projectOrgCode = projectOrgCode;
    }

    public String getProjectOrgName() {
        return projectOrgName;
    }

    public void setProjectOrgName(String projectOrgName) {
        this.projectOrgName = projectOrgName;
    }

    public Long getProjectDeptId() {
        return projectDeptId;
    }

    public void setProjectDeptId(Long projectDeptId) {
        this.projectDeptId = projectDeptId;
    }

    public String getProjectDeptCode() {
        return projectDeptCode;
    }

    public void setProjectDeptCode(String projectDeptCode) {
        this.projectDeptCode = projectDeptCode;
    }

    public String getProjectDeptName() {
        return projectDeptName;
    }

    public void setProjectDeptName(String projectDeptName) {
        this.projectDeptName = projectDeptName;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }

    public List<OutRmatCalculateDailyVO> getDailyList() {
    return dailyList;
    }

    public void setDailyList(List<OutRmatCalculateDailyVO> dailyList) {
    this.dailyList = dailyList;
    }
    public List<OutRmatCalculateMonthVO> getMonthList() {
    return monthList;
    }

    public void setMonthList(List<OutRmatCalculateMonthVO> monthList) {
    this.monthList = monthList;
    }
    public List<OutRmatCalculateNumVO> getNumList() {
    return numList;
    }

    public void setNumList(List<OutRmatCalculateNumVO> numList) {
    this.numList = numList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getSettleFlagName() {
        return settleFlagName;
    }

    public void setSettleFlagName(String settleFlagName) {
        this.settleFlagName = settleFlagName;
    }

    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }
}
