package com.ejianc.business.assist.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 辅料中心采购合同-材料明细变更表
 *
 * @author generator
 */
public class MaterialChangeDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long changeId; // 变更主键
    private String changeType; // 变更类型
    private Long contractId; // 合同id
    private Long sourceId; // 来源数据Id(参照数据id)
    private Long sourceBid; // 来源子表主键(合同子表id)
    private String sourceType; // 来源类型：0-直接新增，1-定标结果带入
    private Long materialTypeId; // 物资材料分类Id
    private String materialTypeCode; // 材料分类编码
    private String materialTypeName; // 物资材料分类名称
    private Long materialId; // 材料id
    private String materialCode; // 材料编码
    private String materialName; // 材料名称
    private String spec; // 规格/型号
    private String brand; // 品牌
    private Long unitId; // 计量单位id
    private String unitName; // 计量单位名称
    private BigDecimal count; // 数量
    private BigDecimal unitPrice; // 单价(无税)
    private BigDecimal unitTaxPrice; // 单价
    private BigDecimal taxRate; // 税率
    private BigDecimal taxMny; // 金额
    private BigDecimal mny; // 金额(无税)
    private BigDecimal tax; // 税额
    private String memo; // 备注
    private Integer rowType; // 行分类：0-分类，1-材料

    private String bcBrand; // 变更前品牌
    private BigDecimal bcCount; // 变更前数量
    private BigDecimal bcUnitTaxPrice; // 变更前单价
    private String bcUnitName; // 变更前计量单位
    private BigDecimal bcTaxRate; // 变更前税率
    private BigDecimal bcTaxMny; // 变更前金额
    private String bcMemo; // 变更前备注


    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    @ReferSerialTransfer(referCode = "share-unit")
    public Long getUnitId() {
        return unitId;
    }

    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getCount() {
        return count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getUnitTaxPrice() {
        return unitTaxPrice;
    }

    public void setUnitTaxPrice(BigDecimal unitTaxPrice) {
        this.unitTaxPrice = unitTaxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getRowType() {
        return rowType;
    }

    public void setRowType(Integer rowType) {
        this.rowType = rowType;
    }

    public String getBcBrand() {
        return bcBrand;
    }

    public void setBcBrand(String bcBrand) {
        this.bcBrand = bcBrand;
    }

    public BigDecimal getBcCount() {
        return bcCount;
    }

    public void setBcCount(BigDecimal bcCount) {
        this.bcCount = bcCount;
    }

    public BigDecimal getBcUnitTaxPrice() {
        return bcUnitTaxPrice;
    }

    public void setBcUnitTaxPrice(BigDecimal bcUnitTaxPrice) {
        this.bcUnitTaxPrice = bcUnitTaxPrice;
    }

    public String getBcUnitName() {
        return bcUnitName;
    }

    public void setBcUnitName(String bcUnitName) {
        this.bcUnitName = bcUnitName;
    }

    public BigDecimal getBcTaxRate() {
        return bcTaxRate;
    }

    public void setBcTaxRate(BigDecimal bcTaxRate) {
        this.bcTaxRate = bcTaxRate;
    }

    public BigDecimal getBcTaxMny() {
        return bcTaxMny;
    }

    public void setBcTaxMny(BigDecimal bcTaxMny) {
        this.bcTaxMny = bcTaxMny;
    }

    public String getBcMemo() {
        return bcMemo;
    }

    public void setBcMemo(String bcMemo) {
        this.bcMemo = bcMemo;
    }
}
