package com.ejianc.business.assist.store.util;

import com.ejianc.framework.cache.utils.RedisTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.annotation.PostConstruct;

@Component("assistStoreLockUtil")
public class StoreLockUtil {

    @Autowired
    private JedisPool jedisPool2;


    private static JedisPool jedisPool;


    private final static String REQUEST_ID = "StoreSurplusUpdate";

    private final static String LOCK_KEY = "STOREKEY";

    private static StoreLockUtil util;


    @PostConstruct
    public void init() {
        util = this;
        jedisPool = this.jedisPool2;
    }


    public static Boolean getLock(Long storeId) {
        boolean locked = false;
        if (storeId != null) {
            Jedis jedis = jedisPool.getResource();
            locked = RedisTool.tryLock(jedis, LOCK_KEY + storeId, REQUEST_ID, 1000);
            return locked;

        }
        return false;
    }

    public static void releaseLock(Long storeId) {
        if (storeId != null) {
            Jedis jedis = jedisPool.getResource();
            RedisTool.releaseLock(jedis,LOCK_KEY + storeId, REQUEST_ID);
            jedis.close();
        }
    }
}
