/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.store.util;

import com.ejianc.business.assist.store.consts.InOutTypeEnum;
import com.ejianc.business.assist.store.consts.StoreCommonConsts;
import com.ejianc.business.assist.store.vo.FlowVO;
import com.ejianc.business.assist.store.vo.InOutVO;
import com.ejianc.business.assist.store.vo.SurplusUpdateVO;
import com.ejianc.business.assist.store.vo.SurplusVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class StoreManageUtil {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    public static FlowVO getFlowVO(InOutTypeEnum inOutTypeEnum, Integer partyaFlag) {
        FlowVO flowVO = new FlowVO();
        String billCode = inOutTypeEnum.getInOutFlag() + inOutTypeEnum.getInOutType().toString() + StoreManageUtil.getTimeStr();
        flowVO.setBillCode(billCode);
        flowVO.setBillDate(new Date());
        flowVO.setInOutFlag(inOutTypeEnum.getInOutFlag());
        flowVO.setInOutType(inOutTypeEnum.getInOutType());
        flowVO.setInOutTypeName(inOutTypeEnum.getInOutTypeName());
        flowVO.setOutUseFlag(inOutTypeEnum.getOutUseFlag());
        flowVO.setPartyaFlag(partyaFlag != null ? partyaFlag : StoreCommonConsts.NO);
        flowVO.setReturnGoodsFlag(InOutTypeEnum.\u6750\u6599\u9000\u8d27.getInOutType().equals(inOutTypeEnum.getInOutType()) ? StoreCommonConsts.YES : StoreCommonConsts.NO);
        flowVO.setReturnStoreFlag(InOutTypeEnum.\u9886\u6599\u9000\u5e93.getInOutType().equals(inOutTypeEnum.getInOutType()) ? StoreCommonConsts.YES : StoreCommonConsts.NO);
        flowVO.setEffectiveDate(new Date());
        flowVO.setAccountFlag(StoreCommonConsts.NO);
        flowVO.setSettleFlag(StoreCommonConsts.NO);
        if (StoreCommonConsts.IN_OUT_TYPE_IN.equals(inOutTypeEnum.getOutUseFlag()) || InOutTypeEnum.\u9886\u6599\u9000\u5e93.getInOutType().equals(inOutTypeEnum.getInOutType())) {
            flowVO.setEffectiveState(StoreCommonConsts.YES);
        } else {
            flowVO.setEffectiveState(StoreCommonConsts.NO);
        }
        flowVO.setTurnFlag(inOutTypeEnum.getTurnFlag());
        return flowVO;
    }

    public static SurplusUpdateVO getSurplusUpdateVO(Long storeId, List<FlowVO> flowVOList, boolean isRollback) {
        Set materialIdsSet = flowVOList.stream().map(e -> e.getMaterialId()).collect(Collectors.toSet());
        Set sourceIdsSet = flowVOList.stream().map(e -> e.getSourceId()).collect(Collectors.toSet());
        SurplusUpdateVO surplusUpdateVO = new SurplusUpdateVO();
        surplusUpdateVO.setMaterialIds(new ArrayList<Long>(materialIdsSet));
        surplusUpdateVO.setSourceIds(new ArrayList<Long>(sourceIdsSet));
        surplusUpdateVO.setFlowVOList(flowVOList);
        ArrayList<SurplusVO> surplusVOS = new ArrayList<SurplusVO>();
        for (FlowVO flowVO : flowVOList) {
            SurplusVO surplusVO = (SurplusVO)((Object)BeanMapper.map((Object)((Object)flowVO), SurplusVO.class));
            surplusVO.setSurplusMny(isRollback ? ComputeUtil.convertToMinusNumber((BigDecimal)flowVO.getMny()) : flowVO.getMny());
            surplusVO.setSurplusTaxMny(isRollback ? ComputeUtil.convertToMinusNumber((BigDecimal)flowVO.getTaxMny()) : flowVO.getTaxMny());
            surplusVO.setSurplusNum(isRollback ? ComputeUtil.convertToMinusNumber((BigDecimal)flowVO.getNum()) : flowVO.getNum());
            surplusVO.setInstoreMny(isRollback ? ComputeUtil.convertToMinusNumber((BigDecimal)flowVO.getMny()) : flowVO.getMny());
            surplusVO.setInstoreTaxMny(isRollback ? ComputeUtil.convertToMinusNumber((BigDecimal)flowVO.getTaxMny()) : flowVO.getTaxMny());
            surplusVO.setInstoreNum(isRollback ? ComputeUtil.convertToMinusNumber((BigDecimal)flowVO.getNum()) : flowVO.getNum());
            if (!isRollback) {
                surplusVO.setReturnGoodsNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)flowVO.getNum()));
            } else {
                surplusVO.setReturnGoodsNum(ComputeUtil.convertToMinusNumber((BigDecimal)flowVO.getNum()));
            }
            surplusVOS.add(surplusVO);
        }
        surplusUpdateVO.setStoreId(storeId);
        surplusUpdateVO.setSurplusVOList(surplusVOS);
        return surplusUpdateVO;
    }

    public static InOutVO getInOutVO(FlowVO inFlowVO, InOutVO outInOutVO, BigDecimal useNum) {
        InOutVO inOutVO = (InOutVO)((Object)BeanMapper.map((Object)((Object)inFlowVO), InOutVO.class));
        inOutVO.setId(null);
        inOutVO.setCreateUserCode(null);
        inOutVO.setCreateTime(null);
        inOutVO.setUpdateTime(null);
        inOutVO.setUpdateUserCode(null);
        inOutVO.setInStoreId(inFlowVO.getStoreId());
        inOutVO.setInStoreName(inFlowVO.getStoreName());
        inOutVO.setInProjectId(inFlowVO.getProjectId());
        inOutVO.setInProjectName(inFlowVO.getProjectName());
        inOutVO.setInFlowId(inFlowVO.getId());
        inOutVO.setInBillId(inFlowVO.getSourceId());
        inOutVO.setInBillDetailId(inFlowVO.getSourceDetailId());
        inOutVO.setInBillCode(inFlowVO.getSourceBillCode());
        inOutVO.setOutNum(BigDecimal.ZERO);
        inOutVO.setReturnStoreNum(BigDecimal.ZERO);
        inOutVO.setOutLockNum(useNum);
        inOutVO.setEffectiveState(StoreCommonConsts.NO);
        inOutVO.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
        inOutVO.setInOutType(outInOutVO.getInOutType());
        inOutVO.setInOutTypeName(outInOutVO.getInOutTypeName());
        inOutVO.setOutStoreId(outInOutVO.getOutStoreId());
        inOutVO.setOutStoreName(outInOutVO.getOutStoreName());
        inOutVO.setOutProjectId(outInOutVO.getOutProjectId());
        inOutVO.setOutProjectName(outInOutVO.getOutProjectName());
        inOutVO.setOutFlowId(outInOutVO.getOutFlowId());
        inOutVO.setOutBillDetailId(outInOutVO.getOutBillDetailId());
        inOutVO.setOutBillId(outInOutVO.getOutBillId());
        inOutVO.setOutBillCode(outInOutVO.getOutBillCode());
        inOutVO.setMaterialId(outInOutVO.getMaterialId());
        inOutVO.setOutDate(outInOutVO.getOutDate());
        inOutVO.setPickUnitId(outInOutVO.getPickUnitId());
        inOutVO.setPickUnitName(outInOutVO.getPickUnitName());
        inOutVO.setPickContractId(outInOutVO.getPickContractId());
        inOutVO.setPickContractName(outInOutVO.getPickContractName());
        return inOutVO;
    }

    public static List<FlowVO> getOutFlowVOByInFlowVO(List<FlowVO> inFlowVOList) {
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        inFlowVOList.forEach(t -> {
            FlowVO out = (FlowVO)((Object)((Object)BeanMapper.map((Object)t, FlowVO.class)));
            long outId = IdWorker.getId();
            out.setId(outId);
            out.setInOutFlag(StoreCommonConsts.IN_OUT_TYPE_OUT);
            t.setStraightOutFlowId(outId);
            t.setId(IdWorker.getId());
            flowVOS.add(out);
        });
        return flowVOS;
    }

    public static List<InOutVO> getInOutVOsByInAndOutFlowVOList(List<FlowVO> inFlowVOList, List<FlowVO> outFlowVOList) {
        ArrayList<InOutVO> inOutVOS = new ArrayList<InOutVO>();
        for (int j = 0; j < inFlowVOList.size(); ++j) {
            FlowVO inFlowVO = inFlowVOList.get(j);
            FlowVO outFlowVO = outFlowVOList.get(j);
            InOutVO inOutVO = (InOutVO)((Object)BeanMapper.map((Object)((Object)inFlowVO), InOutVO.class));
            inFlowVO.setStraightOutFlowId(outFlowVO.getId());
            inOutVO.setId(null);
            inOutVO.setVersion(null);
            inOutVO.setOutDate(new Date());
            inOutVO.setInOutType(outFlowVO.getInOutType());
            inOutVO.setInOutTypeName(outFlowVO.getInOutTypeName());
            inOutVO.setInStoreId(inFlowVO.getStoreId());
            inOutVO.setInStoreName(inFlowVO.getStoreName());
            inOutVO.setInProjectId(inFlowVO.getProjectId());
            inOutVO.setInProjectName(inFlowVO.getProjectName());
            inOutVO.setInFlowId(inFlowVO.getId());
            inOutVO.setInBillId(inFlowVO.getSourceId());
            inOutVO.setInBillDetailId(inFlowVO.getSourceDetailId());
            inOutVO.setInBillCode(inFlowVO.getSourceBillCode());
            inOutVO.setOutStoreId(outFlowVO.getStoreId());
            inOutVO.setOutStoreName(outFlowVO.getStoreName());
            inOutVO.setOutProjectId(outFlowVO.getProjectId());
            inOutVO.setOutProjectName(outFlowVO.getProjectName());
            inOutVO.setOutFlowId(outFlowVO.getId());
            inOutVO.setOutBillId(outFlowVO.getSourceId());
            inOutVO.setOutBillDetailId(outFlowVO.getSourceDetailId());
            inOutVO.setOutBillCode(outFlowVO.getSourceBillCode());
            inOutVO.setOutNum(inFlowVO.getNum());
            inOutVO.setReturnStoreNum(BigDecimal.ZERO);
            inOutVO.setOutLockNum(BigDecimal.ZERO);
            inOutVO.setEffectiveDate(new Date());
            inOutVO.setEffectiveState(StoreCommonConsts.YES);
            inOutVO.setOutUseFlag(StoreCommonConsts.UseOutFlag.USE_FINISH);
            inOutVOS.add(inOutVO);
        }
        return inOutVOS;
    }

    static String getTimeStr() {
        return sdf.format(new Date());
    }

    public static void main(String[] args) {
        System.out.println(InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93.getTurnFlag());
        System.out.println(InOutTypeEnum.\u6536\u6599\u5165\u5e93.getTurnFlag());
    }

    public static InOutVO getTurnInOutVO(FlowVO inFlowVO, InOutVO outInOutVO, BigDecimal useNum, BigDecimal thisLockNetMny, BigDecimal thisLockNetTaxMny, BigDecimal thisLockPurchaseMny, BigDecimal thisLockPurchaseTaxMny) {
        InOutVO inOutVO = (InOutVO)((Object)BeanMapper.map((Object)((Object)inFlowVO), InOutVO.class));
        inOutVO.setOutNetMny(thisLockNetMny);
        inOutVO.setOutNetTaxMny(thisLockNetTaxMny);
        BigDecimal netPrice = ComputeUtil.safeDiv((BigDecimal)thisLockNetMny, (BigDecimal)useNum);
        BigDecimal netTaxPrice = ComputeUtil.safeDiv((BigDecimal)thisLockNetTaxMny, (BigDecimal)useNum);
        inOutVO.setPrice(netPrice);
        inOutVO.setTaxPrice(netTaxPrice);
        inOutVO.setPurchaseMny(thisLockPurchaseMny);
        inOutVO.setPurchaseTaxMny(thisLockPurchaseTaxMny);
        inOutVO.setId(null);
        inOutVO.setCreateUserCode(null);
        inOutVO.setCreateTime(null);
        inOutVO.setUpdateTime(null);
        inOutVO.setUpdateUserCode(null);
        inOutVO.setInStoreId(inFlowVO.getStoreId());
        inOutVO.setInStoreName(inFlowVO.getStoreName());
        inOutVO.setInProjectId(inFlowVO.getProjectId());
        inOutVO.setInProjectName(inFlowVO.getProjectName());
        inOutVO.setInFlowId(inFlowVO.getId());
        inOutVO.setInBillId(inFlowVO.getSourceId());
        inOutVO.setInBillDetailId(inFlowVO.getSourceDetailId());
        inOutVO.setInBillCode(inFlowVO.getSourceBillCode());
        inOutVO.setOutNum(BigDecimal.ZERO);
        inOutVO.setReturnStoreNum(BigDecimal.ZERO);
        inOutVO.setOutLockNum(useNum);
        inOutVO.setEffectiveState(StoreCommonConsts.NO);
        inOutVO.setOutUseFlag(StoreCommonConsts.UseOutFlag.USEING);
        inOutVO.setInOutType(outInOutVO.getInOutType());
        inOutVO.setInOutTypeName(outInOutVO.getInOutTypeName());
        inOutVO.setOutStoreId(outInOutVO.getOutStoreId());
        inOutVO.setOutStoreName(outInOutVO.getOutStoreName());
        inOutVO.setOutProjectId(outInOutVO.getOutProjectId());
        inOutVO.setOutProjectName(outInOutVO.getOutProjectName());
        inOutVO.setOutFlowId(outInOutVO.getOutFlowId());
        inOutVO.setOutBillDetailId(outInOutVO.getOutBillDetailId());
        inOutVO.setOutBillId(outInOutVO.getOutBillId());
        inOutVO.setOutBillCode(outInOutVO.getOutBillCode());
        inOutVO.setMaterialId(outInOutVO.getMaterialId());
        inOutVO.setOutDate(outInOutVO.getOutDate());
        inOutVO.setPickUnitId(outInOutVO.getPickUnitId());
        inOutVO.setPickUnitName(outInOutVO.getPickUnitName());
        inOutVO.setPickContractId(outInOutVO.getPickContractId());
        inOutVO.setPickContractName(outInOutVO.getPickContractName());
        return inOutVO;
    }
}

